/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.production;

import java.util.stream.Stream;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;

public final class ProductionUtils {
    private ProductionUtils() {
    }

    public static Stream<Modifier> getRebelProductionModifiersForBuilding(BuildingType buildingType, int colonyProductionBonus, GoodsType goodsType, UnitType unitType) {
        if (colonyProductionBonus == 0) {
            return Stream.empty();
        }
        float rebelFactor = buildingType != null ? buildingType.getRebelFactor() : 1.0f;
        int bonus = (int)Math.floor((float)colonyProductionBonus * rebelFactor);
        return ProductionUtils.createRebelProductionModifierStream(20, goodsType, bonus);
    }

    public static Stream<Modifier> getRebelProductionModifiersForTile(Tile tile, int colonyProductionBonus, GoodsType goodsType, UnitType unitType) {
        if (colonyProductionBonus == 0) {
            return Stream.empty();
        }
        if (unitType == null && colonyProductionBonus < 0) {
            return Stream.empty();
        }
        if (unitType == null) {
            return ProductionUtils.createRebelProductionModifierStream(35, goodsType, colonyProductionBonus);
        }
        float rebelFactor = 1.0f;
        if (unitType != null && unitType.getExpertProduction() != null && unitType.getExpertProduction().equals(goodsType)) {
            rebelFactor *= 2.0f;
        }
        if (tile.getResource() != null) {
            Stream<Modifier> multiplicativeResourceModifiers = tile.getResource().getProductionModifiers(goodsType, unitType).filter(m -> m.getType() == Modifier.ModifierType.MULTIPLICATIVE);
            rebelFactor = FeatureContainer.applyModifiers(rebelFactor, tile.getGame().getTurn(), multiplicativeResourceModifiers);
        }
        int bonus = (int)Math.max((double)colonyProductionBonus, Math.floor((float)colonyProductionBonus * rebelFactor));
        return ProductionUtils.createRebelProductionModifierStream(35, goodsType, bonus);
    }

    private static Stream<Modifier> createRebelProductionModifierStream(int modifierIndex, GoodsType goodsType, int bonus) {
        Modifier mod = new Modifier(goodsType.getId(), bonus, Modifier.ModifierType.ADDITIVE, Specification.SOL_MODIFIER_SOURCE);
        mod.setModifierIndex(modifierIndex);
        return Stream.of(mod);
    }
}

