/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.option.OptionGroup;

public class StartMapAction
extends FreeColAction {
    public static final String id = "startMapAction";

    public StartMapAction(FreeColClient freeColClient) {
        super(freeColClient, id);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.freeColClient.isMapEditor() || this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        File startFile = FreeColDirectories.getStartMapFile();
        this.freeColClient.getMapEditorController().saveMapEditorGame(startFile);
        Game game = this.freeColClient.getGame();
        OptionGroup options = game.getMapGeneratorOptions();
        options.setFile("model.option.importFile", startFile);
        File mapOptionsFile = FreeColDirectories.getOptionsFile("map_generator_options.xml");
        options.save(mapOptionsFile, null, true);
        this.freeColClient.getGUI().removeInGameComponents();
        this.freeColClient.getGUI().showNewPanel(game.getSpecification());
    }
}

