/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.concurrent.ConcurrentHashMap;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Layout;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public abstract class LispClass
extends StandardObject {
    private static final ConcurrentHashMap<Symbol, LispObject> map = new ConcurrentHashMap();
    private final int sxhash;
    private LispObject name;
    private LispObject propertyList;
    private Layout classLayout;
    private LispObject directSuperclasses = Lisp.NIL;
    private LispObject directSubclasses = Lisp.NIL;
    private LispObject classPrecedenceList = Lisp.NIL;
    private LispObject directMethods = Lisp.NIL;
    private LispObject documentation = Lisp.NIL;
    private boolean finalized;
    private static final Primitive FIND_CLASS = new Primitive(Symbol.FIND_CLASS, "symbol &optional errorp environment"){

        @Override
        public LispObject execute(LispObject arg) {
            return LispClass.findClass(arg, true);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            return LispClass.findClass(first, second != Lisp.NIL);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return LispClass.findClass(first, second != Lisp.NIL);
        }
    };
    private static final Primitive _SET_FIND_CLASS = new Primitive("%set-find-class", Lisp.PACKAGE_SYS, true){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Symbol name = Lisp.checkSymbol(first);
            if (second == Lisp.NIL) {
                LispClass.removeClass(name);
                return second;
            }
            LispClass.addClass(name, second);
            return second;
        }
    };
    private static final Primitive SUBCLASSP = new Primitive(Symbol.SUBCLASSP, "class"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            return LispClass.subclassp(first, second) ? Lisp.T : Lisp.NIL;
        }
    };

    public static <T extends LispClass> T addClass(Symbol symbol, T c) {
        map.put(symbol, c);
        return c;
    }

    public static LispObject addClass(Symbol symbol, LispObject c) {
        map.put(symbol, c);
        return c;
    }

    public static void removeClass(Symbol symbol) {
        map.remove(symbol);
    }

    public static LispClass findClass(Symbol symbol) {
        return (LispClass)map.get(symbol);
    }

    public static LispObject findClass(LispObject name, boolean errorp) {
        Symbol symbol = Lisp.checkSymbol(name);
        LispObject c = map.get(symbol);
        if (c != null) {
            return c;
        }
        if (errorp) {
            StringBuilder sb = new StringBuilder("There is no class named ");
            sb.append(name.princToString());
            sb.append('.');
            return Lisp.error(new LispError(sb.toString()));
        }
        return Lisp.NIL;
    }

    protected LispClass(Layout layout) {
        super(layout, layout == null ? 0 : layout.getLength());
        this.sxhash = this.hashCode() & Integer.MAX_VALUE;
    }

    protected LispClass(Symbol symbol) {
        this(null, symbol);
    }

    protected LispClass(Layout layout, Symbol symbol) {
        super(layout, layout == null ? 0 : layout.getLength());
        this.setName(symbol);
        this.sxhash = this.hashCode() & Integer.MAX_VALUE;
    }

    protected LispClass(Layout layout, Symbol symbol, LispObject directSuperclasses) {
        super(layout, layout == null ? 0 : layout.getLength());
        this.sxhash = this.hashCode() & Integer.MAX_VALUE;
        this.setName(symbol);
        this.setDirectSuperclasses(directSuperclasses);
    }

    @Override
    public LispObject getParts() {
        LispObject result = Lisp.NIL;
        result = result.push(new Cons("NAME", this.name != null ? this.name : Lisp.NIL));
        result = result.push(new Cons("LAYOUT", this.getClassLayout() != null ? this.getClassLayout() : Lisp.NIL));
        result = result.push(new Cons("DIRECT-SUPERCLASSES", this.getDirectSuperclasses()));
        result = result.push(new Cons("DIRECT-SUBCLASSES", this.getDirectSubclasses()));
        result = result.push(new Cons("CLASS-PRECEDENCE-LIST", this.getCPL()));
        result = result.push(new Cons("DIRECT-METHODS", this.getDirectMethods()));
        result = result.push(new Cons("DOCUMENTATION", this.getDocumentation()));
        return result.nreverse();
    }

    @Override
    public final int sxhash() {
        return this.sxhash;
    }

    public LispObject getName() {
        return this.name;
    }

    public void setName(LispObject name) {
        this.name = name;
    }

    @Override
    public final LispObject getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = Lisp.NIL;
        }
        return this.propertyList;
    }

    @Override
    public final void setPropertyList(LispObject obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        this.propertyList = obj;
    }

    public Layout getClassLayout() {
        return this.classLayout;
    }

    public void setClassLayout(LispObject layout) {
        this.classLayout = layout == Lisp.NIL ? null : (Layout)layout;
    }

    public final int getLayoutLength() {
        if (this.layout == null) {
            return 0;
        }
        return this.layout.getLength();
    }

    public LispObject getDirectSuperclasses() {
        return this.directSuperclasses;
    }

    public void setDirectSuperclasses(LispObject directSuperclasses) {
        this.directSuperclasses = directSuperclasses;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setFinalized(boolean b) {
        this.finalized = b;
    }

    public final void setDirectSuperclass(LispObject superclass) {
        this.setDirectSuperclasses(new Cons(superclass));
    }

    public LispObject getDirectSubclasses() {
        return this.directSubclasses;
    }

    public void setDirectSubclasses(LispObject directSubclasses) {
        this.directSubclasses = directSubclasses;
    }

    public LispObject getCPL() {
        return this.classPrecedenceList;
    }

    public void setCPL(LispObject ... cpl) {
        LispObject obj1 = cpl[0];
        if (obj1 instanceof Cons && cpl.length == 1) {
            this.classPrecedenceList = obj1;
        } else {
            Debug.assertTrue(obj1 == this);
            LispObject l = Lisp.NIL;
            int i = cpl.length;
            while (i-- > 0) {
                l = new Cons(cpl[i], l);
            }
            this.classPrecedenceList = l;
        }
    }

    public LispObject getDirectMethods() {
        return this.directMethods;
    }

    public void setDirectMethods(LispObject methods) {
        this.directMethods = methods;
    }

    public LispObject getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(LispObject doc) {
        this.documentation = doc;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.CLASS;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.CLASS;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.CLASS) {
            return Lisp.T;
        }
        if (type == StandardClass.CLASS) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean subclassp(LispObject obj) {
        return LispClass.subclassp(this, obj);
    }

    public static boolean subclassp(LispObject cls, LispObject obj) {
        LispObject cpl = cls instanceof LispClass ? ((LispClass)cls).getCPL() : Symbol.CLASS_PRECEDENCE_LIST.execute(cls);
        while (cpl != Lisp.NIL) {
            if (cpl.car() == obj) {
                return true;
            }
            cpl = ((Cons)cpl).cdr;
        }
        return false;
    }
}

