  global NoticeWindows
  set n [Unique]
  set win .notice$n
  set NoticeWindows [linsert $NoticeWindows 0 $win]

  LinkWindow $head.notice $win
  LinkWindow $win.head $head

# catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  bind $win <Visibility> {[WindowLink %W.view] Visible [string compare %s FullyObscured]}
  bind $win <Map> {[WindowLink %W.view] Visible 1}
  bind $win <Unmap> {[WindowLink %W.view] Visible 0}

  wm title $win {SimCity Notice}
  wm iconname $win {SimCity Notice}
  wm geometry $win 400x300+20-20
  wm positionfrom $win user
  wm sizefrom $win user
  wm maxsize $win 1000 1000
  wm minsize $win 100 100
  wm protocol $win WM_DELETE_WINDOW "DeleteWindow notice NoticeWindows $win"

  frame $win.top \
    -relief raised \
    -borderwidth 2
  LinkWindow $win.background $win.top

  label $win.top.title \
    -borderwidth 4 \
    -relief raised \
    -font [Font $win Big]
  LinkWindow $win.title $win.top.title

  text $win.top.text \
    -borderwidth 4 \
    -insertbackground #0B0071 \
    -relief flat \
    -wrap word \
    -state disabled \
    -font [Font $win Large]
  LinkWindow $win.text $win.top.text

  label $win.top.text.left \
    -font [Font $win Large]\
    -borderwidth 0 \
    -relief flat
  LinkWindow $win.left $win.top.text.left

  label $win.top.text.middle \
    -font [Font $win Large]\
    -borderwidth 0 \
    -relief flat
  LinkWindow $win.middle $win.top.text.middle

  label $win.top.text.right \
    -font [Font $win Large]\
    -borderwidth 0 \
    -relief flat
  LinkWindow $win.right $win.top.text.right

  frame $win.top.viewframe\
    -borderwidth 8\
    -relief flat
  LinkWindow $win.viewframe $win.top.viewframe

  frame $win.top.viewframe.f\
    -cursor hand2\
    -borderwidth 2\
    -relief sunken

  pack append $win.top.viewframe\
    $win.top.viewframe.f \
	{top frame center expand fill}

  editorview $win.top.viewframe.f.view \
    -font [Font $win Big]\
    -width 128 -height 32
  LinkWindow $win.view $win.top.viewframe.f.view
  $win.top.viewframe.f.view ShowMe 0
  bind $win.top.viewframe.f.view <ButtonPress> \
	"ComeToMe %W"

  pack append $win.top.viewframe.f\
    $win.top.viewframe.f.view \
	{top frame center expand fill}

  pack append $win.top\
    $win.top.title	{top frame center fillx} \
    $win.top.text	{right frame center expand fill}

  button $win.dismiss\
    -font [Font $win Large]\
    -text {Dismiss}\
    -command "wm withdraw $win"

  pack append $win\
    $win.dismiss	{bottom frame center fillx}\
    $win.top		{left frame center expand fill}

  update idletasks
  return $win
