/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: spieler.h
**
** benoetigt:
**  global.h
**
** Kommentar:
**  Datenstruktur zur Speicherung der Spieler und Schuesse sowie Funktionen
**  zur Umrechnung deren Position
*/


static char sccsid_spieler[] = "@(#)spieler.h	1.8 5/17/94";


#define SPIELERANZ 42

#define WINKANZ 64  /* Anzahl der Drehwinkel fuer einen Spieler */

#define KUGELRAD (RASPT * 3 / 16)  /* Radius eines Spielers (relativ zur
        Gangbreite); muss <= RASPT * (sqrt(2)-1)/2 sein */

#define SCHUSSRAD (RASPT * 3 / 64) /* Radius eines Schusses (relativ zur
        Gangbreite) */


/* Rechnet Labyrinth-Koordinaten von grob/fein-Darstellung auf absolute
   Werte im feinen Raster um */
#define XPOS(pos) ((int)(pos).xgrob * RASPT + (int)(pos).xfein)
#define YPOS(pos) ((int)(pos).ygrob * RASPT + (int)(pos).yfein)

/* Rechnet Labyrinth-Koordinaten von absoluten Werten im feinen Raster
   auf grob/fein-Darstellung um */
#define SETX(pos,x) ((pos).xgrob = (x) / RASPT, (pos).xfein = (x) % RASPT)
#define SETY(pos,y) ((pos).ygrob = (y) / RASPT, (pos).yfein = (y) % RASPT)

/* Addiert Wert in feinem Raster zu Labyrinth-Koordinaten in grob/fein-
   Darstellung */
#define ADDX(pos,x) (SETX((pos),XPOS(pos)+(x)))
#define ADDY(pos,y) (SETY((pos),YPOS(pos)+(y)))

/* Subtahiert Wert in feinem Raster von Labyrinth-Koordinaten in grob/fein-
   Darstellung */
#define SUBX(pos,x) (ADDX((pos),-(x)))
#define SUBY(pos,y) (ADDY((pos),-(y)))


/* Position aufgeteilt in grobes (Labyrinth-Bloecke) und feines Raster */
struct position
{
	u_char xgrob;
	u_char xfein;
	u_char ygrob;
	u_char yfein;
};

/* Informationen ueber Spieler fuer Eingabe von rechne3d */
struct spieler
{
	struct position pos;
	s_char blick;         /* Blickrichtung in 0..WINKANZ */
	u_char farbe;
};

/* Informationen ueber Schuesse fuer Eingabe von rechne3d */
struct schuss
{
	struct position pos;
	u_char farbe;
};
