#ifndef _GRAPH_H
#define _GRAPH_H

const int ScreenWidth = 320;
const int ScreenHeight = 200;

#include "mytypes.h"
#include "list.h"

// if the key isn't one of these, its an ordinary key
enum { KEY_UPLEFT = 0x100, KEY_UP, KEY_UPRIGHT, KEY_LEFT, KEY_RIGHT,
       KEY_DOWNLEFT, KEY_DOWN, KEY_DOWNRIGHT, NO_KEY };

enum { MOUSE_LEFT, MOUSE_RIGHT, KEYBOARD, SELECT, MESG_READ };

typedef void (*HandlerFunc)(int);

class MsgQ;

struct ReadHandler
{
  void (*func)(MsgQ *q, int fd, int info);
  int fd, q;
  int info;
};

// defines a 320x200 graphics mode
// wrapper
// should setup graphics when constructed
// and reset to text when destructed
class Graphics
{
public:
  Graphics(void (*keyPressed)(int, int, int, char *)) {
    KeyPressed = keyPressed;
  }
  virtual ~Graphics() {}

  virtual int Width() { return 320; }
  virtual int Height() { return 200; }

  virtual int AllocColor(char *name) = 0;

  virtual void Refresh() {}

  // displays a message somewhere on the screen
  virtual void DisplayMessage(char *str, int color) = 0;

  // these functions should draw stuff on the map window

  virtual void WriteStr(int x, int y, char *str, int color) = 0;
  virtual void WriteChar(int x, int y, int ch, int color) = 0;

  virtual void WriteInt(int x, int y, int n, int width, int color);

  virtual void Clear() = 0;

  virtual void FillRect(int x, int y, int width, int ht, int col) = 0;

  virtual void Rect(int x, int y, int width, int ht, int col) = 0;

  virtual void BitBlt(int sx, int sy, int w, int h, int dx, int dy) = 0;

  virtual long CompilePixmap(char **pixmap) = 0;

  virtual void FreePixmap(long handle) = 0;

  virtual void DrawPixmap(int xc, int yc, long handle) = 0;

  virtual void GetPixmapInfo(long handle, int &w, int &h) = 0;

  // this function starts up an event driven loop and calls the handler
  // which you specified whenever some event occurs
  // event's are either keypresses or data arriving on the socket
  virtual int MainLoop() = 0; // will not return

  virtual void StartTimer(int which, int milli, HandlerFunc func) = 0;
  virtual void StopTimer(int which) = 0;

  // add a notify handler for data available on a fd
  virtual void AddReadNotify(int fd, void (*func)(MsgQ *, int, int),
			     int info = 0, int q = 1) = 0;

  // displays a choice box, arranges to call the key pressed routine
  // with the event choice box and a pointer to the string which was
  // selected
  virtual void CreateChoiceFrame(char *mesg, List<charp> choices) = 0;

  // pop up a message box, calls the key pressed routine with
  // MESG_READ when the user clicks ok
  virtual void MessageBox(char *mesg) = 0;

  ReadHandler **readHandlers;

  HandlerFunc Timers[3]; // upto three timer handlers

  void (*KeyPressed)(int event, int a, int b, char *data);
};

#endif
