/* $Id: output.h,v 30000.20 1993/05/04 22:39:28 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef OUTPUT_H
#define OUTPUT_H

#ifdef TERMCAP
# define SCREEN
#endif
#ifdef HARDCODE
# define SCREEN
#endif

extern void NDECL(ipos);
extern void NDECL(clr);
extern int  FDECL(putch,(int c));
extern void NDECL(init_term);
extern void NDECL(setup_screen);
extern void NDECL(oflush);
extern TOGGLER(tog_more);
extern TOGGLER(tog_visual);
extern TOGGLER(tog_insert);
extern TOGGLER(change_isize);
#ifdef SCREEN
extern void FDECL(put_world,(char *name));
extern void FDECL(put_mail,(int flag));
extern void FDECL(put_logging,(int flag));
extern void FDECL(put_active,(int count));
#else
# define put_world(name)
# define put_mail(flag)
# define put_logging(flag)
# define put_active(count)
#endif
extern void NDECL(fix_screen);
extern void NDECL(clear_input_line);
extern void FDECL(iputs,(char *s));
extern void NDECL(inewline);
extern void NDECL(ibs);
extern void FDECL(ibackword,(int place));
extern void FDECL(newpos,(int place));
extern void NDECL(dEOL);
extern void NDECL(do_refresh);
extern void NDECL(do_page);
extern void NDECL(do_hpage);
extern void NDECL(do_line);
extern void NDECL(do_flush);
extern void NDECL(do_line_refresh);
extern void NDECL(do_replace);
extern void NDECL(reset_outcount);
extern void FDECL(globalout,(Aline *aline));
extern void FDECL(screenout,(Aline *aline));
extern int  NDECL(getwrap);
extern void FDECL(setprompt,(char *s));
extern String *FDECL(wrap,(char **startp, int *firstp));
extern void NDECL(change_bar);

#endif /* OUTPUT_H */
