;;;; Miscellaneous useful macros.

;;; /shl <command>
; Executes a shell command, without the annoying redraw or messages of /sh.

/def shl = /quote -0 /echo !%*


;;; cddr
; Strips off first 2 words of a list.  Used by /reedit and /qdef below.

/def cddr = /echo -- %-2


;;; Re-edit
; Stick an existing macro definition in the input window for editing.
; syntax:  /reedit <macroname>

/def reedit = /grab $(/cddr $(/list - %{L-@}))


;;; Qdef - quote a macro to the mud
; syntax:  /qdef [<prefix>] <macro>
; If <prefix> is omitted, it defaults to :|

/def qdef = %{-L-:|} $(/cddr $(/list - %{L-@}))


;;; name - change your name (on a TinyMUD style mud)
; syntax:  /name [<name>]

/def name =\
    /let name=%1%;\
    /eval @name me=%%{name-${world_character}} ${world_password}


;;; mudquote - quote a mud command out loud
; syntax:  /mudquote <command>
; Requires /pcmd (see examples/pcmd.tf)

/def mudquote = \
    /def -1 -agG -p100 -t"%{outputprefix}" =\
        :> %*%%;\
        /def -agG -p100 -t"*" mudquote_all = :| %%%*%%;\
        /def -1 -agG -p101 -t"%{outputsuffix}" = /undef mudquote_all%;\
    /pcmd %*


;;; tfquote - quote a tf command out loud
; syntax:  /tfquote <command>

/def tfquote = :> %*%; /quote -0 :| `%*


;;; getline - grab the nth line from history and stick it in the input buffer
; syntax:  /getline <n>

/def getline = /quote /grab #%{1}-%{1}


;;; xtitle - change the titlebar on an xterm.
; syntax:  /xtitle <text>

/def xtitle = /echo \033]2;%*\07
