/*
 *	door.c
 *
 *	A gateway to another room.
 *	Doors are implemented as two gateways that share the same instance of 
 *	doordata.
 *
 *	Like gateways, doors are also pickupable, because I haven't got
 *	round to figuring out how best to stop them being pickupable.
 *	Maybe the door's creator or another wizard should be able to pick it up
 *	and ordinary mortals and npc shouldn't be able to.  Discuss...
 *
 *	You probably don't want this to print things out, that'll probably
 *	be done by classes inheriting from door.  But for development purposes
 *	this door talks to you!
 *
 *	Doors can be opened, closed and entered.
 *
 */
#include "door_logic.h"

inherit	"/complex/gateway";

private object	doordata;	/* Assumed to be an instance of doordata, if you put an instance
			 * of a differen class here when initialising then the thing'll
			 * fail!
			 */

void create()
{
	gateway::create();
	set_id(({"door"}));
        set_short("An uninitialised door");
	set_long("This is an uninitialised door.\n");
}


can_move_through_door()
{
	if (doordata->query_is_open()) {
		return 1;
	}
	else {
		tell_object(this_player(), "You bump your head on the closed door!\n");
		return 0;
	};
}


init()
{
	int	i;

	gateway::init();
	add_action("open", "open");
	add_action("close", "close");
	add_action("enter", "enter");
	/*
	 *	Check that door is open before allowing player to move throught
	 */
	set_move_hooks(({"can_move_through_door", "can_move_through_door"}));
}

enter(str)
{
	int	i,
		success;
	object	other_gateway,
		destination;

	i = member_array(str, query_id());
	if (i >= 0) {
		if (can_move_through_door()) {
			other_gateway = doordata->query_other_gateway(this_object());
			destination = environment(other_gateway);
			this_player()->move_player(destination);
		};
		return 1;
	};
	return 0;
}


tell_other_room(string str)
{
	if (doordata->query_gateway1() == this_object()) {
		tell_room(environment(doordata->query_gateway2()), str);
	}
	else {
		tell_room(environment(doordata->query_gateway1()), str);
	}
}

open(str)
{
	int	i,
		success;

	i = member_array(str, query_id());
	if (i >= 0) {
		success = doordata->open();
		if (success == DOORLOGIC_DOOR_OPENS) {
			tell_other_room("The door opens!\n");
			tell_room(environment(this_object()), "The door opens.\n");
			return 1;
		}
		else if (success == DOORLOGIC_DOOR_ALREADY_OPEN) {
			tell_object(this_player(), "The door is already open!\n");
			return 1;
		};
	}
	return 0;
}

close(str)
{
	int	i,
		success;

	i = member_array(str, query_id());
	if (i >= 0) {
		success = doordata->close();
		if (success == DOORLOGIC_DOOR_CLOSES) {
			tell_other_room("The door closes!\n");
			tell_room(environment(this_object()), "The door closes.\n");
			return 1;
		}
		else if (success == DOORLOGIC_DOOR_ALREADY_CLOSED) {
			tell_object(this_player(), "The door is already closed!\n");
			return 1;
		};
	}
	return 0;
}

query_short() {
	string	str;

	str = ": No door data defined!";

	if (doordata) {
		if (doordata->query_is_open()) {
			str = "(open)";
		}
		else {
			str = "(closed)";
		};
	};
	str = gateway::query_short() + " " + str;
	return str;
}

query_long() {
	return gateway::query_long(0);
}

set_door(object d)
{
	doordata = d;
}

query_door()
{
	return doordata;
}
