#ifndef lint
static char *RCSid = "$Header: login.c,v 1.5 89/09/28 02:31:46 mr-frog Exp $";
#endif /* not lint */

/*
 * login.c
 *
 * Log in to empire host
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "proto.h"

#include <ctype.h>
#include <stdio.h>

int
login(s, uname, cname, cpass, kill_proc)
	int	s;
	char	*uname;
	char	*cname;
	char	*cpass;
	int	kill_proc;
{
	extern	char *getpass();
	char	buf[1024];
	char	country[64];
	char	*ptr;
	char	*p;

	if (!expect(s, C_INIT, buf))
		return 0;
	(void) sendcmd(s, USER, uname);
	if (!expect(s, C_CMDOK, buf))
		return 0;
	if (cname == 0) {
		cname = country;
		(void) printf("Country name? ");
		*cname = 0;
		if (gets(cname) == 0 || *cname == 0)
			return 0;
	}
	(void) sendcmd(s, COUN, cname);
	if (!expect(s, C_CMDOK, buf)) {
		(void) fprintf(stderr, "empire: no such country\n");
		return 0;
	}
	if (cpass == 0) {
		cpass = getpass("Your name? ");
		if (cpass == NULL || *cpass == '\0')
			return 0;
	}
	(void) printf("\n");
	(void) sendcmd(s, PASS, cpass);
	bzero(cpass, strlen(cpass));		/* for core dumps */
	if (!expect(s, C_CMDOK, buf)) {
		(void) fprintf(stderr, "Bad password\n");
		return 0;
	}
	if (kill_proc) {
		(void) sendcmd(s, KILL, (char *)0);
		(void) printf("\n\t-=O=-\n");
		(void) expect(s, C_EXIT, buf);
		fprintf(stderr, "%s\n", buf);
		return 0;
	}
	(void) sendcmd(s, PLAY, (char *)0);
	(void) printf("\n\t-=O=-\n");
	if (!expect(s, C_INIT, buf)) {
		fprintf(stderr, "%s\n", buf);
		return 0;
	}
	for (ptr = buf; !isspace(*ptr); ptr++)
		;
	ptr++;
	p = index(ptr, '\n');
	if (p != 0)
		*p = 0;
	if (atoi(ptr) != CLIENTPROTO) {
		printf("Empire client out of date; get new version!\n");
		printf("   this version: %d, current version: %d\n",
			CLIENTPROTO, atoi(ptr));
	}
	return 1;
}
