/* File: tables.c */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	5	/* 18/210-18/219 */,
	5	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	2	/* 9 */,
	2	/* 10 */,
	2	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	16	/* 18/190-18/199 */,
	16	/* 18/200-18/209 */,
	16	/* 18/210-18/219 */,
	16	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99	/* 3 */,
	99	/* 4 */,
	99	/* 5 */,
	99	/* 6 */,
	99	/* 7 */,
	50	/* 8 */,
	30	/* 9 */,
	20	/* 10 */,
	15	/* 11 */,
	12	/* 12 */,
	11	/* 13 */,
	10	/* 14 */,
	9	/* 15 */,
	8	/* 16 */,
	7	/* 17 */,
	6	/* 18/00-18/09 */,
	6	/* 18/10-18/19 */,
	5	/* 18/20-18/29 */,
	5	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	3	/* 18/100-18/109 */,
	2	/* 18/110-18/119 */,
	2	/* 18/120-18/129 */,
	2	/* 18/130-18/139 */,
	2	/* 18/140-18/149 */,
	1	/* 18/150-18/159 */,
	1	/* 18/160-18/169 */,
	1	/* 18/170-18/179 */,
	1	/* 18/180-18/189 */,
	1	/* 18/190-18/199 */,
	0	/* 18/200-18/209 */,
	0	/* 18/210-18/219 */,
	0	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	17	/* 18/190-18/199 */,
	18	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130	/* 3 */,
	125	/* 4 */,
	122	/* 5 */,
	120	/* 6 */,
	118	/* 7 */,
	116	/* 8 */,
	114	/* 9 */,
	112	/* 10 */,
	110	/* 11 */,
	108	/* 12 */,
	106	/* 13 */,
	104	/* 14 */,
	103	/* 15 */,
	102	/* 16 */,
	101	/* 17 */,
	100	/* 18/00-18/09 */,
	99	/* 18/10-18/19 */,
	98	/* 18/20-18/29 */,
	97	/* 18/30-18/39 */,
	96	/* 18/40-18/49 */,
	95	/* 18/50-18/59 */,
	94	/* 18/60-18/69 */,
	93	/* 18/70-18/79 */,
	92	/* 18/80-18/89 */,
	91	/* 18/90-18/99 */,
	90	/* 18/100-18/109 */,
	89	/* 18/110-18/119 */,
	88	/* 18/120-18/129 */,
	87	/* 18/130-18/139 */,
	86	/* 18/140-18/149 */,
	85	/* 18/150-18/159 */,
	84	/* 18/160-18/169 */,
	83	/* 18/170-18/179 */,
	82	/* 18/180-18/189 */,
	81	/* 18/190-18/199 */,
	80	/* 18/200-18/209 */,
	80	/* 18/210-18/219 */,
	80	/* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	4	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	7	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	17	/* 18/190-18/199 */,
	18	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	5	/* 18/80-18/89 */,
	6	/* 18/90-18/99 */,
	7	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	9	/* 18/120-18/129 */,
	10	/* 18/130-18/139 */,
	11	/* 18/140-18/149 */,
	12	/* 18/150-18/159 */,
	13	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	15	/* 18/180-18/189 */,
	16	/* 18/190-18/199 */,
	17	/* 18/200-18/209 */,
	18	/* 18/210-18/219 */,
	19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	4	/* 18/00-18/09 */,
	4	/* 18/10-18/19 */,
	4	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	5	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	8	/* 18/130-18/139 */,
	8	/* 18/140-18/149 */,
	9	/* 18/150-18/159 */,
	9	/* 18/160-18/169 */,
	9	/* 18/170-18/179 */,
	9	/* 18/180-18/189 */,
	9	/* 18/190-18/199 */,
	10	/* 18/200-18/209 */,
	10	/* 18/210-18/219 */,
	10	/* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	4	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	7	/* 18/70-18/79 */,
	8	/* 18/80-18/89 */,
	9	/* 18/90-18/99 */,
	10	/* 18/100-18/109 */,
	10	/* 18/110-18/119 */,
	11	/* 18/120-18/129 */,
	12	/* 18/130-18/139 */,
	13	/* 18/140-18/149 */,
	14	/* 18/150-18/159 */,
	15	/* 18/160-18/169 */,
	16	/* 18/170-18/179 */,
	17	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	19	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 1	/* 17 */,
	128 + 2	/* 18/00-18/09 */,
	128 + 2	/* 18/10-18/19 */,
	128 + 2	/* 18/20-18/29 */,
	128 + 2	/* 18/30-18/39 */,
	128 + 2	/* 18/40-18/49 */,
	128 + 3	/* 18/50-18/59 */,
	128 + 3	/* 18/60-18/69 */,
	128 + 3	/* 18/70-18/79 */,
	128 + 4	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
byte adj_str_td[] =
{
	128 + -2	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 2	/* 18/00-18/09 */,
	128 + 2	/* 18/10-18/19 */,
	128 + 3	/* 18/20-18/29 */,
	128 + 3	/* 18/30-18/39 */,
	128 + 3	/* 18/40-18/49 */,
	128 + 3	/* 18/50-18/59 */,
	128 + 3	/* 18/60-18/69 */,
	128 + 4	/* 18/70-18/79 */,
	128 + 5	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 10	/* 18/140-18/149 */,
	128 + 11	/* 18/150-18/159 */,
	128 + 12	/* 18/160-18/169 */,
	128 + 13	/* 18/170-18/179 */,
	128 + 14	/* 18/180-18/189 */,
	128 + 15	/* 18/190-18/199 */,
	128 + 16	/* 18/200-18/209 */,
	128 + 18	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
byte adj_dex_th[] =
{
	128 + -3	/* 3 */,
	128 + -2	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 3	/* 18/20-18/29 */,
	128 + 3	/* 18/30-18/39 */,
	128 + 3	/* 18/40-18/49 */,
	128 + 4	/* 18/50-18/59 */,
	128 + 4	/* 18/60-18/69 */,
	128 + 4	/* 18/70-18/79 */,
	128 + 4	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
byte adj_str_th[] =
{
	128 + -3	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 0	/* 16 */,
	128 + 0	/* 17 */,
	128 + 1	/* 18/00-18/09 */,
	128 + 1	/* 18/10-18/19 */,
	128 + 1	/* 18/20-18/29 */,
	128 + 1	/* 18/30-18/39 */,
	128 + 1	/* 18/40-18/49 */,
	128 + 1	/* 18/50-18/59 */,
	128 + 1	/* 18/60-18/69 */,
	128 + 2	/* 18/70-18/79 */,
	128 + 3	/* 18/80-18/89 */,
	128 + 4	/* 18/90-18/99 */,
	128 + 5	/* 18/100-18/109 */,
	128 + 6	/* 18/110-18/119 */,
	128 + 7	/* 18/120-18/129 */,
	128 + 8	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5	/* 3 */,
	6	/* 4 */,
	7	/* 5 */,
	8	/* 6 */,
	9	/* 7 */,
	10	/* 8 */,
	11	/* 9 */,
	12	/* 10 */,
	13	/* 11 */,
	14	/* 12 */,
	15	/* 13 */,
	16	/* 14 */,
	17	/* 15 */,
	18	/* 16 */,
	19	/* 17 */,
	20	/* 18/00-18/09 */,
	22	/* 18/10-18/19 */,
	24	/* 18/20-18/29 */,
	26	/* 18/30-18/39 */,
	28	/* 18/40-18/49 */,
	30	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	30	/* 18/70-18/79 */,
	30	/* 18/80-18/89 */,
	30	/* 18/90-18/99 */,
	30	/* 18/100-18/109 */,
	30	/* 18/110-18/119 */,
	30	/* 18/120-18/129 */,
	30	/* 18/130-18/139 */,
	30	/* 18/140-18/149 */,
	30	/* 18/150-18/159 */,
	30	/* 18/160-18/169 */,
	30	/* 18/170-18/179 */,
	30	/* 18/180-18/189 */,
	30	/* 18/190-18/199 */,
	30	/* 18/200-18/209 */,
	30	/* 18/210-18/219 */,
	30	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4	/* 3 */,
	5	/* 4 */,
	6	/* 5 */,
	7	/* 6 */,
	8	/* 7 */,
	10	/* 8 */,
	12	/* 9 */,
	14	/* 10 */,
	16	/* 11 */,
	18	/* 12 */,
	20	/* 13 */,
	22	/* 14 */,
	24	/* 15 */,
	26	/* 16 */,
	28	/* 17 */,
	30	/* 18/00-18/09 */,
	30	/* 18/10-18/19 */,
	35	/* 18/20-18/29 */,
	40	/* 18/30-18/39 */,
	45	/* 18/40-18/49 */,
	50	/* 18/50-18/59 */,
	55	/* 18/60-18/69 */,
	60	/* 18/70-18/79 */,
	65	/* 18/80-18/89 */,
	70	/* 18/90-18/99 */,
	80	/* 18/100-18/109 */,
	80	/* 18/110-18/119 */,
	80	/* 18/120-18/129 */,
	80	/* 18/130-18/139 */,
	80	/* 18/140-18/149 */,
	90	/* 18/150-18/159 */,
	90	/* 18/160-18/169 */,
	90	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	90	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0	/* 3 */,
	0	/* 4 */,
	1	/* 5 */,
	2	/* 6 */,
	3	/* 7 */,
	4	/* 8 */,
	4	/* 9 */,
	5	/* 10 */,
	5	/* 11 */,
	6	/* 12 */,
	6	/* 13 */,
	7	/* 14 */,
	7	/* 15 */,
	8	/* 16 */,
	8	/* 17 */,
	9	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	12	/* 18/20-18/29 */,
	15	/* 18/30-18/39 */,
	20	/* 18/40-18/49 */,
	25	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	35	/* 18/70-18/79 */,
	40	/* 18/80-18/89 */,
	45	/* 18/90-18/99 */,
	50	/* 18/100-18/109 */,
	55	/* 18/110-18/119 */,
	60	/* 18/120-18/129 */,
	65	/* 18/130-18/139 */,
	70	/* 18/140-18/149 */,
	75	/* 18/150-18/159 */,
	80	/* 18/160-18/169 */,
	85	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	95	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3	/* 3 */,
	4	/* 4 */,
	5	/* 5 */,
	6	/* 6 */,
	7	/* 7 */,
	8	/* 8 */,
	9	/* 9 */,
	10	/* 10 */,
	11	/* 11 */,
	12	/* 12 */,
	13	/* 13 */,
	14	/* 14 */,
	15	/* 15 */,
	16	/* 16 */,
	17	/* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	1	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	5	/* 18/90-18/99 */,
	6	/* 18/100-18/109 */,
	7	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	9	/* 18/130-18/139 */,
	10	/* 18/140-18/149 */,
	11	/* 18/150-18/159 */,
	12	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	20	/* 18/200-18/209 */,
	20	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0	/* 3 */,
	1	/* 4 */,
	2	/* 5 */,
	3	/* 6 */,
	4	/* 7 */,
	5	/* 8 */,
	5	/* 9 */,
	6	/* 10 */,
	6	/* 11 */,
	7	/* 12 */,
	7	/* 13 */,
	8	/* 14 */,
	8	/* 15 */,
	9	/* 16 */,
	9	/* 17 */,
	10	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	15	/* 18/20-18/29 */,
	15	/* 18/30-18/39 */,
	20	/* 18/40-18/49 */,
	25	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	35	/* 18/70-18/79 */,
	40	/* 18/80-18/89 */,
	45	/* 18/90-18/99 */,
	50	/* 18/100-18/109 */,
	60	/* 18/110-18/119 */,
	70	/* 18/120-18/129 */,
	80	/* 18/130-18/139 */,
	90	/* 18/140-18/149 */,
	100	/* 18/150-18/159 */,
	100	/* 18/160-18/169 */,
	100	/* 18/170-18/179 */,
	100	/* 18/180-18/189 */,
	100	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	0	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	6	/* 18/130-18/139 */,
	6	/* 18/140-18/149 */,
	7	/* 18/150-18/159 */,
	7	/* 18/160-18/169 */,
	8	/* 18/170-18/179 */,
	8	/* 18/180-18/189 */,
	8	/* 18/190-18/199 */,
	9	/* 18/200-18/209 */,
	9	/* 18/210-18/219 */,
	9	/* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128)
 */
byte adj_con_mhp[] =
{
	128 + -5	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 6	/* 18/60-18/69 */,
	128 + 7	/* 18/70-18/79 */,
	128 + 8	/* 18/80-18/89 */,
	128 + 9	/* 18/90-18/99 */,
	128 + 10	/* 18/100-18/109 */,
	128 + 11	/* 18/110-18/119 */,
	128 + 12	/* 18/120-18/129 */,
	128 + 13	/* 18/130-18/139 */,
	128 + 14	/* 18/140-18/149 */,
	128 + 15	/* 18/150-18/159 */,
	128 + 16	/* 18/160-18/169 */,
	128 + 18	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 22	/* 18/190-18/199 */,
	128 + 25	/* 18/200-18/209 */,
	128 + 25	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 * This has been modified by GJW and -KMW- to balance spellcasters in melee combat
 *
 *    Warrior --> num = 6; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 3; div = 2* MAX(35, weapon_weight);
 *    Priest  --> num = 5; mul = 3; div = MAX(40, weapon_weight);
 *    Rogue   --> num = 5; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Paladin --> num = 5; mul = 4; div = MAX(35, weapon_weight);
*	Illusionist --> num = 4; mul = 3; div = 2 * MAX(35, weapon_weight); -KMW-
*	Druid 	--> num = 5; mul = 3; div = MAX(40, weapon_weight); -KMW-
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/* 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

	/* 0  */
	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2 },

	/* 1  */
	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   3,   3,   3 },

	/* 2  */
	{  1,   1,   2,   2,   3,   3,   4,   4,   4,   4,   4,   4 },

	/* 3  */
	{  1,   2,   2,   3,   3,   4,   4,   4,   4,   5,   5,   5 },

	/* 4  */
	{  1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },

	/* 5  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 6  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 7  */
	{  2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 8  */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },

	/* 9  */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6 },

	/* 10 */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6 },

	/* 11+ */
	{  3,   3,   4,   4,   4,   4,   5,   5,   6,   6,   6,   6 },
};


#if 0

/*
 * This is the "old" table used to calculate multiple blows.
 *
 * Note that this table used a different indexing scheme to determine "P"
 */

byte old_blows_table[11][12] =
{
	/* P/D */
	/* 3,  10, /01, /50, /90,/100,/101,/110,/120,/130,/140,/150 */

	/* 0+ */
	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3},

	/* 2+ */
	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   3,   3,   4},

	/* 3+ */
	{  1,   1,   1,   2,   2,   3,   4,   4,   4,   4,   4,   5},

	/* 4+ */
	{  1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5},

	/* 6+ */
	{  1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5},

	/* 8+ */
	{  1,   2,   2,   3,   4,   4,   4,   5,   5,   5,   5,   5},

	/* 10+ */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6},

	/* 13+ */
	{  2,   3,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6},

	/* 15+ */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6},

	/* 18+ */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6},

	/* 20+ */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6}
};

#endif


s16b arena_monsters[MAX_ARENA_MONS] = {   /* -KMW- */
	25,	35,	82,	96,	98,	120,	168,
	174,	178,	184,	190,	195,	199,	206,
	209,	214,	226,	230,	247,	261,	278,
	287,	309,	334,	335,	348,	420,	421,
	441
};


/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store */
		{ "Bilbo the Friendly",		200,	170, 108,  5, 15, RACE_HOBBIT},
		{ "Rincewind the Chicken",	200,	175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",		300,	170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",		300,	165, 107,  6, 18, RACE_ELF},
	},
	{
		/* Armoury */
		{ "Kon-Dar the Ugly",		5000,	210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",		10000,	190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",	25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Mauglin the Grumpy",		30000,	200, 112,  4,  5, RACE_DWARF},
	},
	{
		/* Weapon Smith */
		{ "Ithyl-Mak the Beastly",	5000,	210, 115,  6,  6, RACE_HALF_TROLL},
		{ "Arndal Beast-Slayer",	10000,	185, 110,  5,  9, RACE_HALF_ELF},
		{ "Tarl Beast-Master",		25000,	190, 115,  5,  7, RACE_HOBBIT},
		{ "Oglign Dragon-Slayer",	30000,	195, 112,  4,  8, RACE_DWARF},
	},
	{
		/* Temple */
		{ "Ludwig the Humble",		5000,	175, 109,  6, 15, RACE_HUMAN},
		{ "Gunnar the Paladin",		10000,	185, 110,  5, 23, RACE_HUMAN},
		{ "Delilah the Pure",		25000,	180, 107,  6, 20, RACE_ELF},
		{ "Bosk the Wise",			30000,	185, 109,  5, 15, RACE_DWARF},
	},
	{
		/* Alchemist */
		{ "Mauser the Chemist",		10000,	190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",		10000,	190, 110,  6,  8, RACE_HOBBIT},
		{ "Ga-nat the Greedy",		15000,	200, 116,  6,  9, RACE_GNOME},
		{ "Sasha the Slender",		15000,	220, 111,  4,  9, RACE_ELF},
	},
	{
		/* Magic Shop */
		{ "Ariel the Sorceress",	20000,	200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",		20000,	215, 113,  6, 10, RACE_GNOME},
		{ "Inglorian the Mage",		30000,	200, 110,  7, 10, RACE_HUMAN},
		{ "Luthien Starshine",		30000,	175, 110,  5, 11, RACE_HIGH_ELF},
	},
	{
		/* Black Market */
		{ "Lo-Hak the Awful",		20000,	250, 150, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",		20000,	250, 150, 10,  5, RACE_HALF_ORC},
		{ "Durwin the Blue",		25000,	250, 150, 10,  5, RACE_KOBOLD},
		{ "Drago the Fair",			30000,	250, 150, 10,  5, RACE_ELF},
	},
	{
		/* Home */
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99}
	}
};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};







/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10200,
	12500,
	17500,
	25000,
	35000L,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,
	5000000L
};


/*
 * Player Sexes
 *
 *	Title,
 *	Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
		"Female",
		"Queen"
	},

	{
		"Male",
		"King"
	}
};


/*
 * Player Races
 *
 *	Title,
 *	{STR,INT,WIS,DEX,CON,CHR},
 *	r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *	hitdie, exp base,
 *	Age (Base, Mod),
 *	Male (Hgt, Wgt),
 *	Female (Hgt, Wgt)
 *	infra,
 *	class-choices (Modified to include illusionist & druid -KMW-)
 */
player_race race_info[MAX_RACES] =
{
	{
		"Human",
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		0xFF
	},

	{
		"Half-Elf",
		{ -1,  1,  0,  1, -1,  1 },
		2,  3,  3,  1, 6,  11, -1,  5,
		9,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		0xFF
	},

	{
		"Elf",
		{ -1,  2,  1,  1, -2,  1 },
		5,  6,  6,  1, 8,  12, -5, 15,
		8,  120,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		0xBF
	},

	{
		"Hobbit",
		{ -2,  2,  1,  3,  2,  1 },
		15, 18, 18, 4, 12,  15, -10, 20,
		7,  110,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		0x8B
	},

	{
		"Gnome",
		{ -1,  2,  0,  2,  1, -2 },
		10, 12, 12,  3, 6,  13, -8, 12,
		8,  125,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		0x8F
	},

	{
		"Dwarf",
		{  2, -3,  2, -2,  2, -3 },
		2,  9,  9,  -1,  7,  10, 15,  0,
		11,  120,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		0x05
	},

	{
		"Half-Orc",
		{  2, -1,  0,  0,  1, -4 },
		-3, -3, -3,  -1,  0, 7, 12, -5,
		10,  110,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		0x0D
	},

	{
		"Half-Troll",
		{ 4, -4, -2, -4,  3, -6 },
		-5, -8, -8, -2,  -1, 5, 20, -10,
		12,  120,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		0x05
	},

	{
		"Dunadan",
		{  1,  2,  2,  2,  3,  2 },
		4,  5,  5,  2, 3, 13, 15, 10,
		10,  180,
		50, 20,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0x3F
	},

	{
		"High-Elf",
		{  1,  3, -1,  3,  1,  5 },
		4,  20, 20,  3,  3, 14, 10, 25,
		10,  200,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		0x1F
	},

	{ /* Added by GJW -KMW- */
		"Kobold",
		{ -2, -1, 0, +2, +2, -1 },
		10, 5, 10, 4, 15, 15, -5, 15,
		9, 115,
		15, 10,
		38, 4, 70, 5,
		36, 3, 60, 4,
		5,
		0x0D
	}
};


/*
 * Player Classes
 *
 *	Title,
 *	{STR,INT,WIS,DEX,CON,CHR},
 *	c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *	x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *	HD, Exp
 */
player_class class_info[MAX_CLASS] =
{
	{
		"Warrior",
		{ 5, -2, -2, 2, 2, -1},
		25, 18, 18, 1,  14, 2, 70, 55,
		10, 7,  10, 0,  0,  0,  45, 45,
		9,  0
	},

	{
		"Mage",
		{-5, 3, 0, 1, -2, 1},
		30, 36, 30, 2,  16, 20, 34, 20,
		7,  13, 9,  0,  0,  0,  15, 15,
		0, 30
	},

	{
		"Priest",
		{-1, -3, 3, -1, 0, 2},
		25, 30, 32, 2,  16, 8, 48, 35,
		7,  10, 12, 0,  0,  0, 20, 20,
		2, 20
	},

	{
		"Rogue",
		{ 2, 1, -2, 3, 1, -1},
		45, 32, 28, 5, 32, 24, 60, 66,
		15, 10, 10, 0,  0,  0, 40, 30,
		6, 25
	},

	{
		"Ranger",
		{ 2, 2, 0, 1, 1, 1},
		30, 32, 28, 3,  24, 16, 56, 72,
		8,  10, 10, 0,  0,  0,  30, 45,
		4, 30
	},

	{
		"Paladin",
		{ 3, -3, 1, 0, 2, 2},
		20, 24, 25, 1,  12, 2, 68, 40,
		7,  10, 11, 0,  0,  0,  35, 30,
		6, 35
	},

	{ /* Added -KMW- */
		"Illusionist",
		{-5, 3, 0, 1, -2, 1},
		30, 36, 30, 2,  16, 20, 34, 20,
		7,  13, 9,  0,  0,  0,  15, 15,
		0, 30
	},

	{
		"Druid",
		{-1, -3, 3, -1, 0, 2},
		25, 30, 32, 2,  16, 8, 48, 35,
		7,  10, 12, 0,  0,  0, 20, 20,
		2, 20
	}
};






/*
 * Hack -- the spell information table.
 *
 *   Class Name
 *
 *   Spell Book
 *   Spell Xtra
 *
 *   Spell Stat,
 *   Spell Type,
 *
 *   Spell Level,
 *   Spell Encumbrance,
 *
 *   Array of { Lev, Mana, Fail, Exp/Lev }
 */
player_magic magic_info[MAX_CLASS] =
{
	{
		/*** Warrior ***/

		0,
		0,

		A_STR,
		0,

		99,
		0,

		{
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Mage ***/

		TV_MAGIC_BOOK,
		0,

		A_INT,
		0,

		1,
		300,

		{
			{  1,  1, 22,   4},
			{  1,  1, 23,   4},
			{  1,  2, 24,   4},
			{  1,  2, 26,   4},
			{  1,  2, 25,   3},
			{  3,  3, 25,   3},
			{  3,  3, 26,   3},
			{  3,  3, 25,   1},
			{  3,  3, 27,   3},

			{  3,  4, 30,   1},
			{  5,  4, 30,   4},
			{  5,  5, 30,   6},
			{  5,  5, 30,   4},
			{  5,  5, 35,   4},
			{  7,  6, 35,   5},
			{  7,  6, 30,   5},
			{  7,  6, 40,   6},
			{  9,  7, 44,   8},

			{  9,  7, 45,   8},
			{  9,  7, 75,   9},
			{  9,  7, 45,   8},
			{ 11,  7, 45,   9},
			{ 11,  7, 75,   6},
			{ 13,  7, 50,   6},
			{ 15,  9, 50,   6},
			{ 17,  9, 50,   7},

			{ 19, 12, 55,   8},
			{ 21, 12, 90,   8},
			{ 23, 12, 60,   8},
			{ 25, 12, 65,  10},
			{ 29, 18, 65,  12},
			{ 33, 21, 80,  15},
			{ 37, 25, 95,  21},

			{  7,  7, 20,  28},
			{  9, 12, 40,  44},
			{ 15, 17, 60,  29},
			{ 20, 18, 60,  24},
			{ 25, 25, 75,  19},
			{ 45, 50, 60,  30},

			{ 10,  6, 50,  12},
			{ 12,  9, 60,  16},
			{ 20, 15, 70,  20},
			{ 27, 25, 75,  29},
			{ 35, 35, 85,  34},
			{ 40, 40, 80,  50},
			{ 42, 45, 95, 200},

			{ 5,  5,  50,   8},
			{ 10, 10, 70,  40},
			{ 15, 20, 80,  50},
			{ 25, 30, 95, 160},
			{ 30, 50, 70,  40},
			{ 40, 75, 80, 100},

			{  4,  5, 50,  20},
			{  4,  5, 50,  20},
			{  4,  5, 50,  20},
			{  8, 10, 75,  40},
			{ 15, 15, 90,  45},
			{ 15, 20, 85,  60},

			{  5,  5, 50,  80},
			{ 10, 12, 75, 120},
			{ 15, 20, 80, 200},
			{ 20, 30, 50,  75},
			{ 22, 30, 50, 250},	/* 350 */
			{ 45, 70, 75, 250}	/* 450 */
		}
	},

	{
		/*** Priest ***/

		TV_PRAYER_BOOK,
		0,

		A_WIS,
		1,

		1,
		350,

		{
			{  1,  1, 10,   4},
			{  1,  2, 15,   4},
			{  1,  2, 20,   4},
			{  1,  2, 25,   4},
			{  3,  2, 25,   1},
			{  3,  3, 27,   2},
			{  3,  3, 27,   2},
			{  3,  3, 28,   4},

			{  5,  4, 29,   3},
			{  5,  4, 30,   4},
			{  5,  4, 32,   4},
			{  5,  5, 34,   4},
			{  7,  5, 36,   3},
			{  7,  5, 38,   4},
			{  7,  6, 38,   5},
			{  7,  7, 38,   5},

			{  9,  6, 38,   4},
			{  9,  7, 38,   4},
			{  9,  7, 40,   4},
			{ 11,  8, 42,   4},
			{ 11,  8, 42,   4},
			{ 11,  9, 55,   5},
			{ 13, 10, 45,   4},
			{ 13, 11, 45,   4},
			{ 15, 12, 50,   5},

			{ 15, 14, 50,   5},
			{ 17, 14, 55,   7},
			{ 21, 16, 60,   7},
			{ 25, 20, 70,  12},
			{ 33, 55, 90,  15},
			{ 39, 32, 95,  20},
			{ 40, 60, 90, 100},

			{  3,  3, 50,   2},
			{ 10, 10, 80,  20},
			{ 20, 20, 80,  20},
			{ 25, 10, 80, 150},
			{ 35, 50, 80, 230},
			{ 40, 80, 80, 200},

			{ 15,  5, 50,  25},
			{ 17,  7, 60,  45},
			{ 30, 50, 80, 130},
			{ 35, 70, 90, 230},
			{ 35, 70, 90, 250},	/* 350 */
			{ 40, 80, 80, 200},

			{ 15,  7, 70,  25},
			{ 20, 10, 75,  60},
			{ 25, 25, 80, 250},
			{ 35, 35, 80, 115},
			{ 45, 60, 75, 250},	/* 350 */
			{ 45, 90, 90, 250},

			{  5,  6, 50,  40},
			{ 15, 20, 80,  25},
			{ 25, 40, 80, 160},
			{ 35, 50, 80, 230},
			{ 37, 60, 85, 250},	/* 325 */
			{ 45, 95, 85, 250},	/* 530 */
			{ 45, 95, 90, 250},

			{  3,  3, 50,   6},
			{ 10, 10, 50,   8},
			{ 20, 20, 80,  16},
			{ 30, 40, 75, 133},
			{ 35, 50, 75,  11},
			{ 40, 60, 75, 250},	/* 300 */
			{ 45, 90, 90, 250}
		}
	},

	{
		/*** Rogue ***/

		TV_ILLUSION_BOOK,
		0,

		A_INT,
		2,

		5,
		350,

		{
			{ 99,  0,  0,   0},
			{  5,  1, 50,   1},
			{  7,  2, 55,   1},
			{  9,  3, 60,   1},
			{ 10,  3, 60,   1},
			{ 11,  4, 65,   1},
			{ 12,  4, 65,   1},
			{ 13,  5, 70,   1},
			{ 99,  0,  0,   0},

			{ 15,  6, 75,   1},
			{ 17,  7, 80,   1},
			{ 19,  8, 85,   1},
			{ 99,  0,  0,   0},
			{ 21,  9, 90,   1},
			{ 22,  9, 95,   1},
			{ 23, 10, 60,   1},
			{ 99,  0,  0,   0},
			{ 24, 11, 70,   1},

			{ 25, 12, 95,   1},
			{ 27, 15, 99,   1},
			{ 35, 40, 95,   1},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 40, 60, 90,   1},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 30, 20, 99,   6},
			{ 99,  0,  0,   0},
			{ 32, 25, 70,   6},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{  7,  7, 20,  25},
			{  9, 12, 40,  45},
			{ 99,  0,  0,   0},
			{ 15, 17, 60,  30},
			{ 30, 35, 75,  15},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{  5,  5, 50,  10},
			{ 10, 10, 70,  40},
			{ 35, 40, 95, 100},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 45, 90, 90, 100},

			{ 10, 12, 50,  40},
			{ 10, 12, 50,  40},
			{ 10, 12, 50,  40},
			{ 15, 20, 75,  60},
			{ 25, 30, 85,  80},
			{ 99,  0,  0,   0},

			{ 10, 11, 50,  40},
			{ 99, 0,   0,   0},
			{ 20, 25, 80, 160},
			{ 26, 30, 50, 250},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Ranger ***/

		TV_MAGIC_BOOK,
		0,

		A_INT,
		0,

		3,
		400,

		{
			{  3,  1, 30,   1},
			{  3,  2, 35,   2},
			{  3,  2, 35,   2},
			{  5,  3, 35,   1},
			{ 99,  0,  0,   0},
			{  5,  3, 40,   1},
			{ 99,  0,  0,   0},
			{  5,  4, 45,   2},
			{  7,  5, 40,   3},

			{  7,  6, 40,   2},
			{  9,  7, 40,   3},
			{  9,  8, 45,   3},
			{ 11,  8, 40,   3},
			{ 11,  9, 45,   3},
			{ 13, 10, 45,   3},
			{ 13, 11, 55,   4},
			{ 15, 12, 50,   4},
			{ 15, 13, 50,   4},

			{ 17, 17, 55,   3},
			{ 17, 17, 90,   4},
			{ 99,  0,  0,   0},
			{ 21, 19, 60,   3},
			{ 23, 25, 90,   3},
			{ 99,  0,  0,   0},
			{ 25, 20, 60,   3},
			{ 25, 21, 65,   3},

			{ 27, 21, 65,   3},
			{ 99,  0,  0,   0},
			{ 31, 25, 70,   3},
			{ 33, 25, 75,   4},
			{ 35, 25, 80,   5},
			{ 37, 30, 95,  10},
			{ 99,  0,  0,   0},

			{ 8,  17, 20,  25},
			{ 19, 22, 40,  21},
			{ 25, 27, 60,  17},
			{ 30, 28, 60,  16},
			{ 35, 35, 75,  13},
			{ 99,  0, 0,    0},

			{ 20, 16, 50,   6},
			{ 22, 19, 60,   9},
			{ 30, 25, 70,  13},
			{ 33, 35, 75,  25},
			{ 35, 45, 85,  35},
			{ 99,  0, 0,    0},
			{ 99,  0, 0,    0},

			{ 10, 15, 50,   4},
			{ 15, 20, 70,  25},
			{ 35, 60, 95, 115},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 8,  15, 50,  30},
			{ 8,  15, 50,  30},
			{ 8,  15, 50,  30},
			{ 16, 25, 75,  50},
			{ 25, 40, 85,  70},
			{ 99,  0,  0,   0},

			{ 10, 15, 50,  40},
			{ 15, 20, 75,  80},
			{ 25, 30, 80, 125},
			{ 32, 50, 50, 250},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Paladin ***/

		TV_PRAYER_BOOK,
		0,

		A_WIS,
		1,

		1,
		400,

		{
			{  1,  1, 30,   4},
			{  2,  2, 35,   4},
			{  3,  3, 35,   4},
			{  5,  3, 35,   4},
			{  5,  4, 35,   4},
			{  7,  5, 40,   3},
			{  7,  5, 40,   3},
			{  9,  7, 40,   3},

			{  9,  7, 40,   3},
			{  9,  8, 40,   3},
			{ 99,  0,  0,   0},
			{ 11, 10, 45,   3},
			{ 11, 10, 45,   3},
			{ 13, 10, 45,   3},
			{ 13, 11, 45,   4},
			{ 15, 13, 45,   4},

			{ 15, 15, 50,   4},
			{ 17, 15, 50,   4},
			{ 17, 15, 50,   4},
			{ 19, 15, 50,   4},
			{ 19, 15, 50,   4},
			{ 21, 17, 50,   3},
			{ 23, 17, 50,   3},
			{ 25, 20, 50,   3},
			{ 27, 21, 50,   3},

			{ 29, 22, 50,   3},
			{ 31, 24, 60,   3},
			{ 33, 28, 60,   3},
			{ 35, 32, 70,   4},
			{ 37, 70, 90,   5},
			{ 39, 38, 95,  10},
			{ 99,  0,  0,   0},

			{ 5,  5,  50,   1},
			{ 15, 15, 80,  12},
			{ 25, 25, 80,  16},
			{ 30, 15, 80, 135},
			{ 37, 55, 80, 215},
			{ 99,  0,  0,   0},

			{ 17, 15, 50,  25},
			{ 23, 25, 60,  35},
			{ 35, 60, 80, 115},
			{ 40, 80, 90, 200},
			{ 40, 80, 90, 250},	/* 300 */
			{ 99,  0,  0,   0},

			{ 20, 13, 70,  20},
			{ 30, 20, 75,  40},
			{ 30, 35, 80, 200},
			{ 40, 40, 80, 100},
			{ 47, 70, 75, 250},	/* 350 */
			{ 99,  0,  0,   0},

			{ 10, 16, 50,  20},
			{ 25, 30, 80,  15},
			{ 30, 50, 80, 130},
			{ 40, 70, 80, 200},
			{ 42, 80, 85, 250},	/* 285 */
			{ 47, 95, 85, 250},	/* 500 */
			{ 99,  0,  0,   0},

			{  7,  7, 50,   2},
			{ 20, 20, 50,   4},
			{ 25, 25, 80,  12},
			{ 35, 50, 75, 115},
			{ 40, 60, 75,  10},
			{ 45, 70, 75, 250},
			{ 99,  0,  0,   0}
		}
	},

	{	/* Added this class -KMW- */
		/*** Illusionist ***/

		TV_ILLUSION_BOOK,
		0,

		A_INT,
		2,

		1,
		300,

		{
			{  1,  1, 22,   4},
			{  1,  1, 23,   4},
			{  1,  2, 24,   4},
			{  1,  2, 26,   4},
			{  1,  2, 25,   3},
			{  3,  3, 25,   3},
			{  3,  3, 26,   3},
			{  3,  3, 25,   1},
			{  3,  3, 27,   3},

			{  3,  4, 30,   1},
			{  5,  4, 30,   4},
			{  5,  5, 30,   6},
			{  5,  5, 30,   4},
			{  5,  5, 35,   4},
			{  7,  6, 35,   5},
			{  7,  6, 30,   5},
			{  7,  6, 40,   6},
			{  9,  7, 44,   8},

			{  9,  7, 45,   8},
			{  9,  7, 75,   9},
			{  9,  7, 45,   8},
			{ 11,  7, 45,   9},
			{ 11,  7, 75,   6},
			{ 13,  7, 50,   6},
			{ 15,  9, 50,   6},
			{ 17,  9, 50,   7},

			{ 19, 12, 55,   8},
			{ 21, 12, 90,   8},
			{ 23, 12, 60,   8},
			{ 25, 12, 65,  10},
			{ 29, 18, 65,  12},
			{ 33, 21, 80,  15},
			{ 37, 25, 95,  21},

			{  7,  7, 20,  28},
			{  9, 12, 40,  44},
			{ 15, 17, 60,  29},
			{ 20, 18, 60,  24},
			{ 25, 25, 75,  19},
			{ 45, 50, 60,  30},

			{ 10,  6, 50,  12},
			{ 12,  9, 60,  16},
			{ 20, 15, 70,  20},
			{ 27, 25, 75,  29},
			{ 35, 35, 85,  34},
			{ 40, 40, 80,  50},
			{ 42, 45, 95, 200},

			{ 5,  5,  50,   8},
			{ 10, 10, 70,  40},
			{ 15, 20, 80,  50},
			{ 25, 30, 95, 160},
			{ 30, 50, 70,  40},
			{ 40, 75, 80, 100},

			{  4,  5, 50,  20},
			{  4,  5, 50,  20},
			{  4,  5, 50,  20},
			{  8, 10, 75,  40},
			{ 15, 15, 90,  45},
			{ 15, 20, 85,  60},

			{  5,  5, 50,  80},
			{ 10, 12, 75, 120},
			{ 15, 20, 80, 200},
			{ 20, 30, 50,  75},
			{ 22, 30, 50, 250},	/* 350 */
			{ 45, 70, 75, 250}	/* 450 */
		}
	},

	{
		/*** Druid ***/

		TV_NATURE_BOOK,
		0,

		A_WIS,
		3,

		1,
		350,

		{
			{  1,  1, 10,   4},
			{  1,  2, 15,   4},
			{  1,  2, 20,   4},
			{  1,  2, 25,   4},
			{  3,  2, 25,   1},
			{  3,  3, 27,   2},
			{  3,  3, 27,   2},
			{  3,  3, 28,   4},

			{  5,  4, 29,   3},
			{  5,  4, 30,   4},
			{  5,  4, 32,   4},
			{  5,  5, 34,   4},
			{  7,  5, 36,   3},
			{  7,  5, 38,   4},
			{  7,  6, 38,   5},
			{  7,  7, 38,   5},

			{  9,  6, 38,   4},
			{  9,  7, 38,   4},
			{  9,  7, 40,   4},
			{ 11,  8, 42,   4},
			{ 11,  8, 42,   4},
			{ 11,  9, 55,   5},
			{ 13, 10, 45,   4},
			{ 13, 11, 45,   4},
			{ 15, 12, 50,   5},

			{ 15, 14, 50,   5},
			{ 17, 14, 55,   7},
			{ 21, 16, 60,   7},
			{ 25, 20, 70,  12},
			{ 33, 55, 90,  15},
			{ 39, 32, 95,  20},
			{ 40, 60, 90, 100},

			{  3,  3, 50,   2},
			{ 10, 10, 80,  20},
			{ 20, 20, 80,  20},
			{ 25, 10, 80, 150},
			{ 35, 50, 80, 230},
			{ 40, 80, 80, 200},

			{ 15,  5, 50,  25},
			{ 17,  7, 60,  45},
			{ 30, 50, 80, 130},
			{ 35, 70, 90, 230},
			{ 35, 70, 90, 250},	/* 350 */
			{ 40, 80, 80, 200},

			{ 15,  7, 70,  25},
			{ 20, 10, 75,  60},
			{ 25, 25, 80, 250},
			{ 35, 35, 80, 115},
			{ 45, 60, 75, 250},	/* 350 */
			{ 45, 90, 90, 250},

			{  5,  6, 50,  40},
			{ 15, 20, 80,  25},
			{ 25, 40, 80, 160},
			{ 35, 50, 80, 230},
			{ 37, 60, 85, 250},	/* 325 */
			{ 45, 95, 85, 250},	/* 530 */
			{ 45, 95, 90, 250},

			{  3,  3, 50,   6},
			{ 10, 10, 50,   8},
			{ 20, 20, 80,  16},
			{ 30, 40, 75, 133},
			{ 35, 50, 75,  11},
			{ 40, 60, 75, 250},	/* 300 */
			{ 45, 90, 90, 250}
		}
	}
};


/*
* Spells in each book (mage spells then priest spells
 * followed by illusionist and druid spells -KMW-)
 */
u32b spell_flags[4][9][2] =
{
	{
		/*** Mage spell books ***/
		{ 0x000001ff, 0x00000000 },
		{ 0x0003fe00, 0x00000000 },
		{ 0x03fc0000, 0x00000000 },
		{ 0xfc000000, 0x00000001 },
		{ 0x00000000, 0x03f00000 },
		{ 0x00000000, 0x0000007e },
		{ 0x00000000, 0x000fc000 },
		{ 0x00000000, 0xfc000000 },
		{ 0x00000000, 0x00003f80 }
	},

	{
		/*** Priest spell books ***/
		{ 0x000000ff, 0x00000000 },
		{ 0x0000ff00, 0x00000000 },
		{ 0x01ff0000, 0x00000000 },
		{ 0xfe000000, 0x00000000 },
		{ 0x00000000, 0xfe000000 },
		{ 0x00000000, 0x0000003f },
		{ 0x00000000, 0x00000fc0 },
		{ 0x00000000, 0x01fc0000 },
		{ 0x00000000, 0x0003f000 }
	},

	{	/* Added these books -KMW- */
		/*** Illusionist spell books ***/
		{ 0x000001ff, 0x00000000 },
		{ 0x0003fe00, 0x00000000 },
		{ 0x03fc0000, 0x00000000 },
		{ 0xfc000000, 0x00000001 },
		{ 0x00000000, 0x03f00000 },
		{ 0x00000000, 0x0000007e },
		{ 0x00000000, 0x000fc000 },
		{ 0x00000000, 0xfc000000 },
		{ 0x00000000, 0x00003f80 }
	},

	{	/* Added these books -KMW- */
		/*** Druid spell books ***/
		{ 0x000000ff, 0x00000000 },
		{ 0x0000ff00, 0x00000000 },
		{ 0x01ff0000, 0x00000000 },
		{ 0xfe000000, 0x00000000 },
		{ 0x00000000, 0xfe000000 },
		{ 0x00000000, 0x0000003f },
		{ 0x00000000, 0x00000fc0 },
		{ 0x00000000, 0x01fc0000 },
		{ 0x00000000, 0x0003f000 }
	}
};


/*
* Names of the spells (mage spells then priest spells
 * followed by illusionist & druid spells -KMW-)
 */
cptr spell_names[4][64] =
{
	/*** Mage Spells ***/

	{
		/* Magic for Beginners (sval 0) */
		"Magic Missile",
		"Detect Monsters",
		"Phase Door",
		"Light Area",
		"Treasure Detection",
		"Cure Wounds",
		"Object Detection",
		"Find Hidden Traps/Doors",
		"Stinking Cloud",

		/* Conjurings and Tricks (sval 1) */
		"Confuse Monster",
		"Lightning Bolt",
		"Trap/Door Destruction",
		"Sleep",
		"Cure Poison",
		"Teleport Self",
		"Spear of Light",
		"Frost Bolt",
		"Turn Stone to Mud",

		/* Incantations and Illusions (sval 2) */
		"Satisfy Hunger",
		"Recharge Item",
		"Fetch Item",
		"Polymorph Other",
		"Identify",
		"Lower Water",
		"Fire Bolt",
		"Slow Monster",

		/* Sorcery and Evocations (sval 3) */
		"Frost Ball",
		"Summon Elemental",
		"Teleport Other",
		"Haste Self",
		"Fire Ball",
		"Word of Destruction",
		"Genocide",

		/* Mordenkainen's Escapes (sval 5) */
		"Door Creation",
		"Stair Creation",
		"Teleport Level",
		"Earthquake",
		"Word of Recall",
		"Dimension Door",

		/* Raal's Tome of Destruction (sval 8) */
		"Acid Bolt",
		"Cloud Kill",
		"Acid Ball",
		"Ice Storm",
		"Meteor Swarm",
		"Plasma Bolt",
		"Mana Storm",

		/* Kelek's Grimoire of Power (sval 6) */
		"Wizard Light",
		"Detect Enchantment",
		"Time/Space Anchor",
		"Genocide",
		"Mass Genocide",
		"Probing",

		/* Resistance of Scarabtarices (sval 4) */
		"Resist Fire",
		"Resist Cold",
		"Resist Acid",
		"Resist Poison",
		"Protect from Corrosion",
		"Resistance",

		/* Tenser's transformations... (sval 7) */
		"Heroism",
		"Shield",
		"Berserker",
		"Life for Mana",
		"Essence of Speed",
		"Globe of Invulnerability"

	},


	/*** Priest Spells ***/

	{
		/* Beginners Handbook (sval 0) */
		"Detect Evil",
		"Cure Wounds",
		"Bless",
		"Remove Fear",
		"Call Light",
		"Find Traps",
		"Detect Doors/Stairs",
		"Slow Poison",

		/* Words of Wisdom (sval 1) */
		"Scare Monster",
		"Portal",
		"Duststorm",
		"Chant",
		"Sanctuary",
		"Satisfy Hunger",
		"Remove Curse",
		"Resist Heat and Cold",

		/* Chants and Blessings (sval 2) */
		"Levitate",
		"Orb of Draining",
		"Disintegrate",
		"Sense Invisible",
		"Protection from Evil",
		"Earthquake",
		"Sense Surroundings",
		"Cure Mortal Wounds",
		"Turn Undead",

		/* Exorcism and Dispelling (sval 3) */
		"Prayer",
		"Dispel Undead",
		"Heal",
		"Dispel Evil",
		"Glyph of Warding",
		"Holy Word",
		"Summon Angel",

		/* Godly Insights... (sval 5) */
		"Detect Monsters",
		"Detection",
		"Perception",
		"Probing",
		"Clairvoyance",
		"Resist Nether",

		/* Purifications and Healing (sval 6) */
		"Cure Wounds",
		"Cure Mortal Wounds",
		"*Healing*",
		"Restoration",
		"Remembrance",
		"Immolation",

		/* Wrath of God (sval 8) */
		"Dispel Undead",
		"Dispel Evil",
		"Banishment",
		"Word of Destruction",
		"Annihilation",
		"Balefire",

		/* Holy Infusions (sval 7) */
		"Unbarring Ways",
		"Recharging",
		"Dispel Curse",
		"Enchant Weapon",
		"Enchant Armour",
		"Elemental Brand",
		"Imprision",

		/* Ethereal openings (sval 4) */
		"Blink",
		"Teleport Self",
		"Teleport Other",
		"Teleport Level",
		"Word of Recall",
		"Alter Reality",
		"Immolation"
	},

	/*** Illusionist Spells ***/
	/* Added by -KMW- */

	{
		/* Illusions for Beginners (sval 0) */
		"Confusion Bolt",
		"Detect Monsters",
		"Phase Door",
		"Light Area",
		"Treasure Detection",
		"Fear",
		"Object Detection",
		"Find Hidden Traps/Doors",
		"Stinking Cloud",

		/* Tricks and Visions (sval 1) */
		"Infravision",
		"Sleep",
		"Trap/Door Destruction",
		"Fog Cloud",
		"Cure Poison",
		"Satisfy Hunger",
		"Shadow Door",
		"Shadow Monster",
		"Turn Stone to Mud",

		/* Phantasms and Illusions (sval 2) */
		"Detect Invisible",
		"Recharge Item",
		"Brand Ammo",
		"Spear of Light",
		"Chaos",
		"Mental Barrier",
		"True Sight",
		"Slow Monster",

		/* Shadows and Prisms (sval 3) */
		"Shadow Ball",
		"Bolt of Darkness",
		"Shadow Form",
		"Haste Self",
		"Prismatic Wall",
		"Prismatic Spray",
		"Chromatic Shield",

		/* Knowledge of Kenault (sval 5) */
		"Wizard Lock",
		"Bedlam",
		"Word of Recall",
		"Detect Enchantment",
		"Probing",
		"Sunfire",

		/* Bigby's Handbook (sval 8) */
		"Bigby's Interposing Hand",
		"Bigby's Phantom Hand",
		"Bigby's Forceful Hand",
		"Bigby's Grasping Hand",
		"Bigby's Clenched Fist",
		"Bigby's Crushing Hand",
		"Force Blast",

		/* Otiluke's Spheres (sval 6) */
		"Sphere of Light",
		"Sphere of Darkness",
		"Sphere of Confusion",
		"Sphere of Chaos",
		"Sphere of Sound",
		"Explosion",

		/* Serten's Immunities (sval 4) */
		"Remove Fear",
		"Resist Light & Dark",
		"Resist Poison",
		"Resist Chaos & Confusion",
		"Resist Sound & Shards",
		"Resist Nexus",

		/* Boccob's Book of Shadows (sval 7) */
		"Invisibility",
		"Shadow Monsters",
		"Shadow Ball",
		"Decoy",
		"Shadow Gate",
		"Summon Shadows"
	},


	/*** Druid Spells ***/

	{
		/* Natures Handbook (sval 0) */
		"Detect Evil",
		"Cure Wounds",
		"Poison Bolt",
		"Remove Fear",
		"Call Light",
		"Find Traps",
		"Detect Doors/Stairs",
		"Slow Poison",

		/* Natural States (sval 1) */
		"Sleep",
		"Portal",
		"Duststorm",
		"Cool Lava",
		"Poison Cloud",
		"Satisfy Hunger",
		"Remove Curse",
		"Resist Heat and Cold",

		/* Wilderness Guide (sval 2) */
		"Levitate",
		"Charm Monster",
		"Disintegrate",
		"Grow Trees",
		"Protection from Evil",
		"Sense Invisible",
		"Sense Surroundings",
		"Lower Water",
		"Turn Animals",

		/* Call of the Wild (sval 3) */
		"Fear",
		"Call Wolves",
		"Heal",
		"Analyze Monster",
		"Glyph of Warding",
		"Detection",
		"Nexus Bolt",

		/* Druidic Insights (sval 5) */
		"Detect Monsters",
		"Map Terrain",
		"Perception",
		"Probing",
		"Clairvoyance",
		"Resist Nether",

		/* Growth & Destruction (sval 6) */
		"Fear",
		"Cure Mortal Wounds",
		"Forest",
		"Restoration",
		"Faithfulness",
		"Firestorm",

		/* Nature's Wrath (sval 8) */
		"Fissure",
		"Tornado",
		"Earthquake",
		"Flood",
		"Nexus Ball",
		"Balefire",

		/* Druidic Alterations (sval 7) */
		"Unbarring Ways",
		"Recharging",
		"Eruption",
		"Sustain Self",
		"Brand Ammo",
		"Elemental Brand",
		"Imprision",

		/* Commune with Nature (sval 4) */
		"Blink",
		"Teleport Self",
		"Teleport Other",
		"Summon Animals",
		"Word of Recall",
		"Alter Reality",
		"Drown",
	}
};



/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] =
{
	0,					/* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),			/* 5 == best small wooden */
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),			/* 15 == best large wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),			/* 25 == best small iron */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),	/* 35 == best large iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),	/* 45 == best small steel */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),	/* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};








/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL/5] =
{
	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Mage */
	{
		"Novice",
		"Apprentice",
		"Evoker",
		"Conjurer",
		"Enchanter",
		"Warlock",
		"Sorcerer",
		"Mage",
		"Wizard",
		"Wizard Lord",
	},

	/* Priest */
	{
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Lama",
		"Patriarch",
		"Priest",
		"High Priest",
		"Priest Lord",
	},

	/* Rogues */
	{
		"Vagabond",
		"Cutpurse",
		"Robber",
		"Burglar",
		"Filcher",
		"Sharper",
		"Low Thief",
		"High Thief",
		"Master Thief",
		"Assassin",
	},

	/* Rangers */
	{
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
	},

	/* Paladins */
	{
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
	},

	/* Illusionist -KMW- */
	{
		"Novice",
		"Apprentice",
		"Trickster",
		"Cabalist",
		"Visionist",
		"Phantasmist",
		"Spellbinder",
		"Illusionist",
		"Shadow",
		"Shadow Lord",
	},

	/* Druid */
	{
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Lama",
		"Patriarch",
		"Druid",
		"High Druid",
		"Druid Lord",
	}
};



/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: "
};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: "
};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 */
cptr window_flag_desc[32] =
{
	"Display inven/equip",
	"Display equip/inven",
	"Display player flags",
	"Display player screen",
	NULL,
	NULL,
	"Display messages",
	"Display overhead view",
	"Display monster recall",
	"Display object recall",
	NULL,
	"Display snap-shot",
	NULL,
	NULL,
	"Display borg messages",
	"Display borg status",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Options -- textual names (where defined)
 */
cptr option_text[OPT_MAX] =
{
	"rogue_like_commands",		/* OPT_rogue_like_commands */
	"quick_messages",			/* OPT_quick_messages */
	"other_query_flag",			/* OPT_other_query_flag */
	"carry_query_flag",			/* OPT_carry_query_flag */
	"use_old_target",			/* OPT_use_old_target */
	"always_pickup",			/* OPT_always_pickup */
	"always_repeat",			/* OPT_always_repeat */
	"depth_in_feet",			/* OPT_depth_in_feet */
	"stack_force_notes",		/* OPT_stack_force_notes */
	"stack_force_costs",		/* OPT_stack_force_costs */
	"show_labels",				/* OPT_show_labels */
	"show_weights",				/* OPT_show_weights */
	"show_choices",				/* OPT_show_choices */
	"show_details",				/* OPT_show_details */
	"ring_bell",				/* OPT_ring_bell */
	"inventory_colors",			/* OPT_inventory_colors */
	"run_ignore_stairs",		/* OPT_run_ignore_stairs */
	"run_ignore_doors",			/* OPT_run_ignore_doors */
	"run_cut_corners",			/* OPT_run_cut_corners */
	"run_use_corners",			/* OPT_run_use_corners */
	"disturb_move",				/* OPT_disturb_move */
	"disturb_near",				/* OPT_disturb_near */
	"disturb_panel",			/* OPT_disturb_panel */
	"disturb_state",			/* OPT_disturb_state */
	"disturb_minor",			/* OPT_disturb_minor */
	"disturb_other",			/* OPT_disturb_other */
	"alert_hitpoint",			/* OPT_alert_hitpoint */
	"alert_failure",			/* OPT_alert_failure */
	NULL,						/* xxx */
	NULL,						/* xxx */
	NULL,						/* xxx */
	NULL,						/* xxx */
	"auto_haggle",				/* OPT_auto_haggle */
	"auto_scum",				/* OPT_auto_scum */
	"testing_stack",			/* OPT_testing_stack */
	"testing_carry",			/* OPT_testing_carry */
	"expand_look",				/* OPT_expand_look */
	"expand_list",				/* OPT_expand_list */
	"view_perma_grids",			/* OPT_view_perma_grids */
	"view_torch_grids",			/* OPT_view_torch_grids */
	"dungeon_align",			/* OPT_dungeon_align */
	"dungeon_stair",			/* OPT_dungeon_stair */
	"flow_by_sound",			/* OPT_flow_by_sound */
	"flow_by_smell",			/* OPT_flow_by_smell */
	"track_follow",				/* OPT_track_follow */
	"track_target",				/* OPT_track_target */
	"smart_learn",				/* OPT_smart_learn */
	"smart_cheat",				/* OPT_smart_cheat */
	"view_reduce_lite",			/* OPT_view_reduce_lite */
	"view_reduce_view",			/* OPT_view_reduce_view */
	"avoid_abort",				/* OPT_avoid_abort */
	"avoid_other",				/* OPT_avoid_other */
	"flush_failure",			/* OPT_flush_failure */
	"flush_disturb",			/* OPT_flush_disturb */
	"flush_command",			/* OPT_flush_command */
	"fresh_before",				/* OPT_fresh_before */
	"fresh_after",				/* OPT_fresh_after */
	"fresh_message",			/* OPT_fresh_message */
	"compress_savefile",		/* OPT_compress_savefile */
	"hilite_player",			/* OPT_hilite_player */
	"view_yellow_lite",			/* OPT_view_yellow_lite */
	"view_bright_lite",			/* OPT_view_bright_lite */
	"view_granite_lite",		/* OPT_view_granite_lite */
	"view_special_lite"			/* OPT_view_special_lite */
};


/*
 * Options -- descriptions (where defined)
 */
cptr option_desc[OPT_MAX] =
{
	"Rogue-like commands",						/* OPT_rogue_like_commands */
	"Activate quick messages",					/* OPT_quick_messages */
	"Prompt for floor item selection",			/* OPT_other_query_flag */
	"Prompt before picking things up",			/* OPT_carry_query_flag */
	"Use old target by default",				/* OPT_use_old_target */
	"Pick things up by default",				/* OPT_always_pickup */
	"Repeat obvious commands",					/* OPT_always_repeat */
	"Show dungeon level in feet",				/* OPT_depth_in_feet */
	"Merge inscriptions when stacking",			/* OPT_stack_force_notes */
	"Merge discounts when stacking",			/* OPT_stack_force_costs */
	"Show labels in object listings",			/* OPT_show_labels */
	"Show weights in object listings",			/* OPT_show_weights */
	"Show choices in certain sub-windows",		/* OPT_show_choices */
	"Show details in certain sub-windows",		/* OPT_show_details */
	"Audible bell (on errors, etc)",			/* OPT_ring_bell */
	"Use color for inventory listings",			/* OPT_inventory_colors */
	"When running, ignore stairs",				/* OPT_run_ignore_stairs */
	"When running, ignore doors",				/* OPT_run_ignore_doors */
	"When running, cut corners",				/* OPT_run_cut_corners */
	"When running, use corners",				/* OPT_run_use_corners */
	"Disturb whenever any monster moves",		/* OPT_disturb_move */
	"Disturb whenever viewable monster moves",	/* OPT_disturb_near */
	"Disturb whenever map panel changes",		/* OPT_disturb_panel */
	"Disturb whenever player state changes",	/* OPT_disturb_state */
	"Disturb whenever boring things happen",	/* OPT_disturb_minor */
	"Disturb whenever various things happen",	/* OPT_disturb_other */
	"Alert user to critical hitpoints",			/* OPT_alert_hitpoint */
	"Alert user to various failures",			/* OPT_alert_failure */
	NULL,										/* xxx */
	NULL,										/* xxx */
	NULL,										/* xxx */
	NULL,										/* xxx */
	"Auto-haggle in stores",					/* OPT_auto_haggle */
	"Auto-scum for good levels",				/* OPT_auto_scum */
	"Allow objects to stack on floor (beta)",	/* OPT_testing_stack */
	"Allow monsters to carry objects (beta)",	/* OPT_testing_carry */
	"Expand the power of the look command",		/* OPT_expand_look */
	"Expand the power of the list commands",	/* OPT_expand_list */
	"Map remembers all perma-lit grids",		/* OPT_view_perma_grids */
	"Map remembers all torch-lit grids",		/* OPT_view_torch_grids */
	"Generate dungeons with aligned rooms",		/* OPT_dungeon_align */
	"Generate dungeons with connected stairs",	/* OPT_dungeon_stair */
	"Monsters chase current location (v.slow)",	/* OPT_flow_by_sound */
	"Monsters chase recent locations (v.slow)",	/* OPT_flow_by_smell */
	"Monsters follow the player (broken)",		/* OPT_track_follow */
	"Monsters target the player (broken)",		/* OPT_track_target */
	"Monsters learn from their mistakes",		/* OPT_smart_learn */
	"Monsters exploit players weaknesses",		/* OPT_smart_cheat */
	"Reduce lite-radius when running",			/* OPT_view_reduce_lite */
	"Reduce view-radius in town",				/* OPT_view_reduce_view */
	"Avoid checking for user abort",			/* OPT_avoid_abort */
	"Avoid processing special colors",			/* OPT_avoid_other */
	"Flush input on various failures",			/* OPT_flush_failure */
	"Flush input whenever disturbed",			/* OPT_flush_disturb */
	"Flush input before every command",			/* OPT_flush_command */
	"Flush output before every command",		/* OPT_fresh_before */
	"Flush output after every command",			/* OPT_fresh_after */
	"Flush output after every message",			/* OPT_fresh_message */
	"Compress messages in savefiles",			/* OPT_compress_savefile */
	"Hilite the player with the cursor",		/* OPT_hilite_player */
	"Use special colors for torch-lit grids",	/* OPT_view_yellow_lite */
	"Use special colors for 'viewable' grids",	/* OPT_view_bright_lite */
	"Use special colors for wall grids (slow)",	/* OPT_view_granite_lite */
	"Use special colors for floor grids (slow)"	/* OPT_view_special_lite */
};


/*
 * Options -- normal values
 * Changed these to Kangband defaults -KMW-
 */
bool option_norm[OPT_MAX] =
{
	FALSE,		/* OPT_rogue_like_commands */
	TRUE,		/* OPT_quick_messages */
	TRUE,		/* OPT_other_query_flag */
	FALSE,		/* OPT_carry_query_flag */
	TRUE,		/* OPT_use_old_target */
	TRUE,		/* OPT_always_pickup */
	TRUE,		/* OPT_always_repeat */
	TRUE,		/* OPT_depth_in_feet */
	TRUE,		/* OPT_stack_force_notes */
	TRUE,		/* OPT_stack_force_costs */
	TRUE,		/* OPT_show_labels */
	TRUE,		/* OPT_show_weights */
	TRUE,		/* OPT_show_choices */
	TRUE,		/* OPT_show_details */
	FALSE,		/* OPT_ring_bell */
	TRUE,		/* OPT_inventory_colors */
	FALSE,		/* OPT_run_ignore_stairs */
	TRUE,		/* OPT_run_ignore_doors */
	TRUE,		/* OPT_run_cut_corners */
	TRUE,		/* OPT_run_use_corners */
	TRUE,		/* OPT_disturb_move */
	TRUE,		/* OPT_disturb_near */
	TRUE,		/* OPT_disturb_panel */
	TRUE,		/* OPT_disturb_state */
	TRUE,		/* OPT_disturb_minor */
	TRUE,		/* OPT_disturb_other */
	TRUE,		/* OPT_alert_hitpoint */
	FALSE,		/* OPT_alert_failure */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	TRUE,		/* OPT_auto_haggle */
	FALSE,		/* OPT_auto_scum */
	TRUE,		/* OPT_testing_stack */
	TRUE,		/* OPT_testing_carry */
	FALSE,		/* OPT_expand_look */
	FALSE,		/* OPT_expand_list */
	TRUE,		/* OPT_view_perma_grids */
	FALSE,		/* OPT_view_torch_grids */
	TRUE,		/* OPT_dungeon_align */
	TRUE,		/* OPT_dungeon_stair */
	FALSE,		/* OPT_flow_by_sound */
	FALSE,		/* OPT_flow_by_smell */
	FALSE,		/* OPT_track_follow */
	FALSE,		/* OPT_track_target */
	FALSE,		/* OPT_smart_learn */
	FALSE,		/* OPT_smart_cheat */
	FALSE,		/* OPT_view_reduce_lite */
	FALSE,		/* OPT_view_reduce_view */
	FALSE,		/* OPT_avoid_abort */
	FALSE,		/* OPT_avoid_other */
	TRUE,		/* OPT_flush_failure */
	FALSE,		/* OPT_flush_disturb */
	FALSE,		/* OPT_flush_command */
	TRUE,		/* OPT_fresh_before */
	FALSE,		/* OPT_fresh_after */
	FALSE,		/* OPT_fresh_message */
	TRUE,		/* OPT_compress_savefile */
	FALSE,		/* OPT_hilite_player */
	TRUE,		/* OPT_view_yellow_lite */
	TRUE,		/* OPT_view_bright_lite */
	TRUE,		/* OPT_view_granite_lite */
	TRUE		/* OPT_view_special_lite */
};


/*
 * Option screen interface
 */
byte option_page[4][16] =
{
	/*** User-Interface ***/

	{
		OPT_rogue_like_commands,
		OPT_quick_messages,
		OPT_other_query_flag,
		OPT_carry_query_flag,
		OPT_use_old_target,
		OPT_always_pickup,
		OPT_always_repeat,
		OPT_depth_in_feet,
		OPT_stack_force_notes,
		OPT_stack_force_costs,
		OPT_show_labels,
		OPT_show_weights,
		OPT_show_choices,
		OPT_show_details,
		OPT_ring_bell,
		OPT_inventory_colors
	},

	/*** Disturbance ***/

	{
		OPT_run_ignore_stairs,
		OPT_run_ignore_doors,
		OPT_run_cut_corners,
		OPT_run_use_corners,
		OPT_disturb_move,
		OPT_disturb_near,
		OPT_disturb_panel,
		OPT_disturb_state,
		OPT_disturb_minor,
		OPT_disturb_other,
		OPT_alert_hitpoint,
		OPT_alert_failure,
		255,
		255,
		255,
		255
	},

	/*** Game-Play ***/

	{
		OPT_auto_haggle,
		OPT_auto_scum,
		OPT_testing_stack,
		OPT_testing_carry,
		OPT_expand_look,
		OPT_expand_list,
		OPT_view_perma_grids,
		OPT_view_torch_grids,
		OPT_dungeon_align,
		OPT_dungeon_stair,
		OPT_flow_by_sound,
		OPT_flow_by_smell,
		OPT_track_follow,
		OPT_track_target,
		OPT_smart_learn,
		OPT_smart_cheat
	},

	/*** Efficiency ***/

	{
		OPT_view_reduce_lite,
		OPT_view_reduce_view,
		OPT_avoid_abort,
		OPT_avoid_other,
		OPT_flush_failure,
		OPT_flush_disturb,
		OPT_flush_command,
		OPT_fresh_before,
		OPT_fresh_after,
		OPT_fresh_message,
		OPT_compress_savefile,
		OPT_hilite_player,
		OPT_view_yellow_lite,
		OPT_view_bright_lite,
		OPT_view_granite_lite,
		OPT_view_special_lite
	}
};


