/* Scancode stuff - aeb, 991216 */

/* translation from keyboard to scancode - the 8042 table */

unsigned char ttable[256] = {
0xff,0x43,0x41,0x3f,0x3d,0x3b,0x3c,0x58,0x64,0x44,0x42,0x40,0x3e,0x0f,0x29,0x59,
0x65,0x38,0x2a,0x70,0x1d,0x10,0x02,0x5a,0x66,0x71,0x2c,0x1f,0x1e,0x11,0x03,0x5b,
0x67,0x2e,0x2d,0x20,0x12,0x05,0x04,0x5c,0x68,0x39,0x2f,0x21,0x14,0x13,0x06,0x5d,
0x69,0x31,0x30,0x23,0x22,0x15,0x07,0x5e,0x6a,0x72,0x32,0x24,0x16,0x08,0x09,0x5f,
0x6b,0x33,0x25,0x17,0x18,0x0b,0x0a,0x60,0x6c,0x34,0x35,0x26,0x27,0x19,0x0c,0x61,
0x6d,0x73,0x28,0x74,0x1a,0x0d,0x62,0x6e,0x3a,0x36,0x1c,0x1b,0x75,0x2b,0x63,0x76,
0x55,0x56,0x77,0x78,0x79,0x7a,0x0e,0x7b,0x7c,0x4f,0x7d,0x4b,0x47,0x7e,0x7f,0x6f,
0x52,0x53,0x50,0x4c,0x4d,0x48,0x01,0x45,0x57,0x4e,0x51,0x4a,0x37,0x49,0x46,0x54,
0x80,0x81,0x82,0x41,0x54,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
};

/* some entries guessed - see scancodes.sgml */


/* Untranslated scancodes, and USB key values.
   For translated values, feed through ttable[].

   I also included Vojtech Pavlik's scancodes.h in this directory.
   It mostly agrees with this table, but lacks
   Microsoft Internet keys, and misses some set1 values. */

struct keycode {
	unsigned int position,	usb,	set1,	set2,	set3;
	char *name;		/* keycap on a standard US keyboard */
} keycodes[] = {
	1,	53,	0x29,	0x0e,	0x0e,	"`~",
	2,	30,	0x02,	0x16,	0x16,	"1!",
	3,	31,	0x03,	0x1e,	0x1e,	"2@",
	4,	32,	0x04,	0x26,	0x26,	"3#",
	5,	33,	0x05,	0x25,	0x25,	"4$",
	6,	34,	0x06,	0x2e,	0x2e,	"5%E",
	7,	35,	0x07,	0x36,	0x36,	"6^",
	8,	36,	0x08,	0x3d,	0x3d,	"7&",
	9,	37,	0x09,	0x3e,	0x3e,	"8*",
	10,	38,	0x0a,	0x46,	0x46,	"9(",
	11,	39,	0x0b,	0x45,	0x45,	"0)",
	12,	45,	0x0c,	0x4e,	0x4e,	"-_",
	13,	46,	0x0d,	0x55,	0x55,	"=+",
	15,	42,	0x0e,	0x66,	0x66,	"Backspace",

	16,	43,	0x0f,	0x0d,	0x0d,	"Tab",
	17,	20,	0x10,	0x15,	0x15,	"Q",
	18,	26,	0x11,	0x1d,	0x1d,	"W",
	19,	8,	0x12,	0x24,	0x24,	"E",
	20,	21,	0x13,	0x2d,	0x2d,	"R",
	21,	23,	0x14,	0x2c,	0x2c,	"T",
	22,	28,	0x15,	0x35,	0x35,	"Y",
	23,	24,	0x16,	0x3c,	0x3c,	"U",
	24,	12,	0x17,	0x43,	0x43,	"I",
	25,	18,	0x18,	0x44,	0x44,	"O",
	26,	19,	0x19,	0x4d,	0x4d,	"P",
	27,	47,	0x1a,	0x54,	0x54,	"[{",
	28,	48,	0x1b,	0x5b,	0x5b,	"]}",
	29,	49,	0x2b,	0x5d,	0x5c,	"\\|",

	30,	57,	0x3a,	0x58,	0x14,	"CapsLock",
	31,	04,	0x1e,	0x1c,	0x1c,	"A",
	32,	22,	0x1f,	0x1b,	0x1b,	"S",
	33,	7,	0x20,	0x23,	0x23,	"D",
	34,	9,	0x21,	0x2b,	0x2b,	"F",
	35,	10,	0x22,	0x34,	0x34,	"G",
	36,	11,	0x23,	0x33,	0x33,	"H",
	37,	13,	0x24,	0x3b,	0x3b,	"J",
	38,	14,	0x25,	0x42,	0x42,	"K",
	39,	15,	0x26,	0x4b,	0x4b,	"L",
	40,	51,	0x27,	0x4c,	0x4c,	";:",
	41,	52,	0x28,	0x52,	0x52,	"'\"",
	42,	50,	0,	0,	0,	"non-US-1",
	43,	40,	0x1c,	0x5a,	0x5a,	"Enter",

	44,	225,	0x2a,	0x12,	0x12,	"LShift",
	46,	29,	0x2c,	0x1a,	0x1a,	"Z",
	47,	27,	0x2d,	0x22,	0x22,	"X",
	48,	6,	0x2e,	0x21,	0x21,	"C",
	49,	25,	0x2f,	0x2a,	0x2a,	"V",
	50,	5,	0x30,	0x32,	0x32,	"B",
	51,	17,	0x31,	0x31,	0x31,	"N",
	52,	16,	0x32,	0x3a,	0x3a,	"M",
	53,	54,	0x33,	0x41,	0x41,	",<",
	54,	55,	0x34,	0x49,	0x49,	".>",
	55,	56,	0x35,	0x4a,	0x4a,	"/?",
	57,	229,	0x36,	0x59,	0x59,	"RShift",

	58,	224,	0x1d,	0x14,	0x11,	"LCtrl",
	60,	226,	0x38,	0x11,	0x19,	"LAlt",
	61,	44,	0x39,	0x29,	0x29,	"space",
	62,	230,	0xe038,	0xe011,	0x39,	"RAlt",
	64,	228,	0xe01d,	0xe014,	0x58,	"RCtrl",

	75,	73,	0xe052,	0xe070,	0x67,	"Insert",
	76,	76,	0xe053,	0xe071,	0x64,	"Delete",
	80,	74,	0xe047,	0xe06c,	0x6e,	"Home",
	81,	77,	0xe04f,	0xe069,	0x65,	"End",
	85,	75,	0xe049,	0xe07d,	0x6f,	"PgUp",
	86,	78,	0xe051,	0xe07a,	0x6d,	"PgDn",

	79,	80,	0xe04b,	0xe06b,	0x61,	"Left",
	83,	82,	0xe048,	0xe075,	0x63,	"Up",
	84,	81,	0xe050,	0xe072,	0x60,	"Down",
	89,	79,	0xe04d,	0xe074,	0x6a,	"Right",

	90,	83,	0x45,	0x77,	0x76,	"NumLock",
	91,	95,	0x47,	0x6c,	0x6c,	"KP-7 / Home",
	92,	92,	0x4b,	0x6b,	0x6b,	"KP-4 / Left",
	93,	89,	0x4f,	0x69,	0x69,	"KP-1 / End",
	95,	84,	0xe035,	0xe04a,	0x77,	"KP-/",
	96,	96,	0x48,	0x75,	0x75,	"KP-8 / Up",
	97,	93,	0x4c,	0x73,	0x73,	"KP-5",
	98,	90,	0x50,	0x72,	0x72,	"KP-2 / Down",
	99,	98,	0x52,	0x70,	0x70,	"KP-0 / Ins",
	100,	85,	0x37,	0x7c,	0x7e,	"KP-*",
	101,	97,	0x49,	0x7d,	0x7d,	"KP-9 / PgUp",
	102,	94,	0x4d,	0x74,	0x74,	"KP-6 / Right",
	103,	91,	0x51,	0x7a,	0x7a,	"KP-3 / PgDn",
	104,	99,	0x53,	0x71,	0x71,	"KP-. / Del",
	105,	86,	0x4a,	0x7b,	0x84,	"KP--",
	106,	87,	0x4e,	0x79,	0x7c,	"KP-+",
	108,	88,	0xe01c,	0xe05a,	0x79,	"KP-Enter",

	110,	41,	0x01,	0x76,	0x08,	"Esc",
	112,	58,	0x3b,	0x05,	0x07,	"F1",
	113,	59,	0x3c,	0x06,	0x0f,	"F2",
	114,	60,	0x3d,	0x04,	0x17,	"F3",
	115,	61,	0x3e,	0x0c,	0x1f,	"F4",
	116,	62,	0x3f,	0x03,	0x27,	"F5",
	117,	63,	0x40,	0x0b,	0x2f,	"F6",
	118,	64,	0x41,	0x83,	0x37,	"F7", /* Vojtech has 0x02 in set2 */
	119,	65,	0x42,	0x0a,	0x3f,	"F8",
	120,	66,	0x43,	0x01,	0x47,	"F9",
	121,	67,	0x44,	0x09,	0x4f,	"F10",
	122,	68,	0x57,	0x78,	0x56,	"F11",
	123,	69,	0x58,	0x07,	0x5e,	"F12",

	124,	70,	0xe037,	0xe07c,	0x57,	"PrtScr",
	  0,	154,	0x54,	0x84,	0x57,	"Alt+SysRq",
	125,	71,	0x46,	0x7e,	0x5f,	"ScrollLock",
	126,	72, 0xe11d45, 0xe11477,	0x62,	"Pause",
	  0,	0,	0xe046,	0xe07e,	0x62,	"Ctrl+Break",

	/* Microsoft Windows and Internet keys and Power keys */
	0,	227,	0xe05b,	0xe01f,	0x8b,	"LWin (USB: LGUI)",
	0,	231,	0xe05c,	0xe027,	0x8c,	"RWin (USB: RGUI)",
	0,	0,	0xe05d,	0xe02f,	0x8d,	"Menu",

	0,	0,	0xe06a,	0xe038,	0x38,	"Back",
	0,	0,	0xe069,	0xe030,	0x30,	"Forward",
	0,	0,	0xe068,	0xe028,	0x28,	"Stop",
	0,	0,	0xe06c,	0xe048,	0x48,	"Mail",
	0,	0,	0xe065,	0xe010,	0x10,	"Search",
	0,	0,	0xe066,	0xe018,	0x18,	"Favorites",
	0,	0,	0xe032,	0xe03a,	0x97,	"Web / Home",

	0,	0,	0xe06b,	0xe040,	0x40,	"My Computer",
	0,	0,	0xe021,	0xe02b,	0x99,	"Calculator",
	0,	0,	0xe05f,	0xe03f,	0x7f,	"Sleep",
	0,	0,	0xe05e, 0xe037, 0,	"Power",
	0,	0, 	0xe063,	0xe05e, 0,	"Wake",
};
