#include <stdio.h>
#include <midi.h>
extern MpuCmd TimingClockWithMeasureEnd;

putTCWME(fd,t)
/*
** Write a `timing clock with measure end` MIDI command with offset 't'
** onto file descriptor 'fd'.
** When writing out long lists of `play` data, a TCWME event
** must occur every '2*Period' (default=480) ticks;
** cf. 'MidiStretch', etc.
*/
{
	extern MpuCmd TimingClockWithMeasureEnd;
	MpuCmd *m = &TimingClockWithMeasureEnd;
	m->time_tag = (unsigned char )t;
	m->mpu_time = t;
	putMpuCmd(fd,m);
}

PutTCWME(f,t)
	FILE *f;
/*
** Same as 'putTCWME(fileno(f), t)'.
*/
{
	putTCWME(fileno(f),t);
}
