/*
** Copy MIDI data from 'in' to 'out', shifting the times by 'offset'
** to delay or rush the events (times before 0 are ignored).
** Example: 'mputimeshift(in,out,-0.5)' deletes the first 1/2 measures
** of the data.
*/
#include <stdio.h>
#include <midi.h>
mputimeshift(in, out, offset)
FILE	*in, *out;
float	offset;
{
	long when = offset * 2 * MPU_CLOCK_PERIOD;
	MpuCmd m;

	while (GetMpuCmd(in, &m)) {
		when += m.time_tag == RT_TCIP? MPU_CLOCK_PERIOD : m.time_tag;
		if (when >= 0)
			mpuclockput(out, &m, when);
	}
	mpuclockput(out, 0, 0);
}
