/*
**	SUSTAIN -- Strip sustain pedal codes
**	psl 3/89
*/
#include	<stdio.h>
#include	<midi.h>

#define	NUMCHANS	MIDI_MAX_CHANS
#define	CTL_SUST	0x40

main(argc, argv)
char	*argv[];
{
	register int i, c, k, mode;
	u_char mbuf[4], kub[NUMCHANS][100], *kubp[NUMCHANS];
	int sus[NUMCHANS], sflg;
	long now;
	MCMD *mp, m;

	sflg = 0;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 's':		/* don't adjust key-off */
		    sflg++;
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s -s\n", argv[0]);
		fprintf(stderr, "-s just strips sustain pedal codes.\n");
		fprintf(stderr, "Normally note lengths are adjusted also.\n");
		exit(2);
	    }
	}
	for (c = NUMCHANS; --c >= 0; sus[c] = 0);
	m.cmd = mbuf;
	m.len = 3;
	for (now = 0L; mp = getmcmd(stdin, now); now = mp->when) {
	    now = mp->when;
	    mode = mp->cmd[0] & M_CMD_MASK;
	    c = mp->cmd[0] & M_CHAN_MASK;
	    if (mode == CH_KEY_ON || mode == CH_KEY_OFF) {
		k = mp->cmd[1];
		if (mode == CH_KEY_OFF) {
		    mode = mp->cmd[0] = CH_KEY_ON | c;
		    mp->cmd[2] = 0;
		}
		if (mp->cmd[2] == 0) {
		    if (sus[c] && !sflg) {
			*kubp[c]++ = k;
			continue;
		    }
		}
	    } else if (mode == CH_CTL && mp->cmd[1] == CTL_SUST) {
		if (sflg)
		    continue;
		if (mp->cmd[2]) {		/* sustain pedal down */
		    sus[c]++;
		    kubp[c] = kub[c];
		} else {			/* sustain pedal up */
		    --sus[c];
		    m.when = now;
		    m.cmd[2] = 0;
		    m.cmd[0] = CH_KEY_OFF | c;
		    while (kubp[c] > kub[c]) {
			m.cmd[1] = *--kubp[c];
			putmcmd(stdout, &m);
		    }
		}
		continue;
	    }
	    putmcmd(stdout, mp);
	}
	exit(0);
}
