#include "cs.h"			/*				MEMFILES.C	*/

#define MAXFILES  20

static MEMFIL memfiles[MAXFILES];
extern int    isfullpath();              /* def in filopen.c */
extern char   *sadirpath, *catpath();    /* def in filopen.c */

#ifndef THINK_C

static struct stat statbuf;

static int LoadFile(filnam, foo, allocp, len)  /* simulate the THINK_C LoadFile  */
     char *filnam;                             /* reads the entire file into mem */
     int  foo;      /* unused */
     char **allocp;
     long *len;
{
	int	fd;

        if ((fd = open(filnam, O_RDONLY, 0)) < 0)       /* if can't open the file */
	    return(1);                                  /*    return 1            */
	fstat(fd, &statbuf);				/* else get its length */
	*len = statbuf.st_size;
	*allocp = mmalloc((long)(*len));            	/*   alloc as reqd     */
	if (read(fd, *allocp, (int)(*len)) != *len)	/*   read file in      */
	    dies("read error on %s",filnam);
	close(fd);					/*   and close it      */
	return(0);                                      /*   return 0 for OK   */
}

#endif

 MEMFIL *
ldmemfile(filnam)               /* read an entire file into memory, and log it */
 char *filnam;                  /* share the file with all subsequent requests */
{                               /* if not fullpath, look in current directory, */
                                /*   then SADIR (if defined).                  */
                                /* Used by adsyn, pvoc, and lpread             */
	MEMFIL	*mfp, *mfp2, *endp;
	char	*allocp;
	long	len;
	char    *pathnam = filnam;

	for (mfp=memfiles,endp=mfp+MAXFILES; mfp<endp; mfp++) {
	    if (strcmp(mfp->filename,"") == 0)              /* if empty slot */
	        goto ldopn;                                 /*   go readfile */
	    else if (strcmp(mfp->filename,filnam) == 0)     /* else if match */
	        return(mfp);                                /*   we have it  */
	}
	sprintf(errmsg,"memfiles: MAXFILES exceeded");      /* else overflow */
	goto lderr;

ldopn:	if (isfullpath(filnam)) {
            if (LoadFile(filnam,0,&allocp,&len)) {          /* look fullpath */
	        sprintf(errmsg,"cannot load %s", filnam);
		goto lderr;
	    }
	}
	else {
	    if (LoadFile(filnam,0,&allocp,&len) == 0)       /* look in cur dir */
	        goto done;
	    if (sadirpath != NULL) {                        /* if SADIR set,   */
		pathnam = catpath(sadirpath, filnam);       /*   get fullname  */
		for (mfp2=memfiles; mfp2<mfp; mfp2++)       /*   chk prv slots */
		    if (strcmp(mfp2->filename,pathnam) == 0)
		        return(mfp2);                       /*   if match, rtn */
		if (LoadFile(pathnam,0,&allocp,&len)) {     /*   else loadfile */
		    sprintf(errmsg,"cannot load %s", pathnam);
		    goto lderr;
		}
	    }
	    else {
		sprintf(errmsg,"cannot load %s, or SADIR undefined", pathnam);
		goto lderr;
	    }
	}	    
done:	strcpy(mfp->filename, pathnam);                      /* init the struct */
	mfp->beginp = allocp;
	mfp->endp = allocp + len;
	mfp->length = len;
	printf("file %s (%ld bytes) loaded into memory\n", pathnam,len);
 	return(mfp);                                         /* rtn new slotadr */

lderr:	initerror(errmsg);
	return(NULL);
}

void rlsmemfiles()       /* clear the memfile array, & free all allocated space */
{
register MEMFIL  *mfp, *endp;
register int     memcount = 0;

	for (mfp=memfiles,endp=mfp+MAXFILES; mfp<endp; mfp++)
	    if (strcmp(mfp->filename,"") != 0) {            /* if slot taken    */
	        strcpy(mfp->filename,"");                   /*   clr the name & */
	        free(mfp->beginp);                          /*   free the space */
		memcount++;
	    }
        if (memcount)
	    printf("%d memfile%s deleted\n", memcount, (memcount>1)? "s":"");
}
