#ifndef _UNISTD_H
#define _UNISTD_H

/* ok, this may be a joke, but I'm working on it */
#define _POSIX_VERSION		198808L

/* only root can do a chown (I think..) */
#define _POSIX_CHOWN_RESTRICTED	1

/* no pathname truncation (but see in kernel) */
#define _POSIX_NO_TRUNC		1

/* character to disable things like ^C */
#define _POSIX_VDISABLE		'\0'

#define _POSIX_JOB_CONTROL	1

/* Implemented, for whatever good it is */
#define _POSIX_SAVED_IDS	1 

#define STDIN_FILENO	0
#define STDOUT_FILENO	1
#define STDERR_FILENO	2

#ifndef NULL
#define NULL    ((void *)0)
#endif

/* access */
#define F_OK	0
#define X_OK	1
#define W_OK	2
#define R_OK	4

/* lseek */
#define SEEK_SET	0
#define SEEK_CUR	1
#define SEEK_END	2

/* Symbolic constants for sysconf() variables
 * defined by POSIX.1: 0-99
 */

/* ARG_MAX: Max length of argument to exec()
 * including environment data */
#define _SC_ARG_MAX		0
/* CHILD_MAX: Max # of processes per userid */
#define _SC_CHILD_MAX		1
/* Number of clock ticks per second */
#define _SC_CLK_TCK		2
/* NGROUPS_MAX: Max # of simultaneous supplementary group
 * IDs per process */
#define _SC_NGROUPS_MAX 	3
/* OPEN_MAX: Max # of files that one process can have open at
 * any one time */
#define _SC_OPEN_MAX		4
/* _POSIX_JOB_CONTROL: 1 iff supported */
#define _SC_JOB_CONTROL		5
/* _POSIX_SAVED_IDS: 1 iff supported */
#define _SC_SAVED_IDS		6

/* Symbolic constants for sysconf() variables added
 * by POSIX.1-1990: 100-199 */

/* STREAM_MAX: Max # of open stdio FILEs */
#define _SC_STREAM_MAX		100
/* TZNAME_MAX: Max length of timezone name */
#define _SC_TZNAME_MAX		101

#define _SC_VERSION		102

/* Symbolic constants for sysconf() variables
 * added by POSIX.2: 200-299 */

/* largest ibase & obase for bc */
#define _SC_BC_BASE_MAX		200 
/* max array elements for bc */
#define _SC_BC_DIM_MAX		201
/* max scale value for bc */
#define _SC_BC_SCALE_MAX	202
#define _SC_BC_STRING_MAX	203
/* max bytes in collation element */
#define _SC_COLL_ELEM_MAX	204
#define _SC_EQUIV_CLASS_MAX	205
/* max nesting of (...) for expr */
#define _SC_EXPR_NEST_MAX	206
/* max length in bytes of input line */
#define _SC_LINE_MAX		207 
/* max file operands for paste */
#define _SC_PASTE_FILES_MAX	208 
/* max regular expressions permitted */
#define _SC_RE_DUP_MAX		209 
/* max bytes of pattern space for sed */
#define _SC_SED_PATTERN_MAX	210 
/* max bytes of message for sendto */
#define _SC_SENDTO_MAX		211 
/* max bytes of input line for sort */
#define _SC_SORT_LINE_MAX	212 
/* Current version of POSIX.2 */
#define _SC_2_VERSION		213
/* C Language Bindings Option */
#define _SC_2_C_BIND		214
/* C Development Utilities Option */
#define _SC_2_C_DEV		215
/* FORTRAN Dev. Utilities Option */
#define _SC_2_FORT_DEV		216
/* Software Dev. Utilities Option */
#define _SC_2_SW_DEV		217

/* Symbolic constants for sysconf() variables defined by
 * X/Open: 2000-2999 */

/* _XOPEN_VERSION: Issue # of XPG */
#define _SC_XOPEN_VERSION	8
/* PASS_MAX: Max # of bytes in password */
#define _SC_PASS_MAX		9
/* CLOCKS_PER_SEC: Units/sec of clock() */
#define _SC_CLOCKS_PER_SEC	2000

/* Symbolic constants for sysconf() variables
defined by OSF: 3000-3999 */

/* AES_OS_VERSION: Version of OSF/AES OS */
#define _SC_AES_OS_VERSION	3000
/* PAGE_SIZE: Software page size */
#define _SC_PAGE_SIZE		3001
/* ATEXIT_MAX: Max # of atexit() funcs */
#define _SC_ATEXIT_MAX		3002

/* Symbolic constants for sysconf() variables
defined by HP-UX: 10000-19999 */

/* SECURITY_CLASS: DoD security level */
#define _SC_SECURITY_CLASS	10000
/* CPU type this program is running on */
#define _SC_CPU_VERSION		10001
/* I/O system type this system supports */
#define _SC_IO_TYPE		10002

/* Symbolic constants for pathconf() defined by POSIX.1: 0-99 */

/* LINK_MAX: Max # of links to a single file */
#define _PC_LINK_MAX		0
/* MAX_CANON: Max # of bytes in a terminal canonical input line */
#define _PC_MAX_CANON		1
/* MAX_INPUT: Max # of bytes allowed in a terminal input queue */ 
#define _PC_MAX_INPUT		2
/* NAME_MAX: Max # of bytes in a filename */
#define _PC_NAME_MAX		3
/* PATH_MAX: Max # of bytes in a pathname */
#define _PC_PATH_MAX		4
/* PIPE_BUF: Max # of bytes for which pipe writes are atomic */ 
#define _PC_PIPE_BUF		5
/* _POSIX_CHOWN_RESTRICTED: 1 iff only a privileged process can
 * use chown() */
#define _PC_CHOWN_RESTRICTED	6
/* _POSIX_NO_TRUNC: 1 iff an error is detected when
 * exceeding NAME_MAX */
#define _PC_NO_TRUNC		7
/* _POSIX_VDISABLE: character setting which disables TTY local
 * editing characters */
#define _PC_VDISABLE		8

/* Conformance and options for POSIX.2 */

/* 1989 (1989), POSIX.2, Draft 9 (09)L */
#define _POSIX2_VERSION 198909L
#define _POSIX2_C_BIND		1	/* Always on */
#define _POSIX2_C_DEV		-1
#define _POSIX2_FORT_DEV	-1
#define _POSIX2_SW_DEV		-1


/* Path on which all POSIX.2 utilities can be found */

#define CS_PATH	  "/bin:/usr/bin:"

/* Symbolic constants for confstr() defined by POSIX.2: 200-299 */

/* Search path that finds all POSIX.2 utils */
#define _CS_PATH	200


#include <sys/stat.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/utsname.h>
#include <sys/resource.h>
#include <utime.h>
#include <signal.h>

#ifdef __LIBRARY__
#include <linux/unistd.h>
#endif

extern char **environ;

#ifdef __cplusplus
extern "C" {
#endif

/* XXX - several non-POSIX functions here, and POSIX functions that are
 * supposed to be declared elsewhere.  Non-promotion of short types in
 * prototypes may cause trouble.  Arg names should be prefixed by
 * underscores.
 */

/* XXX - short type */
extern int	access(const char* filename, mode_t mode);
extern int	acct(const char* filename);
/* XXX - POSIX says unsigned alarm(unsigned sec) */
extern int	alarm(int sec);
extern int	brk(void* end_data_segment);
extern void*	sbrk(ptrdiff_t increment);
extern int	chdir(const char* filename);
/* XXX - short type */
extern int	chmod(const char* filename, mode_t mode);
/* XXX - short type */
extern int	chown(const char* filename, uid_t owner, gid_t group);
extern int	chroot(const char* filename);
extern int	close(int fildes);
/* XXX - short type */
extern int	creat(const char* filename, mode_t mode);
extern int	dup(int fildes);
extern int	dup2(int oldfd, int newfd);
extern int	execl(const char* pathname, const char* arg0, ...);
extern int	execle(const char * pathname, const char * arg0, ...);
extern int	execlp(const char* file, const char* arg0, ...);
extern int	execv(const char* pathname, char* const argv []);
extern int	execve(const char* filename, char* const argv [],
	char* const envp []);
extern int	execvp(const char* file, char* const argv []);
extern volatile	void _exit(int status);
extern int	fchmod(int fildes, mode_t mode);
extern int	fchown(int fildes, uid_t owner, gid_t group);
extern int	fcntl(int fildes, int cmd, ...);
extern pid_t	fork(void);
extern int	fstat(int fildes, struct stat* stat_buf);
extern int	ftruncate(int fildes, size_t length);
extern gid_t	getegid(void);
extern uid_t	geteuid(void);
extern gid_t	getgid(void);
extern int	getgroups(int gidsetlen, gid_t *gidset);
extern int	gethostname(char *name, int len);
extern pid_t	getpgrp(void);
extern pid_t	getpid(void);
extern int	getppid(void);
extern uid_t	getuid(void);
extern int	ioctl(int fildes, int cmd, ...);
extern int	ioperm (unsigned long from, unsigned long num,
			int turn_on);
extern int	link(const char* filename1, const char* filename2);
extern off_t	lseek(int fildes, off_t offset, int origin);
extern int	lstat(const char* filename, struct stat* stat_buf);
extern int	mkdir(const char *__path, mode_t __mode);
/* XXX - shorts */
extern int	mknod(const char* __filename, mode_t __mode,
			dev_t __dev);
extern caddr_t	mmap(caddr_t __addr, size_t __len, int __prot,
			int __flags, int __fd, off_t __off);
extern int	mount(const char* __specialfile, const char* __dir,
			const char* __filesystemype, int __rwflag);
extern int	munmap(caddr_t __addr, size_t __len);
extern int	nice(int __val);
extern int	open(const char* __filename, int __flag, ...);
extern int	pause(void);
extern int	pipe(int* __fildes);
extern int	profil(char *__buf, int __bufsiz, int __offset,
			int __scale);
extern int	ptrace(int __request, int __pid, int __addr,
			int __data);
/* XXX**2 - POSIX says unsigned count */
extern int	read(int fildes, char* buf, off_t count);
extern int	readlink(const char *path, char *buf, int bufsiz);
extern int	reboot(int magic, int magic_too, int flag);
extern int	rename(const char *from, const char *to);
extern int	rmdir(const char *path);
extern int	setgid(gid_t gid);	/* XXX - short type */
extern int	setgroups(int gidsetlen, gid_t *gidset);
extern int	sethostname(char* name, int len);
extern int	setpgid(pid_t pid,pid_t pgid);
extern int	setpgrp(void);
extern int	setregid(gid_t rgid, gid_t egid);
extern int	setreuid(uid_t ruid, uid_t euid);
extern pid_t	setsid(void);
extern int	setuid(uid_t uid);	/* XXX - short type */
extern int	stat(const char* filename, struct stat* stat_buf);
extern int	swapon(const char * specialfile);
extern int	symlink(const char *name1, const char *name2);
extern int	sync(void);
extern int	truncate(const char *path, size_t length);
/* extern int	ulimit(int cmd, long limit); */
extern mode_t	umask(mode_t mask);
extern int	umount(const char* specialfile);
extern int	uname(struct utsname* name);
extern int	unlink(const char* filename);
#if 1
extern int	uselib(const char *filename);
#else
extern int	uselib(const char *filename, daddr_t address);
#endif
extern int	ustat(dev_t dev, struct ustat* ubuf);
extern pid_t	vfork(void);
/* XXX**2 - POSIX says unsigned count */
extern int	write(int fildes, const char* buf, off_t count);

extern long	sysconf(int name);
extern long	pathconf(const char *path, int name);
extern long	fpathconf(int fildes, int name);
extern size_t	confstr(int name, char *buf, size_t len);

#ifdef __cplusplus
}                                               /* for C++ V2.0 */
#endif

#endif
