/*  VT1500 Device Driver for Linux, Version 1.0.5
 *  Copyright (C) 1995  M. Gutschke
 *
 *  At the time of writing my e-mail address is:
 *	Internet: gutschk@uni-muenster.de
 *  My snail mail address is:
 *	Markus Gutschke
 *	Schlage 5a
 *	48268 Greven-Gimbte
 *	Germany
 *  If you like this software, I would appreciate if you sent me a postcard
 *  from your hometown. Under the terms of the GNU general public license
 *  you are free to include this program into (commercial) software
 *  distributions (e.g. putting it onto CD-ROM); nonetheless, I would really
 *  appreciate if you dropped me a short note (sending me a sample copy of
 *  your distribution would be even more appreciated!)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "gui.h"
#include "logdos.h"
#include "rc.h"
#include "terminal.h"
#include "tv.h"
#include "tvcontrol.h"

static time_t tvTimeout = 0;

void checkTvTimeout()
{
  if (tvTimeout &&
      time(NULL) >= tvTimeout)
    exit(0);
  return;
}

static void parseTimeout(char *s)
{
  time_t ctime = time(NULL);
  struct tm tm;
  
  memcpy(&tm,localtime(&ctime),sizeof(struct tm));
  if (!s || !*s) {
  err:
    fprintf(stderr,"Expecting XX:XX or XX (minutes) for `--timeout'\n");
    exit(1); }
  if (strchr(s,':')) {
    int hour = 0,min = 0;
    while (isspace(*s)) s++;
    while (isdigit(*s)) hour = hour*10+*s++-'0';
    while (isspace(*s)) s++;
    if (*s++ != ':') goto err;
    while (isspace(*s)) s++;
    while (isdigit(*s)) min = min*10+*s++-'0';
    while (isspace(*s)) s++;
    if (*s || hour < 0 || hour > 23 || min < 0 || min > 59) goto err;
    if (hour < tm.tm_hour || (hour == tm.tm_hour && min <= tm.tm_min)) {
      ctime += 24L*60L*60L;
      memcpy(&tm,localtime(&ctime),sizeof(struct tm)); }
    tm.tm_hour = hour;
    tm.tm_min  = min;
    tvTimeout = mktime(&tm); }
  else {
    int min = 0;
    while (isspace(*s)) s++;
    while (isdigit(*s)) min = min*10+*s++-'0';
    while (isspace(*s)) s++;
    if (*s || min < 0) goto err;
    tvTimeout = ctime + min*60L; }
  return;
}

static void usage(char *prgname)
{
  printf("Usage: %s [options]\n"
         "  --radio                  sound only\n"
         "  --tv                     sound&image [default]\n"
	 "  --vcr                    input from VCR\n"
	 "  --timeout <XX:XX | XX>   switch off at XX:XX\n"
	 "  --log                    parse logfile from dosemu\n"
	 "  --vt <vtnumber>          allocate specified virtual console\n"
	 "  --novt                   do not allocate virtual console\n"
	 "  --port <port>            specify port number (200 or 300)\n"
	 "  --force                  force port access\n"
	 "  --version                print version number\n"
	 "  --help                   print this information\n",
	 prgname);
  return;
}

static char *basename(char *s)
{
  char *ptr = strrchr(s,'/');

  return(ptr == NULL ? s : ptr+1);
}

int main(int argc,char *argv[])
{
  int i,vcr = 0;

  if (*argv != NULL) {
    char *bn = basename(*argv);
    if (!strcmp(bn,"radio"))
      setRadio(1);
    else if (!strcmp(bn,"vcr"))
      vcr = 1; }
  for (i = 1; i < argc; i++) {
    if (!strcmp(argv[i],"--radio"))
      setRadio(1);
    else if (!strcmp(argv[i],"--tv"))
      setRadio(0);
    else if (!strcmp(argv[i],"--vcr"))
      vcr = 1;
    else if (!strcmp(argv[i],"--timeout"))
      parseTimeout(argv[++i]);
    else if (!strcmp(argv[i],"--log")) {
      logDos();
      return(0); }
    else if (!strcmp(argv[i],"--vt")) {
      char *ptr = argv[++i];
      if (ptr) {
	while (isspace(*ptr)) ptr++;
	while (isdigit(*ptr)) useVT = 10*useVT + *ptr++ - '0';
	while (isspace(*ptr)) ptr++; }
      if (!ptr || *ptr) {
	fprintf(stderr,"Could not parse --vt <VTNUM>\n");
	return(1); } }
    else if (!strcmp(argv[i],"--novt"))
      useVT = -1;
    else if (!strcmp(argv[i],"--port")) {
      int port = 0;
      char *ptr = argv[++i];
      if (ptr) {
	while (isspace(*ptr)) ptr++;
	if (*ptr == '$') ptr++;
	else if (*ptr == '0' && (ptr[1] == 'x' || ptr[1] == 'X')) ptr += 2;
	while (isxdigit(*ptr)) {
	  port = 16*port + (*ptr&~0x20) - (*ptr <= 0x39 ? 0x10 : 0x37);ptr++; }
	while (isspace(*ptr)) ptr++;
        RCSettings.port = -port; }
      if (!ptr || *ptr) {
	fprintf(stderr,"Could not parse --port <port>\n");
	return(1); } }
    else if (!strcmp(argv[i],"--force"))
      forcePort = 1;
    else if (!strcmp(argv[i],"--version")) {
      printf("%s\n",VERSION);
      return(0); }
    else {
      usage(argv[0]);
      return(!!strcmp(argv[i],"--help")); } }
  gui(vcr);
  return(0);
}

