%{

/*  VT1500 Device Driver for Linux, Version 1.0.5
 *  Copyright (C) 1995  M. Gutschke
 *
 *  At the time of writing my e-mail address is:
 *	Internet: gutschk@uni-muenster.de
 *  My snail mail address is:
 *	Markus Gutschke
 *	Schlage 5a
 *	48268 Greven-Gimbte
 *	Germany
 *  If you like this software, I would appreciate if you sent me a postcard
 *  from your hometown. Under the terms of the GNU general public license
 *  you are free to include this program into (commercial) software
 *  distributions (e.g. putting it onto CD-ROM); nonetheless, I would really
 *  appreciate if you dropped me a short note (sending me a sample copy of
 *  your distribution would be even more appreciated!)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Lexical scanner for reading configuration data
 */

#include <stdlib.h>
#include "rcyacc.tab.h"

#define rcwrap()  1

static int frqtoi(const char *s)
{
  double f = atof(s);
  return(f < 0 ? (int)(f*10-0.5) : (int)(f*10+0.5));
}

%}

%%

readonly		{ return(READONLY); }
externalmute		{ return(EXTERNALMUTE); }
port			{ return(PORT); }
station                 { return(STATION); }
mhz			{ return(MHZ); }
radio			{ return(RADIO); }
pal			{ return(PAL); }
ntsc			{ return(NTSC); }
display			{ return(DISPLAY); }
vga			{ return(VGA); }
tuner			{ return(TUNER); }
source			{ return(SOURCE); }
tv			{ return(TV); }
vcr			{ return(VCR); }
channel			{ return(CHANNEL); }
mode			{ return(MODE); }
mute			{ return(MUTE); }
on			{ return(ON); }
off			{ return(OFF); }
bass			{ return(BASS); }
treble			{ return(TREBLE); }
volume			{ return(VOLUME); }
brightness		{ return(BRIGHTNESS); }
saturation		{ return(SATURATION); }
contrast		{ return(CONTRAST); }
hue			{ return(HUE); }
red			{ return(RED); }
green			{ return(GREEN); }
blue                    { return(BLUE); }

[ \n\t\%]+		{; /* ignore whitespace */}
#.*			{; /* ignore comments   */}
0[xX][0-9a-fA-F]+	{rclval=(int)strtoul(rctext+2,NULL,16);return(NUMBER);}
[-+]?[0-9]+\.[0-9]+	{ rclval = frqtoi(rctext); return(FNUMBER); }
[-+]?[0-9]+		{ rclval = atoi(rctext); return(NUMBER); }
[a-zA-Z][a-zA-Z0-9]*	{ return(NAME); }
\"[^"\n]*["\n]		{ return(STRING); }
.                       { return(*rctext); }

%%

void rcerror(char *s)
{
  fprintf(stderr,"Corrupted configuration file: %s\n",s);
  exit(1);
}
