 
extern "C" {
#include <stdlib.h>
#include <stdio.h>
}

typedef int boolean;
typedef unsigned char byte;

#define NEXTBYTE (*ptr++)
#define IMAGESEP 0x2c
#define INTERLACEMASK 0x40
#define COLORMAPMASK 0x80
#define False 0
#define True 1
#define	FatalError(s)	{fprintf(stderr,"Fatal Error: %s\n",(s)); exit(1);}

class Gif {

private:

FILE *fp;

int BitOffset ,			/* Bit Offset of next code */
    XC , YC ,			/* Output X and Y coords of current pixel */
    Pass ,			/* Used by output routine if interlaced pic */
    OutCount ,			/* Decompressor output 'stack count' */
    RWidth, RHeight,		/* screen dimensions */
    Width, Height,		/* image dimensions */
    LeftOfs, TopOfs,		/* image offset */
    BitsPerPixel,		/* Bits per pixel, read from GIF header */
    BytesPerScanline,		/* bytes per scanline in output raster */
    ColorMapSize,		/* number of colors */
    Background,			/* background color */
    CodeSize,			/* Code size, read from GIF header */
    InitCodeSize,		/* Starting code size, used during Clear */
    Code,			/* Value returned by ReadCode */
    MaxCode,			/* limiting value for current code size */
    ClearCode,			/* GIF clear code */
    EOFCode,			/* GIF end-of-information code */
    CurCode, OldCode, InCode,	/* Decompressor variables */
    FirstFree,			/* First free code, generated per GIF spec */
    FreeCode,			/* Decompressor, next free slot in hash table */
    FinChar,			/* Decompressor variable */
    BitMask,			/* AND mask for data size */
    ReadMask;			/* Code AND mask for current code size */
    
boolean Interlace, HasColormap;
boolean Verbose;

byte *Image;			/* The address of the start of image data */	
byte *RawGIF;			/* The heap array to hold it, raw */
byte *Raster;			/* The raster data stream, unblocked */

    /* The hash table used by the decompressor */
int Prefix[4096];
int Suffix[4096];

    /* An output array used by the decompressor */
int OutCode[1025];

    /* The color map, read from the GIF header */
byte Red[256], Green[256], Blue[256], used[256];
int  numused,numcols;

static char *id;

	int ReadCode(void);
	void AddToPixel(byte Index);
public:
	Gif(void){BitOffset = 0; XC = 0; YC = 0; Pass = 0; OutCount = 0;Verbose=False;}		
	void Load(const char *fname);
	void Load(FILE *fileptr);
	void SetPalette(void);

	/* Data access methods */
	byte *GetPtr(void){ return Image;}
	int GetWidth(void){ return Width;}
	int GetHeight(void){ return Height;}

}; //end of class Gif


