/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Linux SVGA graphics driver.
*/

#include "fly.h"
#include "grx.h"
#include "svga.h"


#define GRV_STATS	0x0001
#define INITED		0x1000

LOCAL_FUNC int FAR
GrvSetPalette (int index, long c)
{
	svga_palette (index, C_RGB_R (c), C_RGB_G (c), C_RGB_B (c));
	return (0);
}

LOCAL_FUNC int FAR
GrvOptions (char *options)
{
	if (get_arg (options, "stats"))
		Gr->flags |= GRV_STATS;

	return (0);
}

LOCAL_FUNC int FAR
GrvInit (DEVICE *dev, char *options)
{
	int	i;
	int	row;

	if (GrvOptions (options))
		return (1);

	if (0 == dev->sizex || 0 == dev->sizey) {
		LogPrintf ("Bad WxH in .vmd file\n");
		return (1);
	}

	if (0 == dev->mode) {
		LogPrintf ("Must have video mode in .vmd file\n");
		return (1);
	}

	svga_init (dev->mode, dev->sizex, dev->sizey, dev->sizex);

	vSetWriteMode (T_MSET);
	GrvSetPalette (CC_BLACK, C_BLACK);

	for (i = 0; i < dev->npages; ++i) {
		vSetActive (i);
		for (row = 0; row < dev->sizey; ++row) {
			Gr->MoveTo (0, row);
			Gr->DrawTo (dev->sizex-1, row, st.colors[CC_BLACK]);
		}
	}

	vSetActive (0);

	Gr->flags |= INITED;

	return (0);
}

LOCAL_FUNC void FAR
GrvTerm (DEVICE *dev)
{
	if (!(Gr->flags & INITED))
		return;
	Gr->flags &= ~INITED;

	if (Gr->flags & GRV_STATS)
		LogStats ();
	svga_term ();
}

struct GrxExtra svgaExtra = {
	svga_GetMouse,
	svga_Kread
};

struct GrDriver NEAR GrSVGA = {
	"GrSVGA",
	0,
	&svgaExtra,	/* extra */
	0,
	GrvInit,
	GrvTerm,
	vMoveTo,
	vDrawTo,
	vSetVisual,
	vSetActive,
	0,	/* GrvClear() too slow */
	vSetWriteMode,
	GrvSetPalette,
	vEllipse,
	0,	/* Flush */
	0	/* Shutters */
};
#undef GRV_STATS
#undef INITED
