/* wild.c */


/* wild card routine(s) created by Lawrence Foard */
#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "interface.h"
#include "globals.h"

char *wptr[10];
int wlen[10];
static char wbuff[BUFFER_LEN];

static char *lwptr[10];
static int lwlen[10];
static char lwbuff[BUFFER_LEN];

int wild(s, d, p, os)
    char *s;
    char *d;
    int p;			/* what argument are we on now? */
    int os;			/* true if just came from wild card state */
{
  switch (*s) {
    case '?':			/* match any character in d, note end of
				 * string is considered a match */
      /* if just in nonwildcard state record location of change */
      if (!os && (p < 10))
	wptr[p] = d;
      return (wild(s + 1, (*d) ? d + 1 : d, p, 1));
    case '*':			/* match a range of characters */
      if (!os && (p < 10)) {
	wptr[p] = d;
      }
      return (wild(s + 1, d, p, 1) || ((*d) ? wild(s, d + 1, p, 1) : 0));
    default:
      if (os && (p < 10)) {
	wlen[p] = d - wptr[p];
	p++;
      }
      return ((DOWNCASE(*s) != DOWNCASE(*d)) ? 0 :
	      ((*s) ? wild(s + 1, d + 1, p, 0) : 1));
  }
}

int wild_match(s, d)
    char *s;
    char *d;
{
  /* s is a wildcard pattern. Return 1 if d matches it. */

  int a;
  for (a = 0; a < 10; a++)
    wptr[a] = NULL;

  switch (*s) {
    case '>':
      s++;
      /* if both first letters are #'s then numeric compare */
      if ((isascii(s[0]) && isdigit(s[0])) || (*s == '-'))
	return (atoi(s) < atoi(d));
      else
	return (strcmp(s, d) < 0);
    case '<':
      s++;
      if ((isascii(s[0]) && isdigit(s[0])) || (*s == '-'))
	return (atoi(s) > atoi(d));
      else
	return (strcmp(s, d) > 0);
    default:
      if (wild(s, d, 0, 0)) {
	int b;
	char *e, *f = wbuff;
	for (a = 0; a < 10; a++)
	  if ((e = wptr[a]) != NULL) {
	    wptr[a] = f;
	    for (b = wlen[a]; b--; *f++ = *e++) ;
	    *f++ = 0;
	  }
	return (1);
      } else
	return (0);
  }
}

int local_wild(s, d, p, os)
    char *s;
    char *d;
    int p;			/* what argument are we on now? */
    int os;			/* true if just came from wild card state */
{
  switch (*s) {
    case '?':			/* match any character in d, note end of
				 * string is considered a match */
      /* if just in nonwildcard state record location of change */
      if (!os && (p < 10))
	lwptr[p] = d;
      return (local_wild(s + 1, (*d) ? d + 1 : d, p, 1));
    case '*':			/* match a range of characters */
      if (!os && (p < 10)) {
	lwptr[p] = d;
      }
      return (local_wild(s + 1, d, p, 1) || 
	      ((*d) ? local_wild(s, d + 1, p, 1) : 0));
    default:
      if (os && (p < 10)) {
	lwlen[p] = d - lwptr[p];
	p++;
      }
      return ((DOWNCASE(*s) != DOWNCASE(*d)) ? 0 :
	      ((*s) ? local_wild(s + 1, d + 1, p, 0) : 1));
  }
}

int local_wild_match(s, d)
    char *s;
    char *d;
{
  /* s is a wildcard pattern. Return 1 if d matches it. */

  int a;
  for (a = 0; a < 10; a++)
    lwptr[a] = NULL;

  switch (*s) {
    case '>':
      s++;
      /* if both first letters are #'s then numeric compare */
      if ((isascii(s[0]) && isdigit(s[0])) || (*s == '-'))
	return (atoi(s) < atoi(d));
      else
	return (strcmp(s, d) < 0);
    case '<':
      s++;
      if ((isascii(s[0]) && isdigit(s[0])) || (*s == '-'))
	return (atoi(s) > atoi(d));
      else
	return (strcmp(s, d) > 0);
    default:
      if (local_wild(s, d, 0, 0)) {
	int b;
	char *e, *f = lwbuff;
	for (a = 0; a < 10; a++)
	  if ((e = lwptr[a]) != NULL) {
	    lwptr[a] = f;
	    for (b = lwlen[a]; b--; *f++ = *e++) ;
	    *f++ = 0;
	  }
	return (1);
      } else
	return (0);
  }
}
