/* timer.c */

/* Subroutines for timed events */
#include "copyright.h"

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#ifdef XENIX
#include <sys/signal.h>
#else
#include <signal.h>
#endif				/* xenix */

#include "config.h"
#include "db.h"
#include "interface.h"
#include "match.h"
#include "externs.h"
static int alarm_triggered = 0;
extern char ccom[BUFFER_LEN];
extern void inactivity_check();
extern void log_check();

void alarm_handler()
{
  alarm_triggered = 1;
  signal(SIGALRM, (void *) alarm_handler);
}

void init_timer()
{
  signal(SIGALRM, (void *) alarm_handler);
  signal(SIGHUP, (void *) alarm_handler);
  alarm(1);
}

void dispatch()
{
/*  void do_garbage(); */

  extern void fork_and_dump();

  /* this routine can be used to poll from interface.c */
  if (!alarm_triggered)
    return;
  alarm_triggered = 0;
  do_second();

  {
    static int ticks = FIXUP_INTERVAL;
    if (!ticks--) {
      ticks = FIXUP_INTERVAL;
#ifdef DESTROY
      /* Free list reconstruction */
      strcpy(ccom, "dbck");
      do_dbck(NOTHING);
#endif				/* DESTROY */
#ifdef IDLE_TIMEOUT
      inactivity_check();
#endif				/* IDLE_TIMEOUT */
    }
  }

  /* Database dump routines */
  if (options.dump_counter-- <= 0) {
    options.dump_counter = options.dump_interval;
    strcpy(ccom, "dump");
    fork_and_dump();
  }

#ifdef RWHO_SEND
  if (options.rwho_counter-- <= 0) {
    options.rwho_counter = options.rwho_interval;
    strcpy(ccom, "update_rwho");
    rwho_update();
  }
#endif

  /* reset alarm */
  alarm(1);
}
