/* interface.h */

#include "copyright.h"
#include "config.h"
#include "db.h"

/* these symbols must be defined by the interface */
extern void notify_check();
extern int shutdown_flag;	/* if non-zero, interface should shut down */
extern void emergency_shutdown();
extern void boot_off();		/* remove a player */
extern void raw_broadcast();
extern void raw_notify();
extern dbref short_page();
extern void do_doing();
/* the following symbols are provided by game.c */

/* max length of command argument to process_command */
#define MAX_COMMAND_LEN 1024
#define BUFFER_LEN ((MAX_COMMAND_LEN)*4)

#define SBUF_LEN 32

extern void process_command();

/* from player.c */
extern dbref create_player();
extern dbref connect_player();
extern void check_last();

/* from look.c */
extern void do_look_around();

extern int init_game();
extern void dump_database();
extern void panic();
extern int depth;

