/* externs.h */
/* $Id: externs.h,v 1.16 1993/03/21 01:46:32 nils Exp $ */
/* for doing prototypes */
/* #undef __STDC__ */
/* #define TEST_MALLOC */
#ifdef __STDC__
#define P(x) x
#else
#define P(x) ()
#endif


#include "db.h"
/* for the NALLOC *'s: */
#include "nalloc.h"
/* for the text_queue and descriptor_list and stuff */
#include "net.h"
/* for struct timeval */
#include <sys/time.h>
/* for FIFO * */
#include "fifo.h"
/* for struct sockaddr */
#ifndef SOCK_STREAM
#include <sys/socket.h>
#endif
/* for struct stat */
#ifndef S_IFMT
#include <sys/stat.h>
#endif

#ifndef FD_SETSIZE
#include <sys/types.h>
#endif

#ifdef NeXT
#include <sys/wait.h>
#endif
#include "log.h"
#ifdef USE_SPACE /* Include added by Michael Majere */
#include "space.h"
#endif


/*
#ifdef ultrix
#define signal_type void
extern void setlinebuf();
#endif

#ifndef signal_type
#define signal_type int
#endif
*/
#define signal_type void


/* and all the definitions */
/* From admin.c */
extern dbref match_controlled P((dbref, char *, int));
extern void calc_stats P((dbref, int *, int *, int *));
extern void do_allquota P((dbref, char *));
extern void do_boot P((dbref, char *));
extern void do_chownall P((dbref, char *, char *));
extern void do_force P((dbref, char *, char *));
extern void do_join P((dbref, char *));
extern void do_newpassword P((dbref, char *, char *));
extern void do_poor P((dbref, char *));
extern void do_pstats P((dbref, char *));
extern void do_register_purge P((dbref));
extern void do_search P((dbref, char *, char *));
extern void do_stats P((dbref, char *));
extern void do_summon P((dbref, char *));
extern void do_teleport P((dbref, char *, char *));
extern void do_wipeout P((dbref, char *, char *));
extern int owns_stuff P((dbref));
extern int try_force P((dbref, char *));

/* From boolexp.c */
extern int eval_boolexp P((dbref, dbref, char *, dbref));
extern char *process_lock P((dbref, char *));
extern char *unprocess_lock P((dbref, char *));

/* From bsd.c */
extern int loading_db;
extern void do_ctrace P((dbref));
extern void add_to_queue P((struct text_queue *, char *, int));
extern char *addrout P((long));
extern void announce_connect P((dbref));
extern void announce_disconnect P((dbref));
/* extern int bailout P((int, int, struct sigcontext *)); */
extern int boot_off P((dbref));
extern void clearstrings P((struct descriptor_data *));
extern void close_sockets P((void));
extern void connect_message P((struct descriptor_data *,char *,int));
extern signal_type dump_status P((int));
extern void dump_users P((dbref, char *, char *, struct descriptor_data *));
extern void emergency_shutdown P((void));
extern int flush_queue P((struct text_queue *, int));
extern void freeqs P((struct descriptor_data *));
extern int getdtablesize P((void));
extern void init_args P((int, char **));
extern void init_io P((void));
extern struct descriptor_data *initializesock P((int,struct sockaddr_in *,char *));
extern char *make_guest P((struct descriptor_data *));
extern void make_nonblocking P((int));
extern int make_socket P((int));
extern struct text_block *make_text_block P((char *, int));
extern void mark_free P((int));
extern struct timeval msec_add P((struct timeval, int));
extern int msec_diff P((struct timeval, struct timeval));
extern struct descriptor_data *new_connection P(());
extern void process_commands P((void));
extern int process_output P((struct descriptor_data *));
extern int queue_string P((struct descriptor_data *,char *));
extern int queue_write P((struct descriptor_data *,char *, int));
extern void raw_notify P((dbref, char *));
extern void remove_muse_pid P((void));
extern void save_muse_pid P((void));
extern void set_signals P((void));
extern void shovechars P((int));
extern void shutdownsock P((struct descriptor_data *));
extern void sig_handler P((int));
extern char *time_format_1 P((long));
extern char *time_format_2 P((long));
extern struct timeval timeval_sub P((struct timeval, struct timeval));
extern struct timeval update_quotas P((struct timeval, struct timeval));
extern void welcome_user P((struct descriptor_data *));
extern char *wholev P((dbref, int, int));

/* From com.c */
extern void com_send P((char *,char *));
extern void do_com P((dbref, char *, char *));
extern void do_channel P((dbref, char *));

/* From compress.c */
extern char *compress P((char *));
extern char *uncompress P((char *));

/* From cque.c */
extern void do_haltall P((dbref));
extern void big_que P((dbref, char *, dbref));
extern void do_halt P((dbref, char *));
extern void do_queue P((dbref));
extern void do_second P((void));
extern int do_top P((void));
extern void parse_que P((dbref, char *, dbref));
extern int test_top P((void));
extern void wait_que P((dbref, int, char *, dbref));

/* From create.c */
extern void do_clone P((dbref, char *,char *));
extern void do_create P((dbref, char *, int));
extern void do_dig P((dbref, char *, char **));
extern void do_link P((dbref, char *, char *));
extern void do_zlink P((dbref, char *, char *));
extern void do_unzlink P((dbref, char *));
extern void do_ulink P((dbref, char *));
extern void do_open P((dbref, char *, char *, dbref));
extern void do_robot P((dbref, char *, char *));

/* From db.c */
extern void db_set_read P((FILE *));
extern void load_more_db P((void));
extern void free_database P((void));
extern void init_attributes P((void));
extern char *unparse_attr P((ATTR *, int dep));
extern void putlist P((FILE *, dbref *));
extern dbref *getlist P((FILE *));
extern ALIST *AL_GETPTR P((ALIST *));
extern ALIST *AL_MAKE P((ATTR *, ALIST *, char *));
extern struct boolatr *alloc_atr P((ATTR *, char *));
extern void atr_add P((dbref, ATTR *, char *));
extern void atr_clr P((dbref, ATTR *));
extern ATTR *builtin_atr P((int));
extern void atr_collect P((dbref));
extern void atr_cpy_noninh P((dbref, dbref));
extern void atr_free P((dbref));
extern char *atr_get P((dbref, ATTR *));
extern ATTR *atr_str P((dbref, dbref, char *));
extern void db_free P((void));
extern dbref db_read P((FILE *));
extern dbref db_write P((FILE *));
extern int db_write_object P((FILE *, dbref));
extern int get_list P((FILE *, dbref, int));
extern void getboolexp P((dbref, FILE *));
extern long getlong P((FILE *));
extern dbref getref P((FILE *));
extern void init_protobuf P((void));
extern dbref new_object P((void));
extern dbref parse_dbref P((char *));
extern void put_long P((FILE *, long));
extern void putref P((FILE *, dbref));
extern object_flag_type upgrade_flags P((int, dbref, object_flag_type));

/* From dbtop.c */
extern void dbtop_internal P((dbref, int (*)(), char *));
extern void do_dbtop P((dbref, char *));
extern int dt_cont P((dbref));
extern int dt_cred P((dbref));
extern int dt_exits P((dbref));
extern int dt_obj P((dbref));
extern int dt_quota P((dbref));

/* From decompress.c */

/* From destroy.c */
extern void do_check P((dbref, char *));
extern void do_incremental P((void));
extern void do_dbck P((dbref));
extern void do_empty P((dbref));
extern void fix_free_list P((void));
extern dbref free_get P((void));
extern void do_undestroy P((dbref,char *));

/* From eval.c */
extern char *wptr[10];
extern void do_fun P((char **, char *, dbref, dbref));
extern void exec P((char **, char *, dbref, dbref, int));
extern void fun_add P((char *, char **));
extern void fun_class P((char *, char **, dbref));
extern void fun_comp P((char *, char **));
extern void fun_con P((char *, char **,dbref, dbref));
extern void fun_credits P((char *, char **, dbref));
extern void fun_delete P((char *, char **));
extern void fun_div P((char *, char **));
extern void fun_exit P((char *, char **, dbref, dbref));
extern void fun_extract P((char *, char **));
extern void fun_first P((char *, char **));
extern void fun_flags P((char *, char **, dbref, dbref));
extern void fun_get P((char *, char **, dbref, dbref, int));
extern void fun_loc P((char *, char **, dbref, dbref));
extern void fun_match P((char *, char **));
extern void fun_mid P((char *, char **));
extern void fun_mod P((char *, char **));
extern void fun_mul P((char *, char **));
extern void fun_name P((char *, char **, dbref));
extern void fun_next P((char *, char **, dbref, dbref));
extern void fun_num P((char *, char **, dbref));
extern void fun_owner P((char *, char **, dbref));
extern void fun_pos P((char *, char **));
extern void fun_quota P((char *, char **, dbref));
extern void fun_quota_left P((char *, char **, dbref));
extern void fun_rand P((char *, char **));
extern void fun_remove P((char *, char **));
extern void fun_rest P((char *, char **));
extern void fun_s P((char *, char **, dbref, dbref));
extern void fun_scomp P((char *, char **));
extern void fun_stat P((char *, char **, dbref));
extern void fun_strlen P((char *, char **));
extern void fun_time P((char *, char **, dbref, dbref, int));
extern void fun_v P((char *, char **, dbref, dbref));
extern void func_zerolev P((void));
extern dbref match_thing P((dbref, char *));
extern dbref next_exit P((dbref, dbref));
extern char *parse_up P((char **, int));
extern int mem_usage P((dbref));

/* From fifo.c */
extern void fi_close P((FIFO *));
extern void fi_flush P((FIFO *));
extern char *fi_gets P((FIFO *, char *, int));
extern int fi_rread P((FIFO *, char **));
extern int fi_write P((FIFO *, char *, int));

/* From game.c */
extern void exit_nicely P((int));
extern void dest_info P((dbref, dbref));
extern int Live_Player P((dbref));
extern int Live_Puppet P((dbref));
extern int Listener P((dbref));
extern int Commer P((dbref));
extern int Hearer P((dbref));
extern int Active P((dbref));
extern int atr_match P((dbref, dbref, int, char *));
extern char **do_argbee P((dbref, char *, dbref, char **, char *));
extern char *do_argtwo P((dbref, char *, dbref, char *));
extern void do_dump P((dbref));
extern void do_purge P((dbref));
extern void do_restart P((void));
extern void do_shutdown P((dbref));
extern void dump_database P((void));
extern void fork_and_dump P((void));
extern int init_game P((char *, char *));
extern int list_check P((dbref, dbref, int, char *));
extern void no_dbdump P((void));
extern void notify P((dbref, char *));
extern void panic P((char *));
extern void process_command P((dbref, char *, dbref));
extern void report P((void));
extern int unsafe;
extern dbref get_zone P((dbref));

/* From help.c */
extern void do_text P((dbref, char *, char *));
extern void do_help P((dbref, char *, char *, char *, char *));
extern void spit_file P((dbref, char *, FILE *));

/* From inherit.c */
extern void do_undefattr P((dbref, char *));
extern int is_a P((dbref, dbref));
extern void do_defattr P((dbref, char *, char *));
extern void do_addparent P((dbref, char *, char *));
extern void do_delparent P((dbref, char *, char *));
extern void put_atrdefs P((FILE *, ATRDEF *));
extern ATRDEF *get_atrdefs P((FILE *, ATRDEF *));

/* From look.c */
extern char *flag_description P((dbref));
extern struct all_atr_list *all_attributes P((dbref));
extern void do_examine P((dbref, char *));
extern void do_find P((dbref, char *));
extern void do_inventory P((dbref));
extern void do_laston P((dbref, char *));
extern void do_look_around P((dbref));
extern void do_look_at P((dbref, char *));
extern void do_score P((dbref));
extern void do_sweep P((dbref));
extern void do_whereis P((dbref, char *));
extern void look_atrs P((dbref, dbref));
extern void look_room P((dbref, dbref));
extern char *eval_sweep P((dbref));

/* From mail.c */
extern void check_mail P((dbref));
extern void do_mail P((dbref, char *, char *));
extern void init_mail P((void));
extern void send_mail P((dbref, dbref, char *));
extern void write_mail P((FILE *));
extern void read_mail P((FILE *));

/* From match.c */
extern void init_match P((dbref, char *, int));
extern void init_match_check_keys P((dbref, char *, int));
extern int is_prefix P((char *, char *));
extern dbref last_match_result P((void));
extern void match_absolute P((void));
extern void match_everything P((void));
extern void match_exit P((void));
extern void match_here P((void));
extern void match_me P((void));
extern void match_neighbor P((void));
extern void match_perfect P((void));
extern void match_player P((void));
extern void match_possession P((void));
extern dbref match_result P((void));
extern dbref noisy_match_result P((void));
extern dbref pref_match P((dbref, dbref, char *));
extern void store_it P((dbref));

/* From move.c */
extern int can_move P((dbref, char *));
extern void do_drop P((dbref, char *));
extern void do_enter P((dbref, char *));
extern void do_get P((dbref, char *));
extern void do_leave P((dbref));
extern void do_move P((dbref, char *));
extern void enter_room P((dbref, dbref));
extern void maybe_dropto P((dbref, dbref));
extern void moveit P((dbref, dbref));
extern void moveto P((dbref, dbref));
extern void safe_tel P((dbref, dbref));
extern void self_tel P((dbref, dbref));
extern void send_contents P((dbref, dbref));
extern dbref inside P((dbref));
extern dbref get_room P((dbref));

/* From nalloc.c */
extern char *glurpdup P((char *));
extern char *bigalloc P((int));
extern void bigfree P((void *));
extern int findit P((void *));

/*#ifndef GNU_OPTIMIZE
extern void memcpy P((void *, void *, int));
#endif*/

extern char *memset P((char *, int, int));

extern void *na_alloc P((NALLOC *, int));
extern void na_clear P((NALLOC *));
extern void na_close P((NALLOC *));
extern void na_free P((NALLOC *, void *));
extern char *na_get P((NALLOC *));
extern void na_giveback P((NALLOC *, int));
extern NALLOC *na_open P((int));
extern void na_unalloc P((NALLOC *, void *));

/* From pcmds.c */
extern void do_version P((dbref));
extern void do_uptime P((dbref));
extern void do_cmdav P((dbref));
extern void add_freetime P((long));
extern void inc_pcmdc P((void));
extern void inc_qcmdc P((void));

/* From player.c */
extern dbref *match_things P((dbref, char *));
extern ptype name_to_pow P((char *));
extern void do_powers P((dbref, char *));
extern void do_misc P((dbref, char *, char *));
extern void do_empower P((dbref, char *, char *));
extern dbref connect_player P((char *, char *));
extern dbref create_guest P((char *, char *));
extern dbref create_player P((char *, char *, int));
extern void destroy_guest P((dbref));
extern void destroy_player P((dbref));
extern void do_class P((dbref, char *, char *));
extern void do_nopow_class P((dbref, char *, char *));
extern void do_money P((dbref, char *, char *));
extern void do_nuke P((dbref, char *));
extern void do_password P((dbref, char *, char *));
extern void do_pcreate P((dbref, char *, char *));
extern void do_quota P((dbref, char *, char *));
extern char *get_class P((dbref));
extern dbref *lookup_players P((dbref, char *));

/* From player_list.c */
extern void add_player P((dbref));
extern int check_spoof P((char *));
extern void clear_players P((void));
extern void delete_player P((dbref));
extern dbref lookup_player P((char *));

/* from editor.c */
extern char *make_pfile P((dbref, char *));
extern void do_mkdir P((dbref, char *));
extern void do_ls P((dbref, char *));
extern void edit_command P((struct descriptor_data *, dbref, char *));
extern void do_editfile P((dbref, char *));

/* From predicates.c */
extern dbref starts_with_player P((char *));
extern int can_see_atr P((dbref, dbref, ATTR *));
extern int can_set_atr P((dbref, dbref, ATTR *));
extern void push_list P((dbref **, dbref));
extern void remove_first_list P((dbref **, dbref));
extern int check_zone P((dbref, dbref, dbref, int));
extern int Levnm P((dbref));
extern int inf_quota P((dbref));
extern int inf_mon P((dbref));
extern int Level P((dbref));
extern void add_quota P((dbref, int));
extern int can_link P((dbref, dbref, int));
extern int can_link_to P((dbref, dbref, int));
extern int can_pay_fees P((dbref, int, int));
extern int can_see P((dbref, dbref, int));
extern int controls P((dbref, dbref, int));
extern int could_doit P((dbref, dbref, ATTR *));
extern void did_it P((dbref, dbref, ATTR *, char *, ATTR *, char *, ATTR *));
extern void giveto P((dbref, int));
extern int my_index P((char *, int));
extern int ok_attribute_name P((char *));
extern int ok_name P((char *));
extern int ok_password P((char *));
extern int ok_player_name P((char *));
extern int pay_quota P((dbref, int));
extern int payfor P((dbref, int));
extern int power P((dbref, int));
extern void pronoun_substitute P((char *, dbref, char *, dbref));
extern void sstrcat P((char *, char *, char *));
extern int sub_quota P((dbref, int));
#ifndef NO_PROTO_VARARGS
extern char *tprintf P((char *, ...));
#endif

/* From prog.c */
extern void do_switch P((dbref, char *, char **, dbref));
extern void do_foreach P((dbref, char *, char *, dbref));
extern void do_trigger P((dbref, char *, char **));
extern void do_decompile P((dbref, char *));

/* From rob.c */
extern void do_giveto P((dbref, char *, char *));
extern void do_give P((dbref, char *, char *));
extern void do_kill P((dbref, char *, int));
extern void do_slay P((dbref, char *));

/* From set.c */
/*extern void make_hearing P((dbref));
extern void make_deaf P((dbref));*/
void mark_hearing P((dbref));
void check_hearing P((void));
extern void do_haven P((dbref, char *));
extern char *crypt P((char *, char *));
extern void do_away P((dbref, char *));
extern void do_chown P((dbref, char *, char *));
extern void do_cut P((dbref, char *));
extern void do_describe P((dbref, char *, char *));
extern void destroy_obj P((dbref, int));
extern void do_destroy P((dbref, char *));
extern void do_edit P((dbref, char *, char **));
extern void do_fail P((dbref, char *, char *));
extern void do_hide P((dbref));
extern void do_idle P((dbref, char *));
extern void do_lock P((dbref, char *, char *));
extern void do_name P((dbref, char *, char *));
extern void do_ofail P((dbref, char *, char *));
extern void do_osuccess P((dbref, char *, char *));
extern void do_set P((dbref, char *, char *));
extern void do_success P((dbref, char *, char *));
extern void do_unhide P((dbref));
extern void do_unlink P((dbref, char *));
extern void do_unlock P((dbref, char *));
extern int parse_attrib P((dbref, char *, dbref *, ATTR **, int));
extern int test_set P((dbref, char *, char *, char *));

/* From speech.c */
extern void do_use P((dbref, char *));
extern void do_announce P((dbref, char *, char *));
extern void do_broadcast P((dbref, char *, char *));
extern void do_emit P((dbref, char *, char *, int));
extern void do_gripe P((dbref, char *, char *));
extern void do_page P((dbref, char *, char *));
extern void do_general_emit P((dbref, char *, char *, int));
extern int can_emit_msg P((dbref, dbref, char *));
extern void do_pose P((dbref, char *, char *, int));
extern void do_say P((dbref, char *, char *));
extern void do_whisper P((dbref, char *, char *));
extern void notify_in P((dbref, dbref, char *));
extern char *reconstruct_message P((char *, char *));
extern void snotify P((dbref, char *));
extern int sp_ok P((dbref));
extern char *spname P((dbref));

/* From stringutil.c */
extern char *str_index P((char *, int));
extern int string_compare P((char *, char *));
extern char *string_match P((char *, char *));
extern int string_prefix P((char *, char *));
extern char to_lower P((int));
extern char to_upper P((int));

/* From timer.c */
extern signal_type alarm_handler P((int));
extern void dispatch P((void));
extern void do_age P((void));
extern void init_timer P((void));

/* From unparse.c */
extern char *unparse_object_a P((dbref, dbref));
extern char *unparse_flags P((dbref));
extern char *unparse_object P((dbref, dbref));

/* From utils.c */
extern dbref find_entrance P((dbref));
extern int member P((dbref, dbref));
extern dbref remove_first P((dbref, dbref));
extern dbref reverse P((dbref));
extern char *mktm P((long, char *, dbref));

/* From wild.c */
extern int wild P((char *, char *, int, int));
extern int wild_match P((char *, char *));

/* From log.c */
extern void com_errlog P((char *));
extern void log_gripe P((char *));
void do_mailhuh P((dbref));
void log_error P((char *));
void log_important P((char *));
void log_io P((char *));
void log_sensitive P((char *));
void log_huh P((char *));

/* From powerlist.c */
extern char *class_to_name P((int));
extern int name_to_class P((char *));
extern int class_to_list_pos P((int));

/* From powers.c */
extern void put_powers P((FILE *, dbref));
extern void get_powers P((dbref, char *));
extern int old_to_new_class P((int));
extern void set_pow P((dbref, int, int));
extern int has_pow P((dbref, dbref, int));
extern int get_pow P((dbref, int));

/* newconc.c */
extern long make_concid P((void));
extern void do_becomeconc P((struct descriptor_data *, char *));
extern void do_makeid P((struct descriptor_data *));
extern void do_connectid P((struct descriptor_data *, long, char *));
extern void do_killid P((struct descriptor_data *, long));

#ifdef USE_RWHO
/* clilib.c */
extern int rwhocli_setup P((char *, char *, char *, char *));
extern int rwhocli_userlogin P((char *, char *, time_t));
extern int rwhocli_userlogout P((char *));
extern int rwhocli_pingalive P((void));
extern int rwhocli_shutdown P((void));

/* rwho.c */
extern void do_rwho P((dbref, char *));
extern void dump_rusers P((dbref, char *, char *));
extern void rwho_update P((void));
#endif

/* external to netmud */
extern int tolower P((int));
/*extern int strlen P((char *));*/
extern void abort P((void));
/*extern int atoi P((char *));*/
extern int rand P((void));
/* HPUX-MOD */
/* extern int time P((long *)); */
/* extern int getpid P((void)); */
extern time_t time P((time_t *));
#ifdef NeXT
#define pid_t int
#endif
extern pid_t getpid P((void));
/* */
extern void exit P((int));
/* HPUX-MOD */
/* extern void close P((int)); */
/* extern void unlink P((char *)); */
extern int close P((int));
extern int unlink P((char *));
/* */
/*extern void perror P((char *));*/
extern int dup2 P((int, int));
#ifndef NeXT
/* extern void gettimeofday P((struct timeval *, struct timezone *)); 
extern int setsockopt P((int, int, int, char *, int));
*/
#endif
extern int select P((int,struct fd_set *,struct fd_set *, struct fd_set *, struct timeval *));
extern int accept P((int, struct sockaddr *, int *));
extern int shutdown P((int, int));
extern char *strncpy P((char *, char *, int));
extern int socket P((int, int, int));
extern int bind P((int, struct sockaddr *, int));
extern int listen P((int, int));
extern void bcopy P((void *, void *, int));
extern void bzero P((void *, int));
extern int ffs P((int));
#if !defined(HPUX) || !defined(__STDC__)
/*
extern int fcntl P((int, int, int));
extern int open P((char *, int, int));
*/
extern int write P((int, char *, int));
extern int read P((int, char *, int));
#endif
extern int strncmp P((char *, char *, int));
extern void _exit P((int));
extern char *strcat P((char *, char *));
extern char *strncat P((char *, char *, int));
/* HPUX-MOD */
/* extern int fork P((void)); */
extern pid_t fork P((void));
/* */
/*extern int rename P((char *, char *));*/
/*extern int random P((void)); */
/* HPUX-MOD */
/* extern int wait P((int *)); 
#ifdef NeXT
extern pid_t wait P((union wait *));
#else
extern pid_t wait P((int *));
#endif
*/
/* */
/*extern long srandom P((long));*/
/*extern long atol P((char *));*/
/* HPUX-MOD */
/* extern int alarm P((int)); */
extern unsigned int alarm P((unsigned int));
/* */
extern char *sbrk P((int));
#if !defined(HPUX) || !defined(__STDC__)
/* extern int mkdir P((char *, int)); */
#endif
#ifndef getc
extern int getc P((FILE *));
#endif
#ifndef putc
/* extern void putc P((char, FILE *)); */
#endif
/* extern int stat P((char *, struct stat *));
extern int lstat P((char *, struct stat *));
*/
extern char *strchr P((char *, char));
/*#ifndef GNU_OPTIMIZE
extern char *strcpy P((char *, char *));
extern int strcmp P((char *, char *));
#endif*/
extern int strncmp P((char *, char *, int));
extern int execvp P((char *, char **));
extern void memchr P((void *, int, int));
#ifdef NeXT
extern short htons P((short));
#endif
/* extern int wait3 P((union wait *,int,int)); */
extern int vfork P((void));

#ifdef __STDC__
#include <stdlib.h>
#endif

#ifdef MALLOCDEBUG
#include "mnemosyne.h"
#endif

/*
void *dmalloc(size_t size);
void dfree(void *ptr);
*/

#define dmalloc(size)	malloc(size)
#define dfree(ptr)	free(ptr)
