/* db.h */
/* $Id: db.h,v 1.10 1993/03/21 01:46:29 nils Exp $ */

#include "config.h"

/* Warning some comments maybe out of date read with caution :) */

#ifndef __DB_H
#define __DB_H
#include <stdio.h>

#ifndef XENIX
extern void *malloc();
extern void *realloc();
extern void free();
#endif /* XENIX */

extern int depth;
#ifdef TEST_MALLOC
extern int malloc_count;
#define malloc(x) (malloc_count++, malloc(x))
#define free(x) (malloc_count--, free(x))
#endif /* TEST_MALLOC */

typedef int dbref;		/* offset into db */

#define IS(thing,type,flag) ((Typeof(thing)==type) &&\
			     (db[thing].flags & flag))

extern dbref first_free;	/* pointer to free list */
#define FIX fix_free_list()
typedef long object_flag_type;


/* flag definitions */

#define TYPE_MASK 	0xF	/* room for expansion */
#define TYPE_ROOM 	0x0
#define TYPE_THING 	0x1
#define TYPE_EXIT 	0x2
#define NOTYPE		0x7	/* no particular type */
#define TYPE_PLAYER	0x8
#define NUM_OBJ_TYPES	0x9	/* number of object types */

#define CHOWN_OK 0x20
#define DARK		0x40	/* contents of room are not printed */
#define STICKY		0x100	/* this object goes home when dropped */
#define	HAVEN		0x400	/* object can't execute commands */
#define INHERIT_POWERS	0x2000	/* gives object powers of its owner */
#define GOING		0x4000	/* object is available for recycling */
#define ACCESSED	0x8000 /* object has been accessed recently */
#define MARKED  	0x10000
#define PUPPET		0x20000
#define LINK_OK		0x40000	/* anybody can link to this room */
#define ENTER_OK	0x80000
#define SEE_OK		0x100000
#define OPAQUE		0x800000
#define QUIET		0x1000000
#define BEARING		0x8000000

/* type specific flags */
/* Thing flags */
#define THING_KEY	0x10
#define THING_LIGHT	0x80
#define THING_DEST_OK	0x200
#define THING_ZONED	0x800
#define THING_SACROK	0x1000
/* Exit flags */
#define EXIT_LIGHT	0x10
/* Player flags */
#define PLAYER_NEWBIE	0x10
#define PLAYER_SLAVE	0x80
#define PLAYER_CONNECT	0x200
#define PLAYER_MORTAL	0x800
#define PLAYER_TERSE	0x400000
#define PLAYER_NO_WALLS	0x2000000
#define PLAYER_WRAPTEXT	0x4000000

/* Room flags */
#ifdef USE_SPACE
#define ROOM_ZEROG	0x10
#endif
#define ROOM_TEMPLE	0x80
#define ROOM_JUMP_OK	0x200
#define ROOM_AUDITORIUM	0x800
#define ROOM_FLOATING	0x1000

/* end of flags */

/* macro to make set string easier to use */
#define SET(astr,bstr) do { \
		      char **__a, *__b; __a=(&(astr)); __b=(bstr); \
		      if (*__a) free(*__a); \
		      if (!__b || !*__b) *__a=NULL; \
		      else { \
			*__a = malloc(strlen(__b)+1); \
			strcpy(*__a,__b); \
		      } \
		    } while(0)
/* set macro for compressed strings */
#ifdef COMPRESS
#define SETC(a,b) SET(a,compress(b))
#else
#define SETC(a,b) SET(a,b)
#endif

/* Updates an objects age */
#define Access(x) (db[(x)].flags|=ACCESSED)
/*#define RLevel(x) (db[(x)].flags & TYPE_MASK)*/
#define Robot(x) ((Typeof(x) == TYPE_PLAYER) && ((x) != db[(x)].owner))
#define Guest(x) ((Typeof(x)==TYPE_PLAYER && *db[x].pows == CLASS_GUEST))
#define Dark(x) (((db[(x)].flags & DARK) != 0) && \
		 (Typeof(x)!=TYPE_PLAYER) && !(db[(x)].flags & PUPPET))
#define Alive(x) ((Typeof(x)==TYPE_PLAYER) ||      \
		  ((Typeof(x)==TYPE_THING) && (db[x].flags & PUPPET)))
#define Builder(x) ((db[db[(x)].owner].flags & PLAYER_BUILD) || \
		    (Typeof(x) == TYPE_PLAYER && *db[x].pows == CLASS_DIR) \
		    || Wizard(x)) 

char *atr_get();

typedef struct attr ATTR;

struct attr {
  /* name of attribute */
  char *name;            
  int flags;
  /* presently not emplemented */
  dbref obj;			/* object where this is defined. NOTHING for
				 * builtin. */
  int refcount;			/* number of things that reference us. */
};


/* Attribute flags */
#define AF_OSEE   1 /* players other than owner can see it */
#define AF_DARK   2 /* No one can see it */
#define AF_WIZARD 4 /* only wizards can change it */
#define AF_UNIMP  8 /* not important -- don't save it in the db */
#define AF_NOMOD  16 /* not even wizards can't modify this */
#define AF_DATE   32 /* date stored in universal longint form */
#define AF_INHERIT 64 /* value inherited by childern */
#define AF_LOCK	  128 /* interpreted as a boolean expression */
#define AF_FUNC   256 /* this is a user defined function */
#ifdef USE_SPACE      /*  Atrib Flag added by Michael Majere  */ 
#define AF_SPACE 512 /*  used with space() */
#endif

extern ATTR *A_OSUCC;
extern ATTR *A_OFAIL;
extern ATTR *A_FAIL;
extern ATTR *A_SUCC;
extern ATTR *A_PASS;
extern ATTR *A_DESC;
extern ATTR *A_SEX;
extern ATTR *A_ODROP;
extern ATTR *A_DROP;
extern ATTR *A_OKILL;
extern ATTR *A_KILL;
extern ATTR *A_ASUCC;
extern ATTR *A_AFAIL;
extern ATTR *A_ADROP;
extern ATTR *A_AKILL;
extern ATTR *A_USE;
extern ATTR *A_OUSE;
extern ATTR *A_AUSE;
extern ATTR *A_CHARGES;
extern ATTR *A_RUNOUT;
extern ATTR *A_STARTUP;
extern ATTR *A_ACLONE;
extern ATTR *A_APAY;
extern ATTR *A_OPAY;
extern ATTR *A_PAY;
extern ATTR *A_COST;
extern ATTR *A_RAND;
extern ATTR *A_LISTEN;
extern ATTR *A_AAHEAR;
extern ATTR *A_AMHEAR;
extern ATTR *A_AHEAR;
extern ATTR *A_LAST;
extern ATTR *A_QUEUE;
extern ATTR *A_IDESC;
extern ATTR *A_ENTER;
extern ATTR *A_OENTER;
extern ATTR *A_AENTER;
extern ATTR *A_ADESC;
extern ATTR *A_ODESC;
extern ATTR *A_RQUOTA;
extern ATTR *A_IDLE;
extern ATTR *A_AWAY;
extern ATTR *A_MAILK;
extern ATTR *A_ALIAS;
extern ATTR *A_EFAIL;
extern ATTR *A_OEFAIL;
extern ATTR *A_AEFAIL;
extern ATTR *A_IT;
extern ATTR *A_LEAVE;
extern ATTR *A_OLEAVE;
extern ATTR *A_ALEAVE;
extern ATTR *A_CHANNEL;
extern ATTR *A_QUOTA;
extern ATTR *A_PENNIES;
extern ATTR *A_HUHTO;
extern ATTR *A_HAVEN;
#ifdef EMAIL_CREATE
extern ATTR *A_EMAIL;
#endif
extern ATTR *A_TZ;
extern ATTR *A_DOOMSDAY;
extern ATTR *A_MOVE;
extern ATTR *A_AMOVE;
extern ATTR *A_OMOVE;
extern ATTR *A_LOCK;
extern ATTR *A_ELOCK;
extern ATTR *A_ULOCK;
extern ATTR *A_UFAIL;
extern ATTR *A_OUFAIL;
extern ATTR *A_AUFAIL;
extern ATTR *A_OCONN;
extern ATTR *A_ACONN;
extern ATTR *A_ODISC;
extern ATTR *A_ADISC;
extern ATTR *A_COLUMNS;
extern ATTR *A_WHOFLAGS;
extern ATTR *A_WHONAMES;
extern ATTR *A_APAGE;
extern ATTR *A_APEMIT;
extern ATTR *A_AWHISPER;
extern ATTR *A_LLOCK;
extern ATTR *A_LFAIL;
extern ATTR *A_OLFAIL;
extern ATTR *A_ALFAIL;
extern ATTR *A_SLOCK;
extern ATTR *A_SFAIL;
extern ATTR *A_OSFAIL;
extern ATTR *A_ASFAIL;

#ifdef USE_SPACE  /*  Registers added by Michael Majere  */
extern ATTR *A_ASHIP;
extern ATTR *A_SECTOR;
extern ATTR *A_MASS;
extern ATTR *A_RADIUS;
extern ATTR *A_THRUST;
extern ATTR *A_RATING;
extern ATTR *A_EFFICIENCY;
extern ATTR *A_FUEL;
extern ATTR *A_ACCELERATION;
extern ATTR *A_VISMULT;
extern ATTR *A_PWRGEN;
extern ATTR *A_PWRFUEL;
extern ATTR *A_SPRSTR;
extern ATTR *A_HULL;
extern ATTR *A_RECOVER;
extern ATTR *A_TYPE;
extern ATTR *A_ENERGY;
extern ATTR *A_LINPOSX;
extern ATTR *A_LINPOSY;
extern ATTR *A_LINPOSZ;
extern ATTR *A_LINVELX;
extern ATTR *A_LINVELY;
extern ATTR *A_LINVELZ;
extern ATTR *A_LINACCX;
extern ATTR *A_LINACCY;
extern ATTR *A_LINACCZ;
extern ATTR *A_ANGPOSX;
extern ATTR *A_ANGPOSY;
extern ATTR *A_ANGPOSZ;
extern ATTR *A_ANGVELX;
extern ATTR *A_ANGVELY;
extern ATTR *A_ANGVELZ;
extern ATTR *A_ANGACCX;
extern ATTR *A_ANGACCY;
extern ATTR *A_ANGACCZ;
extern ATTR *A_S0;
extern ATTR *A_S1;
extern ATTR *A_S2;
extern ATTR *A_S3;
extern ATTR *A_S4;
extern ATTR *A_S5;
extern ATTR *A_S6;
extern ATTR *A_S7;
extern ATTR *A_S8;
extern ATTR *A_S9;

#endif

extern ATTR *A_TALENT;
extern ATTR *A_DOING;
extern ATTR *A_RACE;

extern ATTR *A_LHIDE;
extern ATTR *A_LPAGE;

/* attribute access macros */                     
#define Osucc(thing) atr_get(thing,A_OSUCC)
#define Ofail(thing) atr_get(thing,A_OFAIL)
#define Fail(thing) atr_get(thing,A_FAIL)
#define Succ(thing) atr_get(thing,A_SUCC)
#define Pass(thing) atr_get(thing,A_PASS)
#define Desc(thing) atr_get(thing,A_DESC)
#define Idle(thing) atr_get(thing,A_IDLE)
#define Away(thing) atr_get(thing,A_AWAY)
#define Pennies(thing) atoi(atr_get(thing,A_PENNIES))
#define Home(thing) (db[thing].exits)
#define Exits(thing) (db[thing].exits)

#define s_Osucc(thing,s) atr_add(thing,A_OSUCC,s)
#define s_Ofail(thing,s) atr_add(thing,A_OFAIL,s)
#define s_Fail(thing,s) atr_add(thing,A_FAIL,s)
#define s_Succ(thing,s) atr_add(thing,A_SUCC,s)
#define s_Pass(thing,s) atr_add(thing,A_PASS,s)
#define s_Desc(thing,s) atr_add(thing,A_DESC,s)
#define s_Pennies(thing,pp) ((pp>10000)?(atr_add(thing,A_PENNIES,"9900"),1):(atr_add(thing,A_PENNIES,int_to_str(pp)),1))
#define s_Exits(thing,pp) (db[thing].exits=(pp))
#define s_Home(thing,pp) (db[thing].exits=(pp))
extern char *int_to_str();


#define Astr(alist) ((char *)(&((alist)[1])))  
#ifdef SMALL
typedef struct alist ALIST;

/* This may seem very contorted but prior to these changes this structure
   contained most of the uneeded overhead in the mud */               
struct alist {
  /* note!!! this is only a character type for now it may change in the
     future if/when more types are needed */
  /* if high bit set 1 byte follows giving negative relative offset
     to next attribute */
  /* if not set sizeof(ALIST *) bytes follow giving absolute offset */
  /* Note: Alist is not word aligned these must be copied into a valid
     pointer */
  unsigned char al_type;
};

/* macros to deal with ALIST structure, without knowing how yucky it is:) */
/*#define Astr(alist) ((unsigned char *)(&((alist)[1])))*/
/* get type */
#define AL_TYPE(alist) ((alist)->al_type & 127)
/* get string associated with */
#define AL_STR(alist) (((alist)->al_type & 128) ? (Astr(alist)+1) :\
		       (Astr(alist)+sizeof(ALIST *)))
/* get next pointer */
ALIST *AL_GETPTR();
#define AL_NEXT(alist) ((alist)->al_type & 128) ? \
  /* first case this is a relative offset */\
  ((ALIST *)(((char *)(alist))-*Astr(alist))):\
  /* otherwise pointer follows */\
  AL_GETPTR(alist) 
/* dispose of attribute (set type==0) */
#define AL_DISPOSE(alist) ((alist)->al_type&=128)
#endif

#ifndef SMALL
typedef struct alist ALIST;
typedef short atr_flag_t;
struct alist {            
  ALIST *next;
  ATTR *AL_type;
};

#define AL_TYPE(alist) ((alist)->AL_type)
#define AL_STR(alist) (Astr(alist))
#define AL_NEXT(alist) ((alist)->next)
#define AL_DISPOSE(alist) ((alist)->AL_type=0)

#endif

/* special dbref's */
#define NOTHING (-1)		/* null dbref */
#define AMBIGUOUS (-2)		/* multiple possibilities, for matchers */
#define HOME (-3)		/* virtual room, represents mover's home */
typedef char ptype;

typedef struct atrdef ATRDEF;

struct atrdef {
  ATTR a;
  ATRDEF *next;
};

struct object {
 char *name;
  dbref location;		/* pointer to container */
  /* for exits, pointer to destination */
  dbref  zone;			/* zone reference for object */
  dbref contents;		/* pointer to first item */
  dbref exits;			/* pointer to first exit for rooms */
  dbref link;			/* pointer to home/destination */
  dbref next;			/* pointer to next in contents/exits chain */
  ptype *pows;

  /* the following are used for pickups for things, entry for exits */
  dbref owner;		/* who controls this object */
  object_flag_type flags;
  ALIST *list;
#ifdef DO_AGE
  dbref num1,num2;            /* space used to sort by access time */
#endif
  
  struct atrdef *atrdefs;
  dbref *parents;
  dbref *children;
};

extern struct object *db;
extern dbref db_top;

extern char *alloc_string();

extern dbref new_object();	/* return a new object */

extern dbref getref ();   /* Read a database reference from a file. */

extern void putref (); /* Write one ref to the file */

extern int db_write_object(); /* write one object to file */

extern dbref db_write();	/* write db to file, return # of objects */

extern dbref db_read();	/* read db from file, return # of objects */
/* Warning: destroys existing db contents! */

extern void db_free();
extern dbref parse_dbref();	/* parse a dbref */

#define DOLIST(var, first) \
  for((var) = (first); (var) != NOTHING; (var) = db[(var)].next)
#define PUSH(thing, locative) \
  ((db[(thing)].next = (locative)), (locative) = (thing))
#define getloc(thing) (db[thing].location)

#include "powers.h"
#define Typeof(x) (db[x].flags&TYPE_MASK)
#define God(x) ((x) == GOD)

/* stuff for doomsday */
#define IS_DOOMED(x) ((*atr_get((x),A_DOOMSDAY))&&(db[x].flags&GOING)&&(atoi(atr_get((x),A_DOOMSDAY))>0))
#define IS_GONE(x) ((db[(x)].flags&GOING)&&!*atr_get((x),A_DOOMSDAY))

#define PUSH_L(list,value) (push_list(&(list),(value)))
#define REMOVE_FIRST_L(list, value) (remove_first_list(&(list),(value)))

struct all_atr_list {
  ATTR *type;
  char *value;
  int numinherit;
  struct all_atr_list *next;
};

/*
#define unref_atr(foo) do { if(--((foo)->refcount)==0) { dfree((foo)->name); dfree((foo)); } } while(0)
*/
#define unref_atr(foo) do {  } while(0)
#define ref_atr(foo) do { ((foo)->refcount++); } while(0)

#endif /* __DB_H */
