/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
**** Changelog: ***************************************************************
*/

// new(Collection, minlen)
//	abstract base class to collect object pointers

typedef int (* Action) (void *, va_list);	// action function pointer

% CollectionClass: Class  Collection: Object {
    const void ** buf;		// const void * buf [dim]
    unsigned dim;		// current buffer dimension
%
    int isEmpty (const _self);			// true if count == 0
%-
    Object @ add (_self, const Object @ element, ...);
    Object @ find (const _self, const Object @ element);
    unsigned count (const _self);		// number of elements
    int apply (const _self, Action action, ...);
%}
%prot
#ifndef	MINDIM			// could be tuned
#define	MINDIM	32		// used if minlen == 0
#endif

#define	dim(c)	(((const struct Collection *) c) -> dim)
#define	buf(c)	(((const struct Collection *) c) -> buf)
