/***********************************************************
*  Mirror Magic II -- McDuffins Revenge                    *
*----------------------------------------------------------*
*  1994 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.ms.sub.org                  *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
*----------------------------------------------------------*
*  screens.c                                               *
*                                                          *
*  Letzte Aenderung: 29.09.1994                            *
***********************************************************/

#include "screens.h"
#include "events.h"
#include "tools.h"

void DrawMainMenu()
{
  int i;
  int mx,my,ch=0,sw=0;

  StopSounds();
  ClearWindow();
  DrawText(SX+16, SY+8,  "MIRROR MAGIC II",FS_BIG,FC_YELLOW);
  DrawText(SX+32, SY+46, "Copyright 1994 by Holger Schemel",
	   FS_SMALL,FC_RED);
  DrawText(SX+32, SY+64, "Name:",FS_BIG,FC_GREEN);
  if (*AkName)
    DrawText(SX+192,SY+64, AkName,FS_BIG,FC_RED);
  else
    DrawText(SX+192+10,SY+64+10, "Please choose a name!",FS_SMALL,FC_YELLOW);
  DrawText(SX+32, SY+96, "Level:",FS_BIG,FC_GREEN);
  DrawText(SX+352,SY+96, int2str(level,2),FS_BIG,(level>49)*FC_YELLOW);
  DrawText(SX+32, SY+128,"Hall Of Fame",FS_BIG,FC_GREEN);
  DrawText(SX+32, SY+160,"Level Creator",FS_BIG,FC_GREEN);
  DrawText(SY+32, SY+192,"Info Screen",FS_BIG,FC_GREEN);
  DrawText(SX+32, SY+224,"Start Game",FS_BIG,FC_GREEN);
  DrawText(SX+32, SY+256,"One Player",FS_BIG,FC_GREEN);
  DrawText(SX+32, SY+288,"Quit",FS_BIG,FC_GREEN);

  for(i=0;i<8;i++)
    DrawGraphic(0,i+2,45);
  DrawGraphic(10,3,45);
  DrawGraphic(13,3,45);

  DrawText(SX+54,SY+326,"A Game by Artsoft Development",FS_SMALL,FC_BLUE);
  DrawText(SX+26,SY+344,"All artwork was done on the Amiga",FS_SMALL,FC_BLUE);
  DrawText(SX+103,SY+362,"Toons by Thomas Andrae",FS_SMALL,FC_BLUE);

  if (!strcmp(AkName,"Artsoft")) 
    handicap[player_nr]=50;

  InitAnimation();
}

void HandleMainMenu(int mx, int my, int button)
{
  static int ch=0, l_b=0, last_button;
  int x=(mx+32-SX)/32, y=(my+32-SY)/32;
  int i;

  last_button=l_b;
  l_b=button;

  if (!button && last_button || button && (x!=1 || ch!=y) && ch)
  {
    ch=0;
    for(i=0;i<8;i++)
      DrawGraphic(0,i+2,45);
  }

  if (button && y==4 && (x==11 && level>0 || x==14 && level<99))
  {
    if (!AkName[0] || level==50 && x==11 && handicap[player_nr]<50)
      return;
    if (level==handicap[player_nr] && level<50 && x==14)
      return;
    level+=1-2*(x==11);
    DrawTextExt(drawto,gc,
		SX+352,SY+96,int2str(level,2),FS_BIG,(level>49)*FC_YELLOW);
    DrawTextExt(window,gc,
		SX+352,SY+96,int2str(level,2),FS_BIG,(level>49)*FC_YELLOW);
    XFlush(display);
    Delay(100000);
  }
  else if (x==1 && y>2 && y<11)
  {
    if (button)
    {
      if (!last_button || ch!=y)
	DrawGraphic(0,y-1,44);
      ch=y;
    }
    else if (last_button)
    {
      if (!*AkName && (y==4 || y==6 || y==8))
      {
	BackToFront();
	AreYouSure("Please choose a player name first !",0);
	OpenDoor(1);
	for(i=0;i<40;i++)
	{
	  ColorCycling();
	  DoAnimation();
	  Delay(50000);
	}
	CloseDoor(1);
	return;
      }

      if (y==3)
      {
	game_status=CHOOSENAME;
	DrawNameInput();
      }
      else if (y==4)
      {
	level=(level<50)*50;
	DrawText(SX+352,SY+96,int2str(level,2),FS_BIG,(level>49)*FC_YELLOW);
      }
      else if (y==5)
      {
	game_status=HALLOFFAME;
	DrawHallOfFame(-1);
      }
      else if (y==6)
      {
	game_status=LEVELED;
	DrawLevelEd();
      }
      else if (y==7)
      {
	game_status=HELPSCREEN;
	DrawHelpScreen();
      }
      else if (y==8)
      {
	game_status=PLAYING;
	DrawLevel();
	InitGame();
	ScanLaser();
      }
      else if (y==9)
      {
	DrawMainMenu();
	BackToFront();
      }
      else if (y==10)
      {
        if (AreYouSure("Do you really want to quit ?",1))
	  game_status=EXITGAME;
      }
    }
  }
  BackToFront();

  if (!button && !last_button)
    Delay(10000);

  if (game_status==MAINMENU)
    DoAnimation();
}

/* global, so DrawHelpScreen()/ShowHelpScreen() can both see them... */
int gels1[] =
{
  20,0,16,28,104,37,40,80,41,33,48,64,
  24,100,108,44,36,47,105,96,42,32,38,106
};
int gcyc[] =
{
  4,16,4,0,0,0,0,16,0,0,16,4, 4,4,4,3,0,0,0,4,2,0,2,0
};

void DrawHelpScreen()
{
  int i;
  long xt,yt;
  static char *gtxt[] =
  {
    "Gregor McDuffin", "The Magician",
    "Gnome with",      "Rotating Mirror",
    "Fixed Metallic",  "Polarisator",
    "Kettle with",     "Spell Ingredient",
    "Light Sensitive", "Metallic Block",
    "Light Sensitive", "Cobalt Bomb",
    "Metallic Lock",   "",
    "Rotating",        "Polarisator",
    "Golden Key to",   "open the Locks",
    "4 different",     "Walls",
    "Spell Beamer",    "",
    "Moving Cruncher", "eats Kettles",
    "Spell Receiver",  "",
    "Stone Gnome with","Fixed Mirror",
    "Fixed Wooden",    "Polarisator",
    "Magic Balloon",   "gives Bonusscore",
    "Light Sensitive", "Wooden Block",
    "Surprise Balloon","",
    "Wooden Lock",     "",
    "Rotating 2 ways", "Polarisator",
    "Incandescent",    "Lamp must shine",
    "Random",          "Reflecting Prism",
    "Light Sensitive", "Safety Device",
    "Spell Amplifier", "gives extra fuel"
  };

  ClearWindow();
  for(i=0;i<24;i++)
  {
    DrawGraphic((i/12)*8,i%12,gels1[i]);
    xt=SX+34+(i/12)*256;
    yt=SY+(i%12)*32;
    DrawText(xt,yt+2+8*(*gtxt[i*2+1]==0),
	     gtxt[i*2],FS_SMALL,((i%12)%2)*FC_YELLOW);
    if (*gtxt[i*2+1])
      DrawText(xt,yt+16,gtxt[i*2+1],0,3*((i%12)%2));
  }

  XCopyArea(display,drawto,drawto,gc,154,9, 12,5, 154,12);
  BackToFront();
  InitAnimation();

/*
  PlaySound(0,SND_RHYTHMLOOP,0);
*/

}

void HandleHelpScreen(int button)
{
  static int j=0;
  static HC,Hc=0;
  static BOOL last_button=FALSE;
  int i;

  if (last_button && !button)
  {
    FadeSound(0);
    DrawMainMenu();
    BackToFront();
    game_status=MAINMENU;
  }
  else
  {
    HC=Counter2();
    if (HC<Hc || HC>Hc+100)
    {
      Hc=HC;

      j = (j<15 ? j+1 : 0);
      for(i=0;i<24;i++) 
      {
	DrawGraphicExt(drawto,gc,(i/12)*8,i%12,gels1[i]+(gcyc[i]*j)/16);
	DrawGraphicExt(window,gc,(i/12)*8,i%12,gels1[i]+(gcyc[i]*j)/16);
      }
    }
    DoAnimation();
    XFlush(display);
  }
  last_button=button;
}

void DrawNameInput()
{
  if (!Names[0][0]) 
    LoadNames();
  ClearWindow();
  for(i=0;i<10;i++) 
    DrawText(SX+64,SY+i*32,Names[i],1,0);
  DrawText(SX+64,SY+352,"Enter new name",FS_BIG,FC_GREEN);
  for(k=0;k<12;k++) 
    if (k!=10) 
      DrawGraphic(0,k,45);
  BackToFront();
}

void HandleNameInput(int mx, int my, int button)
{
  static BOOL choose_name=FALSE;
  static int ch=0, l_b=0, last_button;
  int sw=0,n=0;
  int x=(mx+32-SX)/32, y=(my+32-SY)/32;
  int i;

  last_button=l_b;
  l_b=button;

  if (!button && last_button || button && (x!=1 || ch!=y) && ch)
  {
    ch=0;
    for(k=0;k<12;k++)
    {
      if (k==10 || k==11 && choose_name)
	continue;
      DrawGraphic(0,k,45);
    }
  }

  if (x==1 && y>=1 && y<=12 && y!=11)
  {
    if (button)
    {
      if ((!last_button || ch!=y) && (y<11 || !choose_name))
	DrawGraphic(0,y-1,44);
      ch=y;
    }
    else if (last_button)
    {
      if (choose_name)
      {
	if (y<11)
	{
	  DrawText(SX+64,SY+352,"Type new name!",FS_BIG,FC_YELLOW);
	  DrawText(SX+64,SY+(y-1)*32,"        ",FS_BIG,0);
	  DrawGraphic(2,y-1,45);

	  choose_name=FALSE;
	  game_status=TYPENAME;
	  HandleNameTyping(y,0);
	}
      }
      else
      {
	if (y==12)
	{
	  DrawText(SX+64,SY+352,"Choose name...",FS_BIG,FC_YELLOW);

	  choose_name=TRUE;
	  DrawGraphic(0,11,46);
	}
	else if (y<11)
	{
	  strcpy(AkName,Names[y-1]);
	  player_nr=y-1;
	  if (level>handicap[player_nr] && level<50)
	    level=handicap[player_nr];

	  choose_name=FALSE;
	  game_status=MAINMENU;
	  DrawMainMenu();
	}
      }
    }
  }
  BackToFront();
  if (!button && !last_button)
    Delay(100000);
}

void HandleNameTyping(int newypos, KeySym key)
{
  static int xpos=0, ypos=0;
  static char chr[2] = { 0,0 };
  static char newname[MAX_NAMELEN];

  if (newypos)
  {
    xpos=0;
    ypos=newypos-1;
    return;
  }

  if ((key>=XK_A && key <=XK_Z || key>=XK_a && key<=XK_z) && 
      xpos<MAX_NAMELEN-2)
  {
    if (key>=XK_A && key<=XK_Z)
      *chr='A'+(char)key-(char)XK_A;
    if (key>=XK_a && key<=XK_z)
      *chr='a'+(char)key-(char)XK_a;
    newname[xpos++]=*chr;
    DrawText(SX+(xpos+1)*32,SY+ypos*32,chr,FS_BIG,FC_GREEN);
    DrawGraphic(xpos+2,ypos,45);
  }
  else if (key==XK_Delete && xpos>0)
  {
    xpos--;
    DrawGraphic(xpos+2,ypos,45);
    DrawGraphic(xpos+3,ypos,-1);
  }
  else if (key==XK_Return && xpos>0)
  {
    newname[xpos]=0;
    strcpy(AkName,newname);
    strcpy(Names[ypos],AkName);
    player_nr=ypos;
    level=handicap[player_nr]=0;
    SaveNames();

    game_status=MAINMENU;
    DrawMainMenu();
  }
  BackToFront();
}

void DrawHallOfFame(int pos)
{
  char txt[40];

  if (pos<0) 
    LoadScore(level);
  ClearWindow();
  DrawText(SX+64,SY+10,"Hall Of Fame",FS_BIG,FC_YELLOW);
  sprintf(txt,"HighScores of Level %d",level);
  DrawText(SX+256-strlen(txt)*7,SY+48,txt,FS_SMALL,FC_RED);
  for(y=0;y<10;y++)
  {
    DrawText(SX,SY+64+y*32,"................",FS_BIG,(y!=pos)*FC_GREEN);
    DrawText(SX,SY+64+y*32,highscore[y].Name,FS_BIG,(y!=pos)*FC_GREEN);
    DrawText(SX+384,SY+64+y*32,
	     int2str(highscore[y].Score,4),FS_BIG,(y!=pos)*FC_GREEN);
  }
  BackToFront();
  InitAnimation();
  PlaySound(0,SND_HALLOFFAME,100);
}

void HandleHallOfFame(int button)
{
  static BOOL last_button=FALSE;

  if (last_button && !button)
  {
    FadeSound(0);
    game_status=MAINMENU;
    DrawMainMenu();
    BackToFront();
  }
  else
  {
    DoAnimation();
    Delay(10000);
  }
  last_button=button;
}

