/*
 * This file is provided for unrestricted use
 * provided that this legend is included on all tape media
 * and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#include <X11/Xos.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <pwd.h>
#ifdef SVR4
#include <limits.h>
#include <sys/systeminfo.h>
#endif
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include <xview/textsw.h>
#include <xview/window.h>
#include <xview/xv_xrect.h>
#include <xview/notify.h>
#include <xview/notice.h>
#include <xview/font.h>
#include <gfm_ui.h>
#include <gfm.h>
#include <gio.h>

#include "xvnews_ui.h"
#include "xvnews.h"
#include "codes.h"

extern struct globals *Global;

get_news_header(ip, flg)
xvnews_post_popup_objects	*ip;
int	flg;
{
	char	host[32], domain_long[80], aline[160];
	char	file[128], *subject;
static	char	buff[1024];
	char	*domain, *getenv(), *getname(), *strchr(), *get_messageid();
	char	*name = (char *)cuserid(NULL), *followUp();
static  char	default_domain[] = DOMAIN;
	FILE	*ifp_in;
	Textsw_index	point;
	struct stat statbuf;
	xvnews_xvnews_window_objects    *bp = (xvnews_xvnews_window_objects *) xv_get(ip->post_popup, XV_KEY_DATA, POST_PARENT, NULL);

	textsw_reset(ip->post_window, 0, 0);
	xv_set(ip->post_window, TEXTSW_INSERTION_POINT, TEXTSW_INFINITY,
		TEXTSW_LOWER_CONTEXT, -1,
		TEXTSW_MEMORY_MAXIMUM, TEXTSW_INFINITY, NULL);
#ifdef SVR4
	sysinfo(SI_HOSTNAME, host, 32);
#else
	gethostname(host, 32);
#endif
	sprintf(buff, "Path: %s!%s\n", host, name);
	textsw_insert(ip->post_window, buff, strlen(buff));
	sprintf(buff, "Distribution: world\n");
	textsw_insert(ip->post_window, buff, strlen(buff));
	if (flg) {
		if (followUp(bp) != NULL)
			sprintf(buff, "Newsgroups: %s\n", followUp(bp));
		else
			sprintf(buff, "Newsgroups: %s\n", Global->group);
	} else {
		if (strlen(Global->group))
			sprintf(buff, "Newsgroups: %s\n", Global->group);
		else {
			sprintf(buff, "Newsgroups: \n");
			point = (Textsw_index)xv_get(ip->post_window, TEXTSW_INSERTION_POINT) + 13;
		}
	}
	textsw_insert(ip->post_window, buff, strlen(buff));
	if (flg)
		sprintf(buff, "Followup-To: \nReferences: <%s>\n", get_messageid(1));
	else
		sprintf(buff, "Followup-To: \n");
	textsw_insert(ip->post_window, buff, strlen(buff));
	if (strlen(default_domain))
		sprintf(buff, "From: %s@%s (%s)\nReply-To: %s@%s\n",
		  	name, default_domain, getname(name), name, default_domain);	
	else {
		if (getenv("DOMAIN") == NULL) {
			fprintf(stderr, "Sorry - DOMAIN-Env isn't set\n");
			exit(1);
		} else
			sprintf(buff, "From: %s@%s (%s)\nReply-To: %s@%s\n", name,
		  	  getenv("DOMAIN"), getname(name), name, getenv("DOMAIN"));
	}
	textsw_insert(ip->post_window, buff, strlen(buff));
	if (getenv("ORGANIZATION") != NULL)
		sprintf(buff, "Organization: %s\n", getenv("ORGANIZATION"));
	else
		sprintf(buff, "Organization: %s\n", ORGANIZATION);
	textsw_insert(ip->post_window, buff, strlen(buff));
	if (flg) {
		subject = (char *)currentSubject(bp, xv_get(bp->articles_list,
			PANEL_LIST_FIRST_SELECTED));
		if (toupper(subject[0]) == 'R' && toupper(subject[1]) == 'E' &&
		   subject[2] == ':')
			sprintf(buff, "Subject: Re:%s\nSummary: \nKeywords: \n\n\n",
				 &subject[3]);
		else
			sprintf(buff, "Subject: Re: %s\nSummary: \nKeywords: \n\n\n",
				 subject);
		textsw_insert(ip->post_window, buff, strlen(buff));
	} else {
		sprintf(buff, "Subject: \nKeywords: \n\n\n");
		textsw_insert(ip->post_window, buff, strlen(buff));
		if (strlen(Global->group) && !flg)
			point = (Textsw_index)xv_get(ip->post_window, TEXTSW_INSERTION_POINT) - 13;
	}
	#ifndef UUCP
	if (flg)
		point = (Textsw_index)xv_get(ip->post_window, TEXTSW_INSERTION_POINT);
	if (strlen(Global->group)) {
		sprintf(file, "%s/%s/.signature",
			Global->newsdir,groupDir(Global->group));
		if (stat(file, &statbuf) != 0)
			sprintf(file, "%s/.signature", getenv("HOME"));
	} else
		sprintf(file, "%s/.signature", getenv("HOME"));
	if ((ifp_in = fopen(file, "r")) == NULL) {
		xv_set(ip->post_window, TEXTSW_INSERTION_POINT, point - 1, NULL);
		xv_set(ip->post_window, TEXTSW_LOWER_CONTEXT, 0, NULL);
                return;
	}
	textsw_insert(ip->post_window, "---\n", 4);
	while(fgets(aline, 160, ifp_in) != NULL) 
		textsw_insert(ip->post_window, aline, strlen(aline));
	xv_set(ip->post_window, TEXTSW_INSERTION_POINT, point - 1, 
		TEXTSW_LOWER_CONTEXT, 0, NULL);
	fclose(ifp_in);
	#endif
}	

get_mail_header(ip, flg)
xvnews_post_popup_objects	*ip;
int	flg;
{
	char	host[32], buff[1024], file[256], *subject, *strchr(), *getenv();
	FILE	*ifp_in;
	Textsw_index	point;
	xvnews_xvnews_window_objects    *bp = (xvnews_xvnews_window_objects *) xv_get(ip->post_popup, XV_KEY_DATA, POST_PARENT, NULL);

#ifdef SVR4
	sysinfo(SI_HOSTNAME, host, 32);
#else
	gethostname(host, 32);
#endif
	subject = (char *)currentSubject(bp, xv_get(bp->articles_list,
			PANEL_LIST_FIRST_SELECTED));
	if (flg) { 
		if (toupper(subject[0]) == 'R' && toupper(subject[1]) == 'E' &&
		   subject[2] == ':')
			sprintf(buff, "To: %s\nSubject: Re:%s\nCc: \n\n\n",
				(char *)currentAuthor(1), &subject[3]);
		else
			sprintf(buff, "To: %s\nSubject: Re: %s\nCc: \n\n\n",
				(char *)currentAuthor(1), subject);
		textsw_insert(ip->post_window, buff, strlen(buff));
		point = (Textsw_index)xv_get(ip->post_window, TEXTSW_INSERTION_POINT);
	} else {
		sprintf(buff, "To: \n");
		textsw_insert(ip->post_window, buff, strlen(buff));
		point = (Textsw_index)xv_get(ip->post_window, TEXTSW_INSERTION_POINT);
		sprintf(buff, "Subject: %s\nCc: \n\n\n", subject);
		textsw_insert(ip->post_window, buff, strlen(buff));
		include_news(ip, 1);
	}
	#ifndef UUCP
	sprintf(file, "%s/.signature", getenv("HOME"));
	if ((ifp_in = fopen(file, "r")) == NULL) {
		xv_set(ip->post_window, TEXTSW_INSERTION_POINT, point - 1,
			TEXTSW_LOWER_CONTEXT, 0, NULL);
		textsw_normalize_view(ip->post_window, 0);
                return;
	}
	while(fgets(buff, 1024, ifp_in) != NULL) 
		textsw_insert(ip->post_window, buff, strlen(buff));
	xv_set(ip->post_window, TEXTSW_INSERTION_POINT, point - 1,
		TEXTSW_LOWER_CONTEXT, 0, NULL);
	fclose(ifp_in);
	#endif
	textsw_normalize_view(ip->post_window, 0);
}
	

char *
getname(engr)
        char    *engr;
{
static	char     fullname[64];
	char	 *a;
        struct passwd *pw;

	if (getenv("NAME") != NULL)
		return getenv("NAME");
        if ((pw = getpwnam(engr)) == NULL)
                strcpy(fullname,"");
        else
                strncpy(fullname, pw->pw_gecos, 63);
	if (strchr(fullname, '&') != NULL) {
		a = strchr(fullname, '&');
		strcpy(a, (char *)cuserid(NULL));
		a = (char *)strstr(fullname, (char *)cuserid(NULL));
		*a = toupper(*a);
	}
        return(fullname);
}

confirm_cancel(pp)
xvnews_post_popup_objects       *pp;
{

	return notice_prompt(pp->post_controls, NULL,
                NOTICE_MESSAGE_STRINGS, "Do you really want to cancel?",
                NULL,
        NOTICE_BUTTON_YES,      "Cancel Post",
        NOTICE_BUTTON_NO,       "Abort Cancel",
        NULL);
}
cancel_message(ip)
xvnews_post_popup_objects	*ip;
{
	int	result;

	result = confirm_cancel(ip); 

	if (!result)
		return;

	xv_destroy_safe(ip->post_popup);
}

void UseInews(bp, orig_mbuf)
xvnews_xvnews_window_objects    *bp;
char*	orig_mbuf;	
{
  FILE *fp_orig, *fp_inews;
  char command[256];
  char zeile[256];
  char last[256];
  char mbuf[256];
  int  sub_found = 0;
  
  strcpy(last, "\n");
  strcpy(mbuf, orig_mbuf);
  mbuf[strlen(mbuf)-1]=' ';
  if ((fp_orig = fopen("/tmp/.article.orig", "w"))==NULL)
    xvnews_err(bp, "Can't write /tmp-directory - article not posted via UUCP\n.");
  else
    {
      fputs(mbuf, fp_orig);
      fclose(fp_orig);
      
      if ((fp_inews = fopen("/tmp/.article.inews","w"))==NULL ||
	  (fp_orig  = fopen("/tmp/.article.orig", "r"))==NULL)
	xvnews_err(bp, "Can't write /tmp - article not posted via UUCP\n.");
      else
	{
	  while (!feof(fp_orig))
	    {
	      fgets(zeile, 256, fp_orig);
	      sub_found = sub_found || strstr(zeile, "Subject:")!=NULL;
	      if (sub_found || strstr(zeile, "Newsgroups:")!=NULL)
		fputs(zeile, fp_inews);
	      
	      strcpy(last, zeile);
	    }
	  fclose(fp_orig);
	  fclose(fp_inews);
	  sprintf(command, "%s -h /tmp/.article.inews", INEWS);
	  system(command);
	  system("rm /tmp/.article.orig /tmp/.article.inews");
	  xvnews_err(bp, "Article posted via UUCP.\n");
	}
    }
}
	
deliver_message(ip)
xvnews_post_popup_objects       *ip;
{

static	char	message[MAX_MESSAGE_LEN];
	char	*mbuf, *checkPeriods();
	int	result, i;
	Textsw_index    len;
	FILE		*pipe;
	xvnews_xvnews_window_objects    *bp = (xvnews_xvnews_window_objects *) xv_get(ip->post_popup, XV_KEY_DATA, POST_PARENT, NULL);

	xv_set(ip->post_window, TEXTSW_INSERTION_POINT, TEXTSW_INFINITY, NULL);
	len = (Textsw_index)xv_get(ip->post_window, TEXTSW_INSERTION_POINT);

	if (len > 0) {
                if ((mbuf = (char *)malloc(len+8)) != NULL) {
			if (mbuf == NULL) {
				printf("Malloc failed\n");
				return;
		 	}	
			memset(mbuf, '\0', len+1);
                        len = (Textsw_index)xv_get(ip->post_window,
                                TEXTSW_CONTENTS, 0, mbuf, len);
                        if (len > 0) {
				i = strlen(mbuf);
				if (xv_get(ip->post_popup, XV_KEY_DATA, POST_TYPE, NULL) == NEWS_POST) {
					if (!checkHeader(ip, mbuf, "Newsgroups:")) {
						xv_set(ip->post_popup, FRAME_LEFT_FOOTER, "No newsgroup(s) specified for article!\n", NULL);
						window_bell(ip->post_popup);
						free(mbuf);
						return;
					}
					if (!checkHeader(ip, mbuf, "Subject:")) {
						xv_set(ip->post_popup, FRAME_LEFT_FOOTER, "No subject in article!\n", NULL);
						window_bell(ip->post_popup);
						free(mbuf);
						return;
					}
					if (filePost(ip, bp, mbuf) < 0) {
						free(mbuf);
						return;
					}
					
					mbuf = checkPeriods(mbuf);
					strcat(mbuf, "\n.");
					#ifdef UUCP
					UseInews(bp, mbuf);
					#else
					put_server("POST");
					get_server(message, sizeof(message));
					sscanf(message, "%d", &result);
					if (result != CONT_POST) {
						reconnect_server();
                                                put_server("POST");
                                                get_server(message, sizeof(message));                                           
                                                sscanf(message, "%d", &result);
                                                if (result != CONT_POST) {
						xv_set(ip->post_popup, 
							FRAME_LEFT_FOOTER,
							"Posting not allowed!\n",
							NULL);
						window_bell(ip->post_popup);
						free(mbuf);
						return;
						}
					}
					put_server(mbuf);
					get_server(message, sizeof(message));
					sscanf(message, "%d", &result);
					if (result != POSTED_OK) {
						if (result != ERR_POSTFAIL) {
						reconnect_server();
						put_server("POST");
                                        	get_server(message, sizeof(message));
                                        	put_server(mbuf);
                                        	get_server(message, sizeof(message));
						sscanf(message, "%d", &result);
						}
						if (result != POSTED_OK) {
							errorPost(ip, message);
							free(mbuf);
							return;
						}
					}
					xvnews_err(bp, "Article posted via NNTP.\n");
					#endif
				} else {
					#ifdef UUCP
					if ((pipe = popen("/usr/bin/smail -t","w")) == NULL) {	
					#else
					if ((pipe = popen("/usr/mail -t","w")) == NULL) {
					#endif
						xvnews_err(bp,
						 "Couldn't open a mail pipe!\n");
						free(mbuf);
						return;
					}
					fprintf(pipe, "%s\n", mbuf);
					xvnews_err(bp,
						"Mail sent.\n");
					pclose(pipe);
				}
			}
                        free(mbuf);
                }
        }
	textsw_reset(ip->post_window, 0, 0);
	xv_destroy_safe(ip->post_popup);
}

include_news(pp, flg)
xvnews_post_popup_objects       *pp;
int flg;
{
	char    buff[1024], *indent, *get_messageid();
static	char	article[MAX_ARTICLE_LEN];
	int	status;
	FILE	*ifp_out;
	xvnews_xvnews_window_objects    *bp = (xvnews_xvnews_window_objects *) xv_get(pp->post_popup, XV_KEY_DATA, POST_PARENT, NULL);	
	xvnews_props_objects *prp = (xvnews_props_objects *)xv_get(bp->xvnews_window, XV_KEY_DATA, PROPS_POPUP, NULL);

	if (Global->mode != ALL_ARTICLES && Global->mode != ARTICLE_MODE)
		return -1;

	sprintf(buff, "In article %s, %s writes:\n",
		 get_messageid(0), (char *)currentAuthor(0));
	textsw_insert(pp->post_window, buff, strlen(buff));
	if ((ifp_out = fopen("/tmp/.xvnews.include", "w")) == NULL) {
		xvnews_err(bp, "Unable to open file /tmp/.xvnews.include!\n");
		return -1;
	}
	if (flg)
		indent = (char *)xv_get(prp->indent_text, PANEL_VALUE, NULL);
	else
		indent = "";
	put_server("BODY");
	get_server(article, sizeof(article));
	sscanf(article, "%d", &status);
	if (status != OK_BODY) {
		char	command[MAX_COMMAND_LEN];
		char	*old;
		int 	art;

		reconnect_server();
		old = (char *)xv_get(bp->articles_list, PANEL_LIST_STRING,
		   xv_get(bp->articles_list, PANEL_LIST_FIRST_SELECTED),
		NULL);
		sscanf(old, "%d", &art);
		sprintf(command, "BODY %d", art);
		put_server(command, sizeof(command));
		get_server(article, sizeof(article));
		sscanf(article, "%d", &status);
		if (status != OK_BODY) 
			return -1;
	}
	
	for (;;) {
		get_server(article, sizeof(article));
		if (article[0] == '.' && article[1] == '\0')
			break;
		else 
				fprintf(ifp_out, "%s%s\n", indent, article);
	}
	fprintf(ifp_out, "\n\n");
	fclose(ifp_out);
	xv_set(pp->post_window, TEXTSW_LOWER_CONTEXT, -1,
		TEXTSW_MEMORY_MAXIMUM, TEXTSW_INFINITY, NULL);
	xv_set(pp->post_window,
            TEXTSW_INSERT_FROM_FILE,    "/tmp/.xvnews.include",
            NULL);
	xv_set(pp->post_window, TEXTSW_LOWER_CONTEXT, 0, NULL);
	unlink("/tmp/.xvnews.include");

	return 1;
}

char *
get_messageid(flg)
int	flg;
{
	char	*c, article[MAX_ARTICLE_LEN];
static	char	number[80];
	int	status;

	put_server("STAT");
	get_server(article, sizeof(article));
	sscanf(article, "%d", &status);
	if (status != OK_NOTEXT) {
		char	command[MAX_COMMAND_LEN];

		reconnect_server();
		sprintf(command, "STAT %d", Global->article);
		put_server(command);
		get_server(article, sizeof(article));
		sscanf(article, "%d", &status);
		if (status != OK_NOTEXT) 
			return NULL;
	}

	if (flg) {
		c = strchr(article, '<');
		sscanf(++c, "%[^>]s", number);
	} else {
		c = strchr(article, '@');
		if (c != NULL) {
			c--;
			while (isdigit(*c) || isalpha(*c))
				--c;
			++c;
			sscanf(c, "%[^>]s", number); 
		}
	}
	return number;
}

char	*
followUp(ip)
xvnews_xvnews_window_objects	*ip;
{
	int row = xv_get(ip->articles_list, PANEL_LIST_FIRST_SELECTED, NULL);
	char	*str = (char *)xv_get(ip->articles_list,PANEL_LIST_STRING,row);
	char	command[MAX_COMMAND_LEN], message[MAX_MESSAGE_LEN];
static	char	*c, follow[MAX_MESSAGE_LEN];
	int	art, status;

	sscanf(str, "%d", &art);
	sprintf(command, "XHDR followup-to %d", art);
	put_server(command);
	get_server(message, sizeof(message));
	sscanf(message, "%d", &status);
	if (status != OK_HEAD) {
		reconnect_server();
		return NULL;
	}

	while(*message != '.') {
		get_server(message, sizeof(message));
		if (*message != '.')
			strcpy(follow, message);
	}

	if (strstr(follow, "(none)") != NULL ||
	   strstr(follow, "poster") != NULL)
		return NULL;

	c = follow;
	while (isdigit(*c) || *c == ' ')
		c++;

	return c;
}

includeFile(win, file)
Xv_window       win;
char	*file;
{
	char str[256], name[256];
	int	result, i = strlen(file), lines = textsw_file_line_count(win);
	int	size = 0;
	xvnews_post_popup_objects *ip = (xvnews_post_popup_objects *) xv_get(xv_get(win, XV_OWNER, NULL), XV_KEY_DATA, INSTANCE, NULL);
	xvnews_xvnews_window_objects    *bp = (xvnews_xvnews_window_objects *) xv_get(ip->post_popup, XV_KEY_DATA, POST_PARENT, NULL);
	struct stat	statbuf;

	if (stat(file, &statbuf)) {
		xvnews_err(bp, "%s: No such file!\n", file);
		return;
	}

	sprintf(str, "Would you like %s", file);
	result = notice_prompt(win, NULL, NOTICE_MESSAGE_STRINGS, str,
			"loaded as text or uuencoded?",
			NULL,
			NOTICE_BUTTON,      "text", 101,
			NOTICE_BUTTON,       "compress & uuencode", 102,
			NOTICE_BUTTON,       "uuencode", 103,
			NOTICE_BUTTON,       "cancel", 104,
			NULL);

	while(file[i] != '/')
		--i;
	strncpy(name, &file[i+1], strlen(file));
	switch (result) {
		case 101:
			strcpy(str, file);
			size = statbuf.st_size;
			break;
		case 102:
			sprintf(str, "/usr/bin/compress -c %s | /usr/bin/uuencode %s.Z > /tmp/xvnews.uu\n", file, name);
			system(str);
			strcpy(str, "/tmp/xvnews.uu");
			if (!stat(str, &statbuf)) 
				size = statbuf.st_size;
			break;
		case 103:
			sprintf(str, "/usr/bin/uuencode %s %s > /tmp/xvnews.uu\n", file, name);
			system(str);
			strcpy(str, "/tmp/xvnews.uu");
			if (!stat(str, &statbuf)) 
				size = statbuf.st_size;
			break;
		default:
			return;
	}
	xv_set(win, TEXTSW_INSERT_FROM_FILE, str, NULL);
	unlink("/tmp/xvnews.uu");
	sprintf(name, "Loaded %d lines, %d bytes from file %s\n", textsw_file_line_count(win) - lines, size, file);
	xv_set(ip->post_popup, FRAME_LEFT_FOOTER, name, NULL);
}

checkHeader(ip, art, line)
xvnews_post_popup_objects       *ip;
char	*art;
char	*line;
{
	char *a, *c = strstr(art, line);
	Textsw_index    first = 0, last = TEXTSW_INFINITY;

	if (c == NULL)
		return 0;

	a = strchr(c, '\n');
	*a = '\0';

	if ((int)strlen(c) > (int)strlen(line) + 2) {
		*a = '\n';
		return 1;
	}

	if (textsw_find_bytes(ip->post_window, &first, &last, line,
			 strlen(line), 0) != -1)
		xv_set(ip->post_window, TEXTSW_INSERTION_POINT, last + 1, NULL);

	return 0;
}

filePost(ip, bp, art)
xvnews_post_popup_objects       *ip;
xvnews_xvnews_window_objects    *bp;
char	*art;
{
	xvnews_props_objects *pp = (xvnews_props_objects *)xv_get(bp->xvnews_window, XV_KEY_DATA, PROPS_POPUP, NULL);
	char	*log = (char *)xv_get(pp->log_text, PANEL_VALUE, NULL);
	char	from[80], from_line[128];
	time_t	clock;
	FILE	*ifp_out;

	if (!xv_get(ip->log_choice, PANEL_VALUE, NULL) || !strlen(log))
		return 0;

	if ((ifp_out = fopen(log, "a")) == NULL) {
		char	error[256];

		window_bell(ip->post_popup);
		sprintf(error, "Cannot open %s to log posting!\n", log);
		xv_set(ip->post_popup, FRAME_LEFT_FOOTER, error, NULL);
		return -1;
	}

	time(&clock);
	strftime(from, 80, "%a %h %e %T %Y", localtime(&clock));
	sprintf(from_line, "From %s %s", (char *)cuserid(NULL), from);
	fprintf(ifp_out, "%s\n%s\n\n", from_line, art);
	fclose(ifp_out);

	return 1;
}

char *
checkPeriods(buf)
char *buf;
{
	char *c, *p, *new;

	if (strstr(buf, "\n.") == NULL)
		return buf;
	new = (char *)malloc((strlen(buf) * 2) + 1);
	p = new;
	c = buf;
	while (*c != '\0') {
		if (*c == '.' && *(c - 1) == '\n') 
			*p++ = '.';
		*p++ = *c++;
	}
	*p = '\0';
	free(buf);

	return new;
}

errorPost(ip, message)
xvnews_post_popup_objects       *ip;
char    *message;
{
        char    error[256];

        if (!Global->nnrp)
                sprintf(error, "Server rejected article! Possibly too much included (\">\") text in post??\n");
        else {
                char *c = message;

                while(isdigit(*c++));
                sprintf(error, "Server rejected article! Error: %s\n", c);
        }
        xv_set(ip->post_popup, FRAME_LEFT_FOOTER, error, NULL);
        window_bell(ip->post_popup);
}
