/*
 * This file is provided for unrestricted use
 * provided that this legend is included on all tape media
 * and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#include <X11/Xos.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/notify.h>
#include <xview/cursor.h>
#include <gdd.h>
#include <gfm_ui.h>
#include <gfm.h>
#include <gio.h>

#include "xvnews_ui.h"
#include "xvnews.h"
#include "codes.h"
#include "patchlevel.h"

extern struct globals *Global;

static unsigned short copyso_image[] = {
#include "copyso.cursor"
	};
mpr_static(copyso_pr, ICON_DEFAULT_WIDTH, ICON_DEFAULT_HEIGHT, 1, copyso_image);

init_cursor()
{
	int	xhot, yhot;

	xhot = ICON_DEFAULT_WIDTH / 2 + 11;
        yhot = ICON_DEFAULT_WIDTH / 2 + 1;
        Global->copyso_cursor= xv_create(0, CURSOR,
            CURSOR_IMAGE,   &copyso_pr,
            CURSOR_XHOT,    xhot,
            CURSOR_YHOT,    yhot,
            CURSOR_OP,      PIX_SRC ^ PIX_DST,
            0);
}

init_rescan_timer(ip)
xvnews_xvnews_window_objects    *ip;
{
        int             i;
	struct itimerval    timer;
	Notify_value        rescan_timer();
	xvnews_props_objects *prp = (xvnews_props_objects *)xv_get(ip->xvnews_window, XV_KEY_DATA, PROPS_POPUP, NULL);

	i = xv_get(prp->rescan_text, PANEL_VALUE, NULL);
                i *= 60;
                if (i < 300)
                        i = 300;
                if (i > 3600)
                        i = 3600;
                timer.it_interval.tv_usec = 0;
                timer.it_interval.tv_sec = i;
                timer.it_value.tv_usec = 0;
                timer.it_value.tv_sec = i;

                notify_set_itimer_func(ip->xvnews_window, rescan_timer, ITIMER_REAL,
			 &timer, NULL);

} 

init_labels(ip)
xvnews_xvnews_window_objects    *ip;
{
	char	label[120];

	sprintf(label, "xvnews version %-1.1f patch%d connected to %s server %s\n",
	VERSION,PATCHLEVEL,Global->nnrp ? "INN":"NNTP", get_nntp_server());
	xv_set(ip->xvnews_window, FRAME_LABEL, label, NULL);
}

init_globals(ip)
xvnews_xvnews_window_objects    *ip;
{
	Global = (struct globals *)malloc(sizeof(struct globals));
	if (Global == NULL) {
		printf("Malloc of struct global failed!\n");
		exit(-1);
	}
	Global->dragging = 0;
	Global->check_drag = 0;
	Global->head = NULL;
	Global->mode = GROUP_MODE;
	Global->list = 1;
	Global->post = NEWS_POST;
	Global->post_popups = 0;
	Global->kill = NULL;
	Global->nnrp = 0;
	Global->news_icon = (Icon)xv_get(ip->xvnews_window, FRAME_ICON);
	Global->single = NULL;
}

initGlobalValues()
{
	struct stat	statbuf;

	if (getenv("SAVEDIR") == NULL)
		sprintf(Global->newsdir, "%s/News", getenv("HOME"));
	else
		strcpy(Global->newsdir, getenv("SAVEDIR"));

	if (Global->single != NULL) {
		sprintf(Global->newsrc, "%s/.%s", getenv("HOME"), Global->single);
		return;
	}

	if (getenv("DOTDIR") == NULL) {
		sprintf(Global->newsrc, "%s/.newsrc-%s", getenv("HOME"), get_nntp_server());
                if (stat(Global->newsrc, &statbuf))
                        sprintf(Global->newsrc, "%s/.newsrc", getenv("HOME"), get_nntp_server());
        } else {
                sprintf(Global->newsrc, "%s/.newsrc-%s", getenv("DOTDIR"), get_nntp_server());
                if (stat(Global->newsrc, &statbuf))
                        sprintf(Global->newsrc, "%s/.newsrc", getenv("DOTDIR"), get_nntp_server());
        }
}

initIcon(ip)
xvnews_xvnews_window_objects    *ip;
{
	static unsigned short   nonews_icon[] = {
#include "nonews.icon"
	};
	static unsigned short   news_icon[] = {
#include "news.icon"
	};
	Server_image	xvnews_icon;
	
	if (Global->mode == GROUP_MODE &&
		!xv_get(ip->groups_list, PANEL_LIST_NROWS)) 
		xvnews_icon = xv_create(XV_NULL, SERVER_IMAGE,
			SERVER_IMAGE_BITS, nonews_icon,
			SERVER_IMAGE_DEPTH, 1,
			XV_WIDTH, 64,
			XV_HEIGHT, 64,
			NULL);
	else 
		xvnews_icon = xv_create(XV_NULL, SERVER_IMAGE,
			SERVER_IMAGE_BITS, news_icon,
			SERVER_IMAGE_DEPTH, 1,
			XV_WIDTH, 64,
			XV_HEIGHT, 64,
			NULL);

	xv_set(Global->news_icon,
		ICON_IMAGE, xvnews_icon,
		WIN_RETAINED, TRUE,
		NULL);

	xv_set(ip->xvnews_window, FRAME_ICON, Global->news_icon, NULL);
}
						
init_dist_menu(ip)
xvnews_post_popup_objects       *ip;
{
	char		message[MAX_MESSAGE_LEN], *dist;
	int		status;
	char		*c;
	Menu_item	mi;
	void            dist_notify();

	if (!Global->list)
		return;
	put_server("LIST DISTRIBUTIONS");
	get_server(message, sizeof(message));
	sscanf(message, "%d", &status);
	if (status != OK_GROUPS) {
		if (strstr(message, "Timeout") != NULL) {
			reconnect_server();
			put_server("LIST DISTRIBUTIONS");
			get_server(message, sizeof(message));
			sscanf(message, "%d", &status);
		}
		if (status != OK_GROUPS) {
			mi = (Menu_item) xv_create(NULL, MENUITEM,
				XV_KEY_DATA, INSTANCE, ip,
				MENU_STRING,	"world",
				MENU_NOTIFY_PROC, dist_notify,
				MENU_RELEASE,
				NULL);
			xv_set((Menu)xv_get(ip->dist_butt, PANEL_ITEM_MENU,
				NULL), MENU_APPEND_ITEM, mi, NULL);
			return;
		}
	}
	while (*message != '.') {
		get_server(message, sizeof(message));
		if (*message != '.') {
			dist = (char *) malloc(80);
			if (dist == NULL) {
				printf("Malloc failed\n");
				return;
			}
			sscanf(message, "%s", dist);
			c = (message + strlen(dist));
			while (*c++ == '	');
			sprintf(dist, "%s -- %s", dist, --c);
			mi = (Menu_item)xv_create(NULL, MENUITEM,
				XV_KEY_DATA, INSTANCE, ip,
				MENU_STRING,    dist,
				MENU_NOTIFY_PROC, dist_notify,
				MENU_RELEASE,
				NULL);
			xv_set((Menu)xv_get(ip->dist_butt, PANEL_ITEM_MENU,
				NULL), MENU_APPEND_ITEM, mi, NULL);
		}
	}
}

init_destroy_func(ip)
xvnews_xvnews_window_objects    *ip;
{
	Notify_value	destroy_main();

	notify_interpose_destroy_func(ip->xvnews_window, destroy_main);
}


Notify_value
destroy_post(frame, status)
Frame	frame;
Destroy_status	status;
{
	if (status == DESTROY_CHECKING) {
		gfm_popup_objects               *gfm = (gfm_popup_objects *) xv_get(frame, XV_KEY_DATA, LOAD_POPUP, NULL);
		xvnews_xvnews_window_objects    *bp = (xvnews_xvnews_window_objects *) xv_get(frame, XV_KEY_DATA, POST_PARENT, NULL);

		xv_destroy(gfm->popup);
		xv_set(bp->xvnews_window, XV_KEY_DATA, POST_POPUP, NULL, NULL);
		Global->post_popups--;
	}

	return notify_next_destroy_func(frame, status);
}

Notify_value
destroy_main(frame, status)
Frame	frame;
Destroy_status	status;
{
	if (status == DESTROY_CHECKING) {
		char	file[256];

		sprintf(file, "/tmp/.xvnews.file.%d", getpid());
		unlink(file);
		if (save_newsrc())
			printf("An error occured while saving your .newsrc!\n");
		close_server();

		return NOTIFY_DONE;
	}

	return notify_next_destroy_func(frame, status);

}

init_groups_search(ip)
xvnews_xvnews_window_objects    *ip;
{
	xvnews_search_popup_objects * srp = (xvnews_search_popup_objects *)xv_get(ip->xvnews_window, XV_KEY_DATA, SEARCH_POPUP, NULL);

	xv_set(srp->header_choice, XV_SHOW, FALSE, NULL); 
	xv_set(srp->header_text, XV_SHOW, FALSE, NULL); 
	xv_set(srp->srch_prev_butt, XV_SHOW, FALSE, NULL); 
	xv_set(srp->srch_next_button, XV_SHOW, FALSE, NULL); 
	xv_set(srp->show_groups_butt, XV_SHOW, TRUE, NULL);
	xv_set(srp->search_text, PANEL_VALUE, "", NULL);
	xv_set(srp->search_popup, XV_LABEL, "Groups matching string", NULL);
	xv_set(srp->search_popup, FRAME_LEFT_FOOTER, "\n", NULL);
	xv_set(srp->search_popup, XV_SHOW, TRUE, NULL);
	xv_set(srp->search_popup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
}
