/*
 * Read (copy) an MSDOS file to Unix
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#define LOWERCASE

#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "getopt.h"
#ifdef BSD
#include <sys/time.h>
#else /* BSD */
#include <time.h>
#endif /* BSD */
#include <utime.h>
#include "msdos.h"

static void set_mtime();
static FILE *open_file();
static void close_file();
static long conv_stamp();

void
mread(argc, argv)
int argc;
char *argv[];
{
	FILE *fp;
	int i, ismatch, entry, single, c, oops, preserve, nowarn, textmode;
	int got_one, missed_one;
	unsigned int fat;
	long size, mtime;
	char *filename, *newfile, *pathname;
	char *target, tmp[MAX_PATH], drive, *s;
	char last_drive;
	struct directory *dir;
	struct stat stbuf;

					/* get command line options */
	oops = 0;
	preserve = 0;
	nowarn = 0;
	textmode = 0;
	got_one = 0;
	missed_one = 0;
	while ((c = getopt(argc, argv, "tnmv")) != EOF) {
		switch (c) {
			case 't':
				textmode = 1;
				break;
			case 'n':
				nowarn = 1;
				break;
			case 'm':
				preserve = 1;
				break;
			case 'v':	/* dummy option for mcopy */
				break;
			default:
				oops = 1;
				break;
		}
	}

	if (oops || (argc - optind) < 2) {
		fprintf(stderr, "Mtools version %s, dated %s\n", mversion, mdate);
		fprintf(stderr, "Usage: %s [-tnm] msdosfile unixfile\n", argv[0]);
		fprintf(stderr, "       %s [-tnm] msdosfile [msdosfiles...] unixdirectory\n", argv[0]);
		exit(1);
	}
	last_drive = 'x';
	mcwd = fix_mcwd();
					/* only 1 file to copy... */
	single = 1;
	target = argv[argc - 1];
					/* ...unless last arg is a directory */
	if (strcmp(target,"-") && !stat(target, &stbuf)) {
		if ( S_ISDIR(stbuf.st_mode) )
			single = 0;
	}
					/* too many arguments */
	if (single && (argc - optind) != 2) {
		fprintf(stderr, "%s: Too many arguments or destination directory omitted\n", argv[0]);
		exit(1);
	}

	for (i = optind; i < argc - 1; i++) {
		drive = get_drive(argv[i]);
		if (drive != last_drive) {
			if (init(drive, O_RDONLY)) {
				fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
				missed_one++;
				continue;
			}
			last_drive = drive;
		}
		filename = get_name(argv[i]);
		if (!strlen(filename))
			filename="*";				/* If no file, assume whole dir */
		pathname = get_path(argv[i]);
		if (subdir(drive, pathname)) {
			missed_one++;
			continue;
		}

		ismatch = 0;
		for (entry = 0; entry < dir_entries; entry++) {
			dir = dir_read(entry);
					/* if empty */
			if (dir->name[0] == 0x0)
				break;
					/* if erased */
			if (dir->name[0] == 0xe5)
				continue;
					/* if dir or volume label */
			if ((dir->attr & 0x10) || (dir->attr & 0x08))
				continue;

			newfile = unix_name(dir->name, dir->ext);

					/* if single file */
			if (single) {
				if (!strcmp(newfile, filename)) {
					fat = dir->start[1] * 0x100 + dir->start[0];
					size = dir->size[3] * 0x1000000L + dir->size[2] * 0x10000L + dir->size[1] * 0x100 + dir->size[0];
					if (preserve)
						mtime = conv_stamp(dir->time, dir->date);
					else
						mtime = 0L;
					if ((fp = open_file(target, nowarn))) {
						if (file_read(fp, fat, textmode, 0, size)) {
							close_file(fp);
							missed_one++;
							break;
						}
						close_file(fp);
						set_mtime(target, mtime);
						ismatch = 1;
						got_one++;
					}
					else
						missed_one++;
					break;
				}
			}
					/* if multiple files */
			else {
				if (match(newfile, filename)) {
					fat = dir->start[1] * 0x100 + dir->start[0];
					size = dir->size[3] * 0x1000000L + dir->size[2] * 0x10000L + dir->size[1] * 0x100 + dir->size[0];
					if (preserve)
						mtime = conv_stamp(dir->time, dir->date);
					else
						mtime = 0L;
					printf("Copying %s\n", newfile);
#ifdef LOWERCASE
					s = newfile;
					while (*s) {
						if (isupper(*s))
							*s = tolower(*s);
						s++;
					}
#endif /* LOWERCASE */
					strcpy(tmp, target);
					strcat(tmp, "/");
					strcat(tmp, newfile);
					if ((fp = open_file(tmp, nowarn))) {
						if (file_read(fp, fat, textmode, 0, size)) {
							close_file(fp);
							missed_one++;
							break;
						}
						close_file(fp);
						set_mtime(tmp, mtime);
						ismatch = 1;
						got_one++;
					}
					else
						missed_one++;
				}
			}
		}
		if (fat_error) {
			missed_one++;
			break;
		}

		if (!ismatch) {
			fprintf(stderr, "%s: File \"%s\" not found\n", argv[0], filename);
			missed_one++;
		}
	}
	close(fd);
	if (got_one && missed_one)
		exit(2);
	if (missed_one)
		exit(1);
	exit(0);
}

/*
 * Open the named Unix file for write.
 */

static FILE *
open_file(target, nowarn)
char *target;
int nowarn;
{
	static FILE *fp;
	struct stat stbuf;

	if ( strcmp(target,"-") == 0 )
	  return stdout;

	if (!nowarn) {
		if (!access(target, 0)){
			if( ask_confirmation("File \"%s\" exists, overwrite (y/n) ? ", target))
				return NULL;

			/* sanity checking */
			if (!stat(target, &stbuf) && !S_ISREG(stbuf.st_mode)){
					fprintf(stderr, "\"%s\" is not a regular file\n", target);
					return(NULL);
			}
		}
	}

	if (!(fp = fopen(target, "w"))) {
		fprintf(stderr, "Can't open \"%s\" for write\n", target);
		return(NULL);
	}
	return(fp);
}

/*
 * Close the Unix file
 */

static void
close_file(fp)
FILE *fp;
{
  if ( fp != stdout )
    fclose(fp);
}

/*
 * Convert an MSDOS time & date stamp to the Unix time() format
 */

static long
conv_stamp(time_field, date_field)
unsigned char *time_field, *date_field;
{
#ifdef BSD
	struct timeval tv;
	struct timezone tz;
#else /* BSD */
	extern long timezone;
#endif /* BSD */
	struct tm *tmbuf;
	int year, mon, mday, hour, min, sec, old_leaps;
	long answer, sec_year, sec_mon, sec_mday, sec_hour, sec_min, sec_leap;
	long tzone, dst;
	static int month[] = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304,
	334};
					/* dissect the parts */
	year = (date_field[1] >> 1) + 1980;
	mon = (((date_field[1] & 0x1) << 3) + (date_field[0] >> 5));
	mday = date_field[0] & 0x1f;
	hour = time_field[1] >> 3;
	min = (((time_field[1] & 0x7) << 3) + (time_field[0] >> 5));
	sec = (time_field[0] & 0x1f) * 2;
					/* how many previous leap years */
	old_leaps = (year - 1972) / 4L;
	sec_leap = old_leaps * 24L * 60L * 60L;
					/* back off 1 day if before 29 Feb */
	if (!(year % 4) && mon < 3)
		sec_leap -= 24L * 60L * 60L;
	sec_year = (year - 1970) * 365L * 24L * 60L * 60L;
	sec_mon = month[mon - 1] * 24L * 60L * 60L;
	sec_mday = mday * 24L * 60L * 60L;
	sec_hour = hour * 60L * 60L;
	sec_min = min * 60L;
					/* correct for Time Zone */
#ifdef BSD
	gettimeofday(&tv, &tz);
	tzone = tz.tz_minuteswest * 60L;
#else /* BSD */
	tzset();
	tzone = timezone;
#endif /* BSD */

	answer = sec_leap + sec_year + sec_mon + sec_mday + sec_hour + sec_min + sec + tzone;
					/* correct for Daylight Saving Time */
	tmbuf = localtime(&answer);
	dst = (tmbuf->tm_isdst) ? (-60L * 60L) : 0L;
	answer += dst;
	
	return(answer);
}

/*
 * Preserve the file modification times after the fclose()
 */

static void
set_mtime(target, mtime)
char *target;
long mtime;
{
#ifdef BSD
	struct timeval tv[2];

	if (mtime != 0L) {
		tv[0].tv_sec = mtime;
		tv[0].tv_usec = 0;
		tv[1].tv_sec = mtime;
		tv[1].tv_usec = 0;
		utimes(target, tv);
	}
#else /* BSD */
	struct utimbuf
#if 0 
	  {
		time_t actime;
		time_t modtime;
	}
#endif
 utbuf;

	if (mtime != 0L) {
		utbuf.actime = mtime;
		utbuf.modtime = mtime;
		utime(target, &utbuf);
	}
#endif /* BSD */
	return;
}
