/*
 * Mount an MSDOS disk
 *
 * written by:
 *
 * Alain L. Knaff			
 * knaff@mururoa.imag.fr		
 *
 * for mtools package, written by:
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>

#ifdef linux
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include "msdos.h"
#include "patchlevel.h"
#include <linux/fd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/fcntl.h>

extern int errno;

void
mmount(argc, argv)
int argc;
char *argv[];
{
	char drive;
	int pid;
	int status;

	mcwd = fix_mcwd();

	if (argc<2)
	  drive = get_drive("");
	else 
	  drive = get_drive(argv[1]);

	if (init(drive, O_RDONLY)) {
	  fprintf(stderr, "%s: Cannot initialize '%c:'\n", argv[0], drive);
	  exit(1);
	}

	close(fd);
	/* and finally mount it */
	switch((pid=fork())){
	case -1:
		fprintf(stderr,"fork failed\n");
		exit(1);
	case 0:
		close(2);
		open("/dev/null", O_RDWR);
		argv[1] = "mount" ;
		if ( argc > 2 )
			execvp("mount", argv + 1 );
		else
			execlp("mount", "mount", ans, 0);
		perror("exec mount");
		exit(1);
	default:
		while ( wait(&status) != pid );
	}	
	if ( WEXITSTATUS(status) == 0 )
		exit(0);
	argv[0] = "mount";
	argv[1] = "-r";
	if ( argc > 2 )
		execvp("mount", argv);
	else
		execlp("mount", "mount","-r", ans, 0);
	exit(1);
}

#else /* linux */

#include "msdos.h"

void
mmount()
{
  fprintf(stderr,"This command is only available for LINUX \n");
  exit(1);
}
#endif /* linux */

