/*
 * Change MSDOS file attribute flags
 *
 * Emmet P. Gray			US Army, HQ III Corps & Fort Hood
 * ...!uunet!uiucuxc!fthood!egray	Attn: AFZF-DE-ENV
 * fthood!egray@uxc.cso.uiuc.edu	Directorate of Engineering & Housing
 * 					Environmental Management Office
 * 					Fort Hood, TX 76544-5057
 */

#include <sys/types.h>
#include <sys/fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "msdos.h"

void
mbadblocks(argc, argv)
int argc;
char *argv[];
{
	int i;
	char drive;
	unsigned char in_buf[MAX_CLUSTER];
	int in_len;
	long start;

	if (argc < 2) {
		fprintf(stderr, "Mtools version %s, dated %s\n", 
			mversion, mdate);
		fprintf(stderr, "Usage: %s device\n", argv[0]);
		exit(1);
	}
	mcwd = fix_mcwd();

	drive = get_drive(argv[1]);
	if (init(drive, O_RDWR)) {
		fprintf(stderr,"%s: Cannot initialize '%c:'\n", argv[0], drive);
		exit(1);
	}

	in_len = clus_size * msector_size;
	for(i=0; i < dir_start + dir_len; i++){
		switch(disk_read(i, in_buf, in_len)){
		case -1:
			perror("early error");
			exit(1);
		case -2:
			fprintf(stderr,"end of file in file_read\n");
			exit(1);
		case 0:
			continue;
		}
	}
		
	for(i=2; i< num_clus + 2; i++){
		if(fat_decode(i))
			continue;
		start = (long) (i - 2) * clus_size + dir_start + dir_len;
		switch(disk_read(start, in_buf, in_len)){
		case -1:
			printf("Bad cluster %d found\n", i);
			fat_encode(i, 0xfff7);
			continue;
		case -2:
			fprintf(stderr,"end of file in file_read\n");
			exit(1);
		case 0:
			continue;
		}
	}
	fat_write();
	disk_flush();
	exit(0);
}
