/*
 * Do full cylinder buffered reads from slow devices.  Uses a simple
 * buffered read/delayed write algorithm.
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include "msdos.h"

unsigned char *disk_buf;		/* disk read/write buffer */
unsigned int disk_size;			/* size of read/write buffer */
long disk_current;			/* first sector in buffer */
long disk_cur_size=0;			/* the current size */
int disk_dirty;				/* is the buffer dirty? */

int lastwhere = -1;

int
disk_read(start, buf, len)
long start;
unsigned char *buf;
int len;
{
	register long i;
	int length;
	unsigned char *buf_ptr, *disk_ptr;
	long where, tail;
	int ret;

					/* don't use cache? */
	if (disk_size == 1) {
		where = (start * msector_size) + disk_offset;
		if (where != lastwhere &&
		    lseek(fd, where, 0) < 0) {
			perror("disk_read: lseek");
			exit(1);
		}
					/* read it! */
		lastwhere = -1;
		disk_cur_size = 0;
		if ((ret=read(fd, (char *) buf, (unsigned int) len)) == len){
			disk_cur_size = len;
			lastwhere = where + ret / msector_size;
			return 0;
		}
		else if ( ret < 0 )
			return -1;
		else
			return -2;
	}

	tail = start + (len / msector_size) - 1;
	for (i = start; i <= tail; i++) {
					/* a "cache" miss */
		if (i < disk_current || i >= disk_current + disk_cur_size) {
			if (disk_dirty)
				disk_flush();

			disk_current = i;
			where = (disk_current * msector_size) + disk_offset;
			length = (disk_size - (i % disk_size )) * msector_size;

					/* move to next location */
			if (where != lastwhere &&
			    lseek(fd, where, SEEK_SET) < 0) {
				perror("disk_read: lseek");
				exit(1);
			}

					/* read it! */
			ret=read(fd, (char *) disk_buf, (unsigned int) length);
			lastwhere = -1;
			disk_cur_size = 0;
			if ( ret < 0 )
				return -1;
			if (ret < msector_size)
				return -2;
			disk_cur_size = ret / msector_size;
			lastwhere = where + ret;
		}
					/* a cache hit... */
		buf_ptr = buf + ((i - start) * msector_size);
		disk_ptr = disk_buf + ((i - disk_current) * msector_size);
		memcpy((char *) buf_ptr, (char *) disk_ptr, msector_size);
	}
	return 0;
}
