/* AVI CODEC */

#ifndef _AVI_CODEC_H
#define _AVI_CODEC_H

#include "plugin.h"
#include "types.h"
#include "xmps_config.h"

char            *codec_path;

void            avi_init(void);
void            avi_about(void);
void            avi_configure(void);
void            avi_load_options(ConfigFile *cfg);
void            avi_save_options(ConfigFile *cfg);
int             avi_is_our_file(char *filename);
int             avi_open(char *filename);
void            avi_play();
void            avi_stop(void);
void            avi_pause(void);
void            avi_rewind(void);
void            avi_seek(int percent);
void            avi_get_volume();
void            avi_set_volume(int volume);
void            avi_file_info_box(char *filename);
void            avi_close(void);

void            avi_set_surface (int type, void *surface);
void            avi_set_callback (XMPS_DisplayCallback callback);

XMPSCodecStatus avi_get_status(void);
int             avi_has_file(void);
void            avi_video_info(XMPSVideoInfo *info);
void            avi_scale(int x, int y);
unsigned int    avi_get_actual_position(void);
unsigned int    avi_get_file_size(char *filename);
int             avi_move_into_display(int x, int y);
XMPSVideoFormat avi_get_available_formats(void);

#endif

