/********************************************************

	XMITSHM video renderer
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 18.06.2000

*********************************************************/
#include <config.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h>

#ifdef HAVE_LIBXXF86DGA
#include <X11/extensions/xf86dga.h>
#endif

#include <sys/ipc.h>
#include <sys/shm.h>

#include <qwidget.h>

int width, height;


class VideoRenderer
{
protected:
    QPaintDevice* dev;
    int m_w, m_h;
public:
    VideoRenderer(){}
    virtual int Create(QWidget* w, int width, int height) =0;
    virtual int Draw(QPainter* pm, const char* data) =0;
    virtual int sync() =0;
    virtual ~VideoRenderer(){}
};

extern void v555to565(short* dest, const short* src, int w, int h);


class MyPainter:public QPainter
{
public:
    MyPainter(QPaintDevice* qp):QPainter(qp){}
    virtual GC getGC(){return gc;}
};    
inline static void qSafeXDestroyImage( XImage *x )
{
    if ( x->data ) {
	free( x->data );
	x->data = 0;
    }
    XDestroyImage( x );
}
    


class ShmRenderer : public VideoRenderer
{
    bool	       xshminit;
    XShmSegmentInfo xshminfo;
    XImage	      *xshmimg;
    Pixmap	       xshmpm;
    GC 			gc;
public:
    ShmRenderer() : xshminit(0), xshmimg(0), xshmpm(0){}
    int Create(QWidget* w, int x, int y)
    {
        static int major, minor;
	static Bool pixmaps_ok;
        dev=(QPaintDevice*)w;
        Display *dpy = dev->x11Display();
        int dd	 = dev->x11Depth();
        Visual *vis	 = (Visual*)dev->x11Visual();
	m_w=x;
        m_h=y;
        width=x;
	height=y;
	
//	if(dd==24)dd=32;

	XGCValues xcg;
	xcg.graphics_exposures=false;
	gc=XCreateGC(dpy, dev->handle(), GCGraphicsExposures, &xcg); 
	if ( !XShmQueryVersion(dpy, &major, &minor, &pixmaps_ok) )
	    return -1;			// MIT Shm not supported

        bool ok;
        xshminfo.shmid = shmget( IPC_PRIVATE,
    			     width*height*4,
    			     IPC_CREAT | 0777 );
	ok = xshminfo.shmid != -1;
        if ( ok ) 
	{
    	    xshminfo.shmaddr = (char*)shmat( xshminfo.shmid, 0, 0 );
	    ok = xshminfo.shmaddr != 0;
        }
	xshminfo.readOnly = FALSE;
        if ( ok )
    	    ok = XShmAttach( dpy, &xshminfo );
        if ( !ok )
	{
//	qSafeXDestroyImage( xshmimg );
	    xshmimg = 0;
	    if ( xshminfo.shmaddr )
		shmdt( xshminfo.shmaddr );
	    if ( xshminfo.shmid != -1 )
		shmctl( xshminfo.shmid, IPC_RMID, 0 );
	    return -1;
	}
//        shmctl( xshminfo.shmid, IPC_RMID, 0 );

	xshmimg = XShmCreateImage( dpy, vis, dd, ZPixmap, xshminfo.shmaddr, &xshminfo, width, height );
//	xshmimg = XCreateImage(dpy, vis, dd, ZPixmap, 0, xshminfo.shmaddr,
//	    width, height, 8, width*((dd+1)/8));
	
        if ( !xshmimg )
		return -1;

//        if ( pixmaps_ok )
//    	    xshmpm = XShmCreatePixmap( dpy, DefaultRootWindow(dpy), xshmimg->data,
//				   &xshminfo, width, height, dd );

//	xshmpm = XShmCreatePixmap( dpy, dev->handle(), xshmimg->data,
//    				   &xshminfo, width, height, dd );
//	xshmpm = XCreatePixmap(dpy, dev->handle(), width, height, dd);
	printf("Video device: %d bpp, color masks %X,%X,%X\n",
	    dev->x11Depth(), vis->red_mask, vis->green_mask, vis->blue_mask);
        return 0;
    }

    virtual int Draw(QPainter* pm, const char* data)
    {
        char* outpic=xshmimg->data;
	if(outpic==0)	
	    return 0;
	if(data==0)
	    return 0;

        Display *dpy = dev->x11Display();
    	Visual *vis	 = (Visual*)dev->x11Visual();

	int bit_depth = dev->x11Depth();
//	if(bit_depth==24)bit_depth=32;
#warning x11Depth() sometimes returns 24 while actual depth is 32
	sync();
/*	if((bit_depth==15)||
	((bit_depth==16)&&((vis->red_mask==0x7c00) && (vis->green_mask==0x3e0) && (vis->blue_mask==0x1F))))
	{
	    int bpl=::width*2;
	    outpic+=bpl*(height-1);
	    for(int y=::height-1; y>0; y--)
    	    {
		memcpy(outpic, data, bpl);
		data+=bpl;
		outpic-=bpl;
	    }
	}
	else 	*/
	if((bit_depth==15)||(bit_depth==16))
        {   
//	    Visual* vis=(Visual*)dev->x11Visual();
//	    if((vis->red_mask==0xf800) && (vis->green_mask==0x7e0) && (vis->blue_mask==0x1F))
    	    v555to565((short*)outpic, (short*)data, ::width, ::height);
//	    else
//	    {
//		printf("Unknown video mode: bpp %d, red %X, green %X, blue %X\n",
//		bit_depth, vis->red_mask, vis->green_mask, vis->blue_mask);
//		exit(1);
//	    }	 
	}
	else
        {
	    bit_depth++;
    	    bit_depth/=8;
	    int bpl=::width*bit_depth;
	    outpic+=bpl*(height-1);
	    for(int y=::height-1; y>0; y--)
    	    {
		memcpy(outpic, data, bpl);
		data+=bpl;
		outpic-=bpl;
	    }
        }
//        XCopyArea( dpy, xshmpm, dev->handle(), ((MyPainter*)pm)->getGC(), 0, 0, width, height, 0, 0 );
	XShmPutImage(dpy, dev->handle(), gc, 
		xshmimg, 0, 0, 0, 0, width, height, true);
//	XPutImage( dpy, dev->handle(), ((MyPainter*)pm)->getGC(),
//	    xshmimg,  0, 0, 0, 0, width, height);
	return 0;
    }	
    virtual int sync()
    {
	Display *dpy = dev->x11Display();
//        Visual *vis	 = (Visual*)dev->x11Visual();
//	printf("%d:  %x %x %x %d\n", dev->x11Depth(), vis->red_mask, vis->green_mask, vis->blue_mask, vis->bits_per_rgb);	
        XSync(dpy, false);
	return 0;
    }
    virtual ~ShmRenderer()
    {
        if ( xshmimg == 0 )
	    return;
	Display *dpy = dev->x11Display();
        if ( xshmpm ) {
	    XFreePixmap( dpy, xshmpm );
	    xshmpm = 0;
        }
        XShmDetach( dpy, &xshminfo ); xshmimg->data = 0;
        qSafeXDestroyImage( xshmimg ); xshmimg = 0;
	shmdt( xshminfo.shmaddr );
        shmctl( xshminfo.shmid, IPC_RMID, 0 );
    }
};
#ifdef HAVE_LIBXXF86DGA
/********************************************************

	DGA video renderer
	Copyright 2000 Heinrich Langos

*********************************************************/

class DGARenderer: public VideoRenderer
{
  int ws;
  char* base;
  int vwidth,vheight;
  char *conversionbuf;
public:
    DGARenderer(){}
    virtual int Create(QWidget* w, int x, int y)
    {
        dev=(QPaintDevice*)w;
	m_w=x;
        m_h=y;
        width=x;
	height=y;
        Display *dpy = dev->x11Display();
        int      bit_depth  = dev->x11Depth();
        Visual  *vis = (Visual*)dev->x11Visual();
	
	bool have_dga=false;
	conversionbuf=(char *)malloc(x*y*((bit_depth+7)/8));
	
	int minor, major, bank, ram, flags;
	if(XF86DGAQueryExtension(dpy, &major, &minor))
	{	
    	    XF86DGAQueryDirectVideo(dpy, XDefaultScreen(dpy), &flags);
	    if(flags & XF86DGADirectPresent)
	    {
		have_dga=true;
		XF86DGAGetVideo(dpy, DefaultScreen(dpy),  &base, &ws, &bank, &ram);
		if(!base)
		    return -1;
	    }
	}
	    
	if(have_dga) {

      XF86DGADirectVideo(dpy, DefaultScreen(dpy),
			 XF86DGADirectGraphics);
//			     XF86DGADirectMouse|
//			     XF86DGADirectKeyb);
	  //	  XF86DGAGetViewPortSize(dpy, DefaultScreen(dpy),
	  //				 &vwidth, &vheight);
	  //	  XF86DGASetViewPort(dpy, DefaultScreen(dpy), 0, 0);
	  return 0;
	}
    }
    virtual int Draw(QPainter* pm, const char* data)
    {
      Display *dpy = dev->x11Display();
      int bit_depth	 = dev->x11Depth();
      int byteppx = (bit_depth+7)/8;
	//	printf("memcpy-ing %d lines to base %x, dd: %d\n",height,base,dd);
	//	printf("ws: %d width: %d \n", ws, width);


	if((bit_depth==15)||(bit_depth==16)) {
//	    Visual* vis=(Visual*)dev->x11Visual();
//	    if((vis->red_mask==0xf800) && (vis->green_mask==0x7e0) && (vis->blue_mask==0x1F))
    	    v555to565((short*)conversionbuf, (short*)data, ::width, ::height);
//	    else
//	    {
//		printf("Unknown video mode: bpp %d, red %X, green %X, blue %X\n",
//		bit_depth, vis->red_mask, vis->green_mask, vis->blue_mask);
//		exit(1);
//	    }	 
	}
	else
        {
	    bit_depth++;
    	    bit_depth/=8;
	    int bpl=::width*bit_depth;
	    conversionbuf+=bpl*(height-1);
	    for(int y=::height-1; y>0; y--)
    	    {
		memcpy(conversionbuf, data, bpl);
		data+=bpl;
		conversionbuf-=bpl;
	    }
        }

	for(int i=0; i<height; i++)
	  memcpy((void*)(base+i*ws*byteppx), conversionbuf+i*width*byteppx, width*byteppx);
//	for(int i=0; i<height; i++)
//	  memcpy((void*)(base+i*ws*byteppx), data+i*width*bytepp, width*byteppx);
	return 0;
    };
    virtual int sync() 
    {
	return 0;
    };
    virtual ~DGARenderer(){
        Display *dpy = dev->x11Display();
	XF86DGADirectVideo(dpy, DefaultScreen(dpy), 0);
	free(conversionbuf);
	}
};
#endif  /*HAVE_LIBXXF86DGA*/
