#include <qwidget.h>
#include <qscrollbar.h>
#include <qpushbutton.h>

#include <aviplay.h>

class MyWidget :public QWidget
{
	Q_OBJECT
friend void posfunc(double);
protected:
	void paintEvent(QPaintEvent *);
	AviPlayer* player;
	QScrollBar* scroller;
	int initialized;
//	int paused;

public:
	MyWidget(int, int);
	~MyWidget();
	virtual bool close( bool alsoDelete );
	int initPlayer(const char* filename);
	void updatePos(double v);
public slots:
	void reseek();
	void play()
	{
	    if(player)player->play();
	}
	void pause(bool state)
	{
	    if(player)player->pause(state);
	}
protected:
        QPushButton *b_pause;
        char* outpic;//local buffer
};
