/********************************************************

	555->565 weight conversion routine
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 01.07.2000

*********************************************************/

#ifndef MMX
extern void v555to565(short* dest, const short* src, int w, int h)
{
    dest+=w*(h-1);
    for(int i=0; i<h; i++)
    {
    	for(int j=0; j<w; j++)
	{
	    short q=*src++;
	    q+=(q&0xFFE0);
	    *dest++=q;
	}
	dest-=2*w;
    }
}
#else
extern void v555to565(short* dest, const short* src, int w, int h)
{
//    const char line[8]={0xE0, 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xE0, 0xFF};

//    const char line[8]={0x00, 0xF8, 0x00, 0xF8, 0xe0, 0xff, 0xe0, 0xff};
//    const char line[8]={0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xE0, 0xFF, 0xE0};	
    long long line=0xFFe0FFe0FFe0FFe0LL;	
    char qw[200];
    __asm__ __volatile__ ("fsave (%0)\n\t": :"r"(&qw));
    __asm__ __volatile__ ("emms\n\t");
    dest+=w*(h-1);
    for(int i=0; i<h; i++)
    {
    __asm__ __volatile__
    (
    "pushl 	%%ecx		\n\t"
    "pushl 	%%edx		\n\t"
    
    "movq       %3,     %%mm2   \n\t"
    "movl       %2,     %%edx   \n\t"
    "addl       %%eax,  %%edx   \n\t"
//loop:
    "pos0:\n\t"

    "movq       (%%eax),%%mm0   \n\t"
    "movq       %%mm0,  %%mm1   \n\t"
    "pand       %%mm2,  %%mm1   \n\t"
    "paddw      %%mm1,  %%mm0   \n\t"
    "movq       %%mm0,  (%%ecx) \n\t"
    "addl       $8,     %%eax   \n\t"
    "addl       $8,     %%ecx   \n\t"
    "cmpl       %%eax,  %%edx   \n\t"
    "ja 	pos0		\n\t"

    "popl 	%%edx		\n\t"
    "popl 	%%ecx		\n\t"
    :
    :"a"(src), "c"(dest), "m"(2*w), "m"(line)
    );
    src+=w;
    dest-=w;
    }
    __asm__ __volatile__ ("frstor (%0)\n\t": :"r"(&qw));
}
#endif
