/********************************************************

	Video encoder interface
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 23.06.2000

*********************************************************/


#include <stdio.h>
#include <math.h>

#include <wine/driver.h>
#include <wine/vfw.h>

#include <default.h>

class VideoEncoder
{
    HIC hic;
    int m_comp_id;    
    int m_iState;
    BITMAPINFOHEADER m_bh, m_obh;
    int m_iFrameNum;
    int m_iQual;
    int m_iKfFreq;
    char* m_prev;
    //following are DivX-specific values
    int m_dBitRate;
public:
    VideoEncoder():m_iState(0), m_dBitRate(0), m_prev(0){}
    ~VideoEncoder();
    //
    //  Should be called before operation
    //  Specifies source video format and compressor
    //  returns 0 if format is acceptable
    //
    int Init(int compressor, const char*);//BITMAPINFOHEADER*
    int Close();
    //
    // Starts encoding
    //
    int Start();
    //
    // Stops encoding
    //
    int Stop();
    //
    // Queries encoder about desired buffer size for compression
    // You should allocate at least this much bytes for dest ( arg for EncodeFrame )
    //
    int QueryOutputSize();
    BITMAPINFOHEADER QueryOutputFormat() const
    {
	return m_obh;
    }	
    //
    // Encodes single frame
    // On success, is_keyframe contains 0 if frame was encoded into delta frame, otherwise AVIIF_KEYFRAME (?)
    // size receives size of compressed frame
    //
    int EncodeFrame(char* src, char* dest, int* is_keyframe, int* size, int* lpckid=0);
    //
    // Quality takes values from 0 to 10000, 10000 the best
    //
    int SetQuality(int quality);
    int SetKeyFrame(int frequency);
    static int SetExtendedAttr(int id, char* attribute, int value);
protected:  
    static int GetRegValue(int fccHandler, const char* name, int* place);                      
    static int SetRegValue(int fccHandler, const char* name, int value);                      
};    
    