/********************************************************

         Audio decoder interface
	 Copyright 2000 Eugene Smith (divx@euro.ru)
	 Last modified: 13.07.2000

*********************************************************/
	 



#include <audiodecoder.h>
#include "gsm61/gsm61dec.h"
#include "mpeg/mpegsound.h"
#include "pcm/pcm.h"
#include "wma/wma.h"
int AudioDecoder::Init(WAVEFORMATEX* format, void* extension)
{
    if(format==NULL)
	return -1;
    if(m_status>0)
	return -1;
    switch(format->wFormatTag)
    {
	case 0x01://PCM
	    decoder=new PCM_Decoder;
	    printf("Audio in PCM format\n");
	    break;
	case 0x31://MS GSM 6.10
        case 0x32://MSN Audio
	    decoder=new MSGSM_Decoder;
	    printf("Audio in MS GSM 6.10 format\n");
	    break;
	case 0x50://MPEG Layer-1,2    
	    decoder=new Mpegtoraw;
	    printf("Audio in MPEG Layer-1/2 format\n");
	    break;
	case 0x55://MPEG Layer-3
	    decoder=new Mpegtoraw;
	    printf("Audio in MPEG Layer-3 format\n");
	    break;
	case 0x160:
	case 0x161://DivX audio
	    decoder=new WMA_Decoder;
	    printf("Audio in DivX WMA format\n");
	    break;
	default:
	    printf("Audio format ID %d unsupported\n", format->wFormatTag);
	    break;
    }
    if(decoder)
    {
	if(decoder->Init(format, extension)==0)
	{
	    m_status=1;
    	    return 0;
	}    
    }

    return -1;
}
int AudioDecoder::decode_frames(unsigned char* in_data, unsigned char* out_data,
    unsigned& in_size, unsigned out_size, out_format* format)
{
    if(m_status==0)
	return 0;
    if(decoder)
	return decoder->decode_frames(in_data, out_data, in_size, out_size, format);
    else
    {
	in_size=0;
	return 0; 
    }	   
}
int AudioDecoder::Close()
{
    if(m_status==0)
	return -1;
    if(decoder)
    {
	decoder->Close();
	delete decoder;
	decoder=0;
	m_status=0;
	return 0;
    }
    return -1;
}

  	      