/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.metadata.loader.reflection.test;

import java.lang.reflect.Method;

import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.loader.reflection.support.NotPublic;
import org.jboss.test.metadata.loader.reflection.support.SuperClassOfNotPublic;
import org.jboss.test.metadata.shared.support.ExpectedAnnotations;
import org.jboss.test.metadata.shared.support.NotPresentAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotation;

/**
 * AnnotatedElementLoaderNotPublicUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class AnnotatedElementLoaderNotPublicUnitTestCase extends AbstractMetaDataTest
{
   public AnnotatedElementLoaderNotPublicUnitTestCase(String name)
   {
      super(name);
   }
   
   public void testNotPublicConstructor() throws Exception
   {
      MetaData metaData = createMetaData();
      testTestAnnotation(metaData.getComponentMetaData(new ConstructorSignature()));
   }
   
   public void testNotPublicMethod() throws Exception
   {
      MetaData metaData = createMetaData();
      testTestAnnotation(metaData.getComponentMetaData(new MethodSignature("notPublic")));
   }
   
   public void testNotPublicField() throws Exception
   {
      MetaData metaData = createMetaData();
      testTestAnnotation(metaData.getComponentMetaData(new FieldSignature("notPublic")));
   }
   
   public void testNotPublicMethodSuperClass() throws Exception
   {
      MetaData metaData = createMetaData();
      testTestAnnotation(metaData.getComponentMetaData(new MethodSignature("notPublicSuperClass")));
   }
   
   public void testNotPublicFieldSuperClass() throws Exception
   {
      MetaData metaData = createMetaData();
      testTestAnnotation(metaData.getComponentMetaData(new FieldSignature("notPublicSuperClass")));
   }

   public void testSameName() throws Exception
   {
      MetaData metaData = createMetaData();
      Method superMethod = SuperClassOfNotPublic.class.getDeclaredMethod("sameName");
      MetaData superMethodMetaData = metaData.getComponentMetaData(Signature.getSignature(superMethod));
      assertAnnotation(superMethodMetaData, TestAnnotation.class);
      
      Method method = NotPublic.class.getDeclaredMethod("sameName");
      MetaData methodMetaData = metaData.getComponentMetaData(Signature.getSignature(method));
      assertNoAnnotation(methodMetaData, TestAnnotation.class);
   }
   
   protected void testTestAnnotation(MetaData metaData) throws Exception
   {
      assertNotNull(metaData);

      ExpectedAnnotations expectedAnnotations = emptyExpectedAnnotations();

      assertAnnotation(metaData, TestAnnotation.class);
      assertNoAnnotation(metaData, NotPresentAnnotation.class);
      
      expectedAnnotations.add(TestAnnotation.class);
      assertAllAnnotations(metaData, expectedAnnotations, false);
   }

   protected MetaData createMetaData()
   {
      AnnotatedElementMetaDataLoader loader = new AnnotatedElementMetaDataLoader(NotPublic.class);
      return new MetaDataRetrievalToMetaDataBridge(loader);
   }
}
