/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.metadata.loader.reflection.test;

import java.lang.reflect.Method;

import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.loader.reflection.support.TestAnnotationWithValue;
import org.jboss.test.metadata.loader.reflection.support.TestSub;
import org.jboss.test.metadata.loader.reflection.support.TestSuper;

/**
 * AnnotatedElementLoaderNotPublicUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class AnnotatedElementLoaderDeclaredMethodSignatureUnitTestCase extends AbstractMetaDataTest
{
   public AnnotatedElementLoaderDeclaredMethodSignatureUnitTestCase(String name)
   {
      super(name);
   }
   
   public void testSubClassMethodConstructor() throws Exception
   {
      MetaData metaData = createMetaData();
      Method method = TestSub.class.getDeclaredMethod("doSomething");
      doTest(metaData.getComponentMetaData(new DeclaredMethodSignature(method)), "sub");
   }
   
   public void testSubClassStringConstructor() throws Exception
   {
      MetaData metaData = createMetaData();
      doTest(metaData.getComponentMetaData(new DeclaredMethodSignature(TestSub.class.getName(), "doSomething")), "sub");
   }
   
   public void testSuperClassMethodConstructor() throws Exception
   {
      MetaData metaData = createMetaData();
      Method method = TestSuper.class.getDeclaredMethod("doSomething");
      doTest(metaData.getComponentMetaData(new DeclaredMethodSignature(method)), "super");
   }
   
   public void testSuperClassStringConstructor() throws Exception
   {
      MetaData metaData = createMetaData();
      doTest(metaData.getComponentMetaData(new DeclaredMethodSignature(TestSuper.class.getName(), "doSomething")), "super");
   }
   
   protected void doTest(MetaData metaData, String expected) throws Exception
   {
      assertNotNull(metaData);

      TestAnnotationWithValue annotation = metaData.getAnnotation(TestAnnotationWithValue.class);
      assertNotNull(annotation);
      assertEquals(expected, annotation.value());
   }

   protected MetaData createMetaData()
   {
      AnnotatedElementMetaDataLoader loader = new AnnotatedElementMetaDataLoader(TestSub.class);
      return new MetaDataRetrievalToMetaDataBridge(loader);
   }
}
