/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

/**
 * This is returned on various errors (or successes).  This contains a
 * message and a source object which failed or succeeded.
 * <p>
 * @author Elias Ross
 * @version 1.0
 */
public class ProvResult 
	implements ProvEntity
{
	/**
	 * Failed entity.
	 */
	Object entity;

	/**
	 * Explaination.
	 */
	String message;
    
	/**
	 * Construct a ProvResult with a message and entity.
	 * @param message message to display.
	 */
    public ProvResult(String message, Object entity) 
	{
		this.message = message;
		this.entity = entity;
	}

	/**
	 * Gets the entity related to the result.
	 * @return an entity
	 */
	public Object getEntity() { 
		return entity; 
	}

	/**
	 * Gets the message of the result.
	 * @return a message
	 */
	public String getMessage() { 
		return message; 
	}

	/**
	 * Gets a debug message representation of this object.
	 */
	public String toString() { 
		return "ProvResult: " + message + " -- For: " + entity; 
	}
}
