/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AmazonWebServiceClient {
    protected URI endpoint;
    protected ClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected final List<RequestHandler> requestHandlers;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration);
        this.requestHandlers = Collections.synchronizedList(new LinkedList());
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.clientConfiguration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration);
    }

    public void shutdown() {
        this.client.shutdown();
    }

    @Deprecated
    protected <T> HttpRequest convertToHttpRequest(Request<T> request, HttpMethodName methodName) {
        HttpRequest httpRequest = new HttpRequest(methodName);
        for (Map.Entry<String, String> parameter : request.getParameters().entrySet()) {
            httpRequest.addParameter(parameter.getKey(), parameter.getValue());
        }
        for (Map.Entry<String, String> parameter : request.getHeaders().entrySet()) {
            httpRequest.addHeader(parameter.getKey(), parameter.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        httpRequest.setOriginalRequest(request.getOriginalRequest());
        return httpRequest;
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.remove(requestHandler);
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return executionContext;
    }
}

