#!/usr/bin/env python
#
#
#    This file is part of DvdRip Queue
#    
#    DvdRip Queue is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    DvdRip Queue is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with DvdRip Queue.  If not, see <http://www.gnu.org/licenses/>.
#    

import os
from ConfigParser import ConfigParser

def getPref(prefName, getDefaultValue = False):
    #Get home directory for datadirectory preference default value
    homeDir = os.path.expanduser("~")
    
    # if the config file exists...
    if (os.path.exists(homeDir + "/.dvdrip-queue") and os.path.isfile(homeDir + "/.dvdrip-queue")):
        
        # make an instance of the config-file parser and load it
        configdict = ConfigParser()
        configdict.read(homeDir + "/.dvdrip-queue")
        
    try:
        # If the user wants the default value, just raise an exception
        # to simulate not having a prefs file
        if getDefaultValue == True:
            raise
        # try to load the preference from the config file
        prefValue = os.path.expanduser(configdict.defaults()[prefName])
    
    except:
        # If the preference isn't found, load a default instead
        if prefName == "datadirectory":
            if (os.path.exists(homeDir + "/dvdrip-data") and os.path.isdir(homeDir + "/dvdrip-data")):
                prefValue = homeDir + "/dvdrip-data"
            else:
                prefValue = homeDir
        
        elif prefName == "maxencodetime":
            prefValue = 360.0
        
    
    # return the value of the preference
    return prefValue