<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authn_socache - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authn_socache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_socache.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_socache.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Gre un cache des donnes d'authentification pour diminuer
la charge des serveurs d'arrire-plan</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authn_socache_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authn_socache.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Versions 2.3 et ultrieures</td></tr></table>
<h3>Sommaire</h3>

    <p>Maintient un cache des donnes d'authentification afin que la
    recherche d'un nouveau serveur d'arrire-plan pour chaque requte
    authentifie ne soit plus ncessaire.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authncachecontext">AuthnCacheContext</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authncacheenable">AuthnCacheEnable</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authncacheprovidefor">AuthnCacheProvideFor</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authncachesocache">AuthnCacheSOCache</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authncachetimeout">AuthnCacheTimeout</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#intro">Mise en cache des donnes d'authentification</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usage">Utilisation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dev">La mise en cache avec les modules tiers</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="intro" id="intro">Mise en cache des donnes d'authentification</a></h2>
    <p>Certains utilisateurs qui mettent oeuvre une authentification
    lourde s'appuyant par exemple sur des requtes SQL
    (<code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>) ont signal une charge induite
    inacceptable sur leur fournisseur d'authentification. Cela se
    produit typiquement dans le cas o une page HTML contient des
    centaines d'objets (images, scripts, pages de styles, media,
    etc...), et o une requte pour cette page gnre des centaines de
    sous-requtes  effet immdiat pour des contenus supplmentaires
    authentifis.</p>
    <p>Pour rsoudre ce problme, mod_authn_socache fournit une solution
    qui permet de maintenir un cache des donnes d'authentification.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="usage" id="usage">Utilisation</a></h2>
    <p>Le cache d'authentification doit tre utilis lorsque les
    requtes d'authentification induisent une charge significative sur le
    serveur, le serveur d'arrire-plan ou le rseau. Cette mise en cache
    n'apportera probablement aucune amlioration dans le cas d'une
    authentification  base de fichier (<code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>)
    ou de base de donnes dbm (<code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code>) car ces
    mthodes sont de par leur conception rapides et lgres (la mise en
    cache peut cependant s'avrer utile dans le cas o le fichier est
    situ sur un montage rseau). Les fournisseurs d'authentification
    bass sur SQL ou LDAP ont plus de chances de tirer parti de cette
    mise en cache, en particulier lorsqu'un problme de performances est
    dtect. <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> grant son propre cache,
    seul <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code> est concern par notre sujet.</p>
    <p>Les principales rgles  appliquer pour la mise en cache sont :</p>
    <ol><li>Inclure le fournisseur pour lequel vous voulez effectuer une
    mise en cache dans une directive
    <code class="directive">AuthnCacheProvideFor</code>.</li>
        <li>Mettre <var>socache</var> avant le fournisseur pour lequel
	vous voulez effectuer une mise en cache dans votre directive
	<code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code>
	ou <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code>.</li>
    </ol>
    <p>Voici un exemple simple permettant d'acclrer
    <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code> et utilisant dbm comme moteur de la
    mise en cache :</p>
    <pre class="prettyprint lang-config">
&lt;Directory /usr/www/myhost/private&gt;
    AuthType Basic
    AuthName "Cached Authentication Example"
    AuthBasicProvider socache dbd
    AuthDBDUserPWQuery "SELECT password FROM authn WHERE user = %s"
    AuthnCacheProvideFor dbd
    AuthnCacheContext dbd-authn-example
    AuthnCacheSOCache dbm
    Require valid-user
&lt;/Directory&gt;
    </pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dev" id="dev">La mise en cache avec les modules tiers</a></h2>
    <p>Les dveloppeurs de modules doivent savoir que la mise en cache
    avec mod_authn_socache doit tre active dans leurs modules. La
    fonction simple de l'API <var>ap_authn_cache_store</var> permet de
    mettre en cache les donnes d'authentification qu'un fournisseur
    vient de rechercher ou de gnrer. Vous trouverez des exemples
    d'utilisation  <a href="http://svn.eu.apache.org/viewvc?view=revision&amp;revision=957072">r957072</a>, o trois fournisseurs authn sont activs pour la mise
    en cache.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthnCacheContext" id="AuthnCacheContext">AuthnCacheContext</a> <a name="authncachecontext" id="authncachecontext">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie une chane de contexte  utiliser dans la cl du
cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthnCacheContext <var>directory|server|chane-personnalise</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>directory</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_socache</td></tr>
</table>
    <p>Cette directive permet de spcifier une chane  utiliser avec le
    nom d'utilisateur fourni (et le domaine d'authentification - realm -
    dans le cas d'une authentification  base de condenss) lors de la
    construction d'une cl de cache. Ceci permet de lever l'ambigut
    entre plusieurs noms d'utilisateurs identiques servant diffrentes
    zones d'authentification sur le serveur.</p>
    <p>Il y a deux valeurs spciales pour le paramtre : <var>directory</var>,
    qui utilise le contexte de rpertoire de la requte comme chane, et
    <var>server</var>, qui utilise le nom du serveur virtuel.</p>
    <p>La valeur par dfaut est <var>directory</var>, qui est aussi la
    dfinition la plus courante. Ceci est cependant loin d'tre optimal,
    car par exemple, <var>$app-base</var>, <var>$app-base/images</var>,
    <var>$app-base/scripts</var> et <var>$app-base/media</var>
    possderont chacun leur propre cl de cache. Il est prfrable
    d'utiliser le fournisseur de mot de passe : par exemple un fichier
    <var>htpasswd</var> ou une table de base de donnes.</p>
    <p>Les contextes peuvent tre partags entre diffrentes zones du
    serveur, o les donnes d'authentification sont partages. Ceci est
    cependant susceptible de crer des trous de scurit de type
    cross-site ou cross-application, et cette directive n'est donc pas
    disponible dans les contextes <var>.htaccess</var>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthnCacheEnable" id="AuthnCacheEnable">AuthnCacheEnable</a> <a name="authncacheenable" id="authncacheenable">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la mise en cache de l'authentification en tout
endroit</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthnCacheEnable</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>None</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_socache</td></tr>
</table>
    <p>Normalement, cette directive n'est pas ncessaire : l'activation
    est implicite si la mise en cache de l'authentification a t
    active en tout autre endroit du fichier <var>httpd.conf</var>. Par
    contre, si cette mise en cache n'a pas t active, par dfaut, elle
    ne sera pas initialise, et ne sera donc pas disponible dans un
    contexte de fichier <var>.htaccess</var>. Cette directive permet
    d'tre sr que la mise en cache a bien t active et pourra
    donc tre utilise dans les fichiers <var>.htaccess</var>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthnCacheProvideFor" id="AuthnCacheProvideFor">AuthnCacheProvideFor</a> <a name="authncacheprovidefor" id="authncacheprovidefor">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le fournisseur pour lequel on veut effectuer une
mise en cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthnCacheProvideFor <var>fournisseur-authn</var> [...]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>None</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_socache</td></tr>
</table>
    <p>Cette directive permet de spcifier un ou plusieurs fournisseurs
    pour le(s)quel(s) on veut effectuer une mise en cache. Les donnes
    d'authentification trouves par un fournisseur non spcifi dans une
    directive AuthnCacheProvideFor ne seront pas mises en cache.</p>

    <p>Par exemple, pour mettre en cache les donnes d'authentification
    trouves par <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code> ou par un fournisseur
    personnalis <var>mon-fournisseur</var>, et ne pas mettre en cache
    celles trouves par les fournisseurs lgers comme file ou dbm :</p>
    <pre class="prettyprint lang-config">
AuthnCacheProvideFor dbd mon-fournisseur
    </pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthnCacheSOCache" id="AuthnCacheSOCache">AuthnCacheSOCache</a> <a name="authncachesocache" id="authncachesocache">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Slectionne le fournisseur socache d'arrire-plan 
utiliser</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthnCacheSOCache <var>nom-fournisseur[:arguments-fournisseur]</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>None</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_socache</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Les paramtres optionnels du fournisseur sont disponibles
depuis la version 2.4.7 du serveur HTTP Apache</td></tr>
</table>
    <p>Cette dfinition s'applique  l'ensemble du serveur et permet de
    slectionner un fournisseur pour le <a href="../socache.html">cache
    d'objets partags</a>, ainsi que des arguments ventuels pour ce
    fournisseur. Les fournisseurs disponibles sont, entre autres, "dbm",
    "dc", "memcache", ou "shmcb", chacun d'entre eux ncessitant le chargement
    du module appropri. Si elle est
    absente, c'est la valeur par dfaut pour votre plate-forme qui sera
    utilise.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthnCacheTimeout" id="AuthnCacheTimeout">AuthnCacheTimeout</a> <a name="authncachetimeout" id="authncachetimeout">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une dure de vie pour les entres du cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthnCacheTimeout <var>dure-de-vie</var> (secondes)</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>300 (5 minutes)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_socache</td></tr>
</table>
    <p>La mise en cache des donnes d'authentification peut constituer
    un trou de scurit, bien qu'un mise en cache de courte dure ne
    posera probablement pas de problme. En gnral, il est conseill de
    conserver les entres du cache de faon  ce que la charge du serveur
    d'arrire-plan reste normale, mais pas plus longtemps, bien
    qu'une dure de vie plus longue puisse tre ncessaire si les
    changements d'utilisateurs et de mots de passe sont peu frquents.
    La dure de vie par dfaut de 300 secondes (5 minutes) est  la fois
    raisonnable et suffisamment importante pour rduire la charge d'un
    serveur d'arrire-plan comme dbd (requtes SQL).</p>
    <p>Cette dure de vie ne doit pas tre confondue avec la dure de
    vie de session qui est un tout autre sujet. Cependant, vous devez
    utiliser votre logiciel de gestion de session pour vrifier si les
    donnes d'authentification mises en cache peuvent allonger
    accidentellement une session, et en tenir compte lorsque vous
    dfinissez la dure de vie.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_socache.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_socache.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authn_socache.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>