/*
 This file is part of GNU Taler
 (C) 2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { AmountString } from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { CoinConfig, defaultCoinConfig } from "../harness/denomStructures.js";
import {
  GlobalTestState,
  setupDb,
} from "../harness/harness.js";
import { createSimpleTestkudosEnvironmentV3 } from "harness/environments.js";

/**
 * Test that run-until-done of taler-wallet-cli terminates.
 */
export async function runWalletCliTerminationTest(t: GlobalTestState) {
  const db = await setupDb(t);

  const coinConfig: CoinConfig[] = defaultCoinConfig.map((x) => x("TESTKUDOS"));

  const {
    exchange,
    bankClient,
    walletClient,
  } = await createSimpleTestkudosEnvironmentV3(t, coinConfig, {});

  await walletClient.call(WalletApiOperation.WithdrawTestBalance, {
    corebankApiBaseUrl: bankClient.baseUrl,
    exchangeBaseUrl: exchange.baseUrl,
    amount: "TESTKUDOS:20" as AmountString,
  });
}

runWalletCliTerminationTest.suites = ["wallet"];
