/*
 * This file is part of LibEuFin.
 * Copyright (C) 2025 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

import org.junit.Test
import tech.libeufin.common.*
import kotlin.test.assertEquals

class IbanTest {
    @Test
    fun valid() {
        for ((iban, bban) in VALID_IBAN) {
            val parsed = IBAN.parse(iban)
        }
    }

    @Test
    fun roundtrip() {
        for (country in Country.values()) {
            val gen = IBAN.rand(country)
            println("$gen")
            val parsed = IBAN.parse("$gen")
            println("$gen $parsed")
            assertEquals(gen, parsed)
        }
    }
}