/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini, bettini@gnu.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <iomanip>

#include "linenogen.h"

#include "linenumdigit.h"
#include "globalostream.h"

bool LineNumberDecorator::generated_newline = true;
unsigned int LineNumberDecorator::lineno = 1;

LineNumberDecorator::LineNumberDecorator( TextGenerator *t, 
                                          CharTranslator *c ) :
  TextDecorator (t, c)
{
}

void
LineNumberDecorator::generate_lineno()
{
  if (generated_newline && line_num_digit > 0)
    {
      (*sout) << std::setw (line_num_digit) << std::setfill ('0') 
              << lineno << ": ";
      generated_newline = false;
    }
}

void
LineNumberDecorator::startDecorate()
{
  generate_lineno ();
}

void
LineNumberDecorator::generate(const char *s)
{
  generate_lineno ();
  TextGenerator::generate (s);
}

void
LineNumberDecorator::generate_preproc(const char *s)
{
  generate_lineno ();
  TextGenerator::generate_preproc (s);
}

void
LineNumberDecorator::generateln(const char *s)
{
  TextDecorator::generateln (s);
  generated_newline = true;
  ++lineno;
}

void
LineNumberDecorator::reset()
{
  generated_newline = true;
  lineno = 1;
}
