/* yourcode.h

   written by Frederic Bois
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.yourcode.h
    Revision:  1.3
        Date:  28 Jan 1995
     Modtime:  03:44:05
      Author:  @a
   -- SCCS  ---------

   Header file for the "yourcode" file, containing customizable routines.
*/

#ifndef _YOURCODE_H_
#define _YOURCODE_H_

/* -----------------------------------------------------------------------------
   Inclusions
*/

#include "sim.h"


/* -----------------------------------------------------------------------------
   Typedefs
*/

typedef struct tagMCPREDOUT {
  long nbrdy;    /* number of kinetic ys */
  double *pred;  /* pointer to the data */
  int passflag;  /* typically a pass/fail flag */
} MCPREDOUT, *PMCPREDOUT;


/* -----------------------------------------------------------------------------
   Prototypes  */

void DoStep_by_Step (void /* double t, long *neq, double *y */);
void OutspecToLinearArray (PANALYSIS panal, PMCPREDOUT pMCPredOut);
void TransformPred (PANALYSIS, PMCPREDOUT);

void Init_ksi (long nParms, long nSubjects, double **pdKsi_prior, 
               double **pdKsi);
void Init_mu (PMONTECARLO pmc, long nParms, long nSubjects, double **pdMu);
void Init_sigma (PANALYSIS panal, long nData, double **pdSigma, 
                 long *pnSigma, long **plSigmaIndex);
void Sample_ksi (PMONTECARLO pmc, long nParms, long nSubjects, 
                 double **pdTheta, double *pdMu, double *pdKsi_prior, 
                 double *pdKsi);
void Sample_mu (PMONTECARLO pmc, long nParms, long nSubjects, double **pdTheta, 
                double *pdKsi, double *pdMu);
void Sample_sigma (PANALYSIS panal, double *pdData, double *pdPred, 
                   long nSubjects, long *plSubjectsIndex, long *plSigmaIndex, 
                   long nData, long nSigma, double **pdTheta, double *pdSigma);
double LnLikelihood (PANALYSIS panal, double *pdData, double *pdPred, 
                     long *plSigmaIndex, long nData, double *pdSigma, 
                     long nSigma);

#endif /* _YOURCODE_H_ */

/* End */

